/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.SignalHeadManager;
import jmri.implementation.DccSignalHead;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DccSignalHeadXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(DccSignalHeadXml.class);

    @Override
    public Element store(Object o) {
        DccSignalHead p = (DccSignalHead)o;
        Element element = new Element("signalhead");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        if (p.useAddressOffSet()) {
            element.addContent((Content)new Element("useAddressOffSet").addContent("yes"));
        } else {
            element.addContent((Content)new Element("useAddressOffSet").addContent("no"));
        }
        element.addContent((Content)new Element("packetsendcount").addContent(Integer.toString(p.getDccSignalHeadPacketSendCount())));
        int i = 0;
        while (i < p.getValidStates().length) {
            String aspect = p.getValidStateKeys()[i];
            Element el = new Element("aspect");
            el.setAttribute("defines", aspect);
            el.addContent((Content)new Element("number").addContent(Integer.toString(p.getOutputForAppearance(p.getValidStates()[i]))));
            element.addContent((Content)el);
            ++i;
        }
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        DccSignalHead h = uname == null ? new DccSignalHead(sys) : new DccSignalHead(sys, uname);
        this.loadCommon(h, shared);
        if (shared.getChild("useAddressOffSet") != null && shared.getChild("useAddressOffSet").getText().equals("yes")) {
            h.useAddressOffSet(true);
        }
        if (shared.getChild("packetsendcount") != null) {
            h.setDccSignalHeadPacketSendCount(Integer.parseInt(shared.getChild("packetsendcount").getValue()));
        }
        List list = shared.getChildren("aspect");
        for (Element e : list) {
            String aspect = e.getAttribute("defines").getValue();
            int number = -1;
            try {
                String value = e.getChild("number").getValue();
                number = Integer.parseInt(value);
            }
            catch (Exception exception) {
                log.error("failed to convert DCC number");
            }
            int indexOfAspect = -1;
            int i = 0;
            while (i < h.getValidStates().length) {
                if (h.getValidStateKeys()[i].equals(aspect) || h.getValidStateNames()[i].equals(aspect)) {
                    indexOfAspect = i;
                    break;
                }
                ++i;
            }
            if (indexOfAspect == -1) continue;
            h.setOutputForAppearance(h.getValidStates()[indexOfAspect], number);
        }
        InstanceManager.getDefault(SignalHeadManager.class).register(h);
        return true;
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }
}

