/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.jmrix.AbstractProgrammerFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoIndexTcsProgrammerFacade
extends AbstractProgrammerFacade
implements ProgListener {
    static final String indexPI = "201";
    static final String indexSI = "202";
    static final String valMSB = "203";
    static final String valLSB = "204";
    static final String readStrobe = "204";
    static final String format2Flag = "T2CV";
    static final String format3Flag = "T3CV";
    static final int readOffset = 100;
    int _val;
    String _cv;
    int valuePI;
    int valueSI;
    int valueMSB;
    int valueLSB;
    int _startVal;
    int _startMSB;
    int _startLSB;
    private ProgListener _usingProgrammer = null;
    ProgState state = ProgState.NOTPROGRAMMING;
    int upperByte;
    private static final Logger log = LoggerFactory.getLogger(TwoIndexTcsProgrammerFacade.class);

    public TwoIndexTcsProgrammerFacade(Programmer prog) {
        super(prog);
    }

    private void parseCV(String cv) throws IllegalArgumentException {
        this.valuePI = -1;
        this.valueSI = -1;
        if (cv.contains(".")) {
            String[] splits = cv.split("\\.");
            if (splits.length == 3 && splits[0].equals(format2Flag)) {
                this.valuePI = Integer.parseInt(splits[1]);
                this.valueSI = Integer.parseInt(splits[2]);
            } else if (splits.length == 4 && splits[0].equals(format3Flag)) {
                this.valuePI = Integer.parseInt(splits[1]);
                this.valueMSB = Integer.parseInt(splits[2]);
                this.valueLSB = Integer.parseInt(splits[3]);
            } else {
                this._cv = cv;
            }
        } else {
            this._cv = cv;
        }
    }

    @Override
    public synchronized void writeCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this._val = val;
        this.useProgrammer(p);
        this.parseCV(CV);
        this.upperByte = 0;
        if (this.valuePI == -1) {
            this.state = ProgState.PROGRAMMING;
            this.prog.writeCV(this._cv, val, this);
        } else {
            this.state = ProgState.DOSIFORWRITE;
            this.prog.writeCV(indexPI, this.valuePI, this);
        }
    }

    @Override
    public synchronized void readCV(String CV, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p, 0);
    }

    @Override
    public synchronized void readCV(String CV, ProgListener p, int startVal) throws ProgrammerException {
        this.useProgrammer(p);
        this.parseCV(CV);
        this._startVal = startVal;
        this._startMSB = startVal / 256;
        this._startLSB = startVal % 256;
        this.upperByte = 0;
        if (this.valuePI == -1) {
            this.state = ProgState.PROGRAMMING;
            this.prog.readCV(this._cv, this, startVal);
        } else {
            this.state = this.valueSI == -1 ? ProgState.DOMSBFORREAD : ProgState.DOSIFORREAD;
            this.prog.writeCV(indexPI, this.valuePI + 100, this);
        }
    }

    @Override
    public synchronized void confirmCV(String CV, int startVal, ProgListener p) throws ProgrammerException {
        this.useProgrammer(p);
        this.parseCV(CV);
        this._startVal = startVal;
        this._startMSB = startVal / 256;
        this._startLSB = startVal % 256;
        this.upperByte = 0;
        if (this.valuePI == -1) {
            this.state = ProgState.PROGRAMMING;
            this.prog.confirmCV(this._cv, startVal, this);
        } else {
            this.state = this.valueSI == -1 ? ProgState.DOMSBFORREAD : ProgState.DOSIFORREAD;
            this.prog.writeCV(indexPI, this.valuePI + 100, this);
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            if (log.isInfoEnabled()) {
                log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            }
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    @Override
    public synchronized void programmingOpReply(int value, int status) {
        if (log.isDebugEnabled()) {
            log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        }
        if (this._usingProgrammer == null) {
            log.error("No listener to notify, reset and ignore");
            this.state = ProgState.NOTPROGRAMMING;
            return;
        }
        int interval = 150;
        ActionListener taskPerformer = new ActionListener(value, status){
            final int myValue;
            final int myStatus;
            {
                this.myValue = n;
                this.myStatus = n2;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                TwoIndexTcsProgrammerFacade.this.processProgrammingOpReply(this.myValue, this.myStatus);
            }
        };
        Timer t = new Timer(interval, taskPerformer);
        t.setRepeats(false);
        t.start();
    }

    protected void processProgrammingOpReply(int value, int status) {
        if (status != 0) {
            log.debug("Reset and pass abort up");
            ProgListener temp = this._usingProgrammer;
            this._usingProgrammer = null;
            this.state = ProgState.NOTPROGRAMMING;
            temp.programmingOpReply(value, status);
            return;
        }
        switch (this.state) {
            case DOSIFORREAD: {
                try {
                    this.state = ProgState.DOSTROBEFORREAD;
                    this.prog.writeCV(indexSI, this.valueSI, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing write SI for read", (Throwable)e);
                }
                break;
            }
            case DOSTROBEFORREAD: {
                try {
                    this.state = ProgState.DOREADFIRST;
                    this.prog.writeCV("204", 100, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing write strobe for read", (Throwable)e);
                }
                break;
            }
            case DOREADFIRST: {
                try {
                    this.state = ProgState.FINISHREAD;
                    this.prog.readCV(valMSB, this, this._startMSB);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing read first", (Throwable)e);
                }
                break;
            }
            case FINISHREAD: {
                try {
                    this.state = ProgState.PROGRAMMING;
                    if (this.valuePI != -1 && this.valueSI == -1) {
                        this.upperByte = 0;
                        this.prog.readCV(indexSI, this, this._startVal);
                        break;
                    }
                    this.upperByte = value;
                    this.prog.readCV("204", this, this._startLSB);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing final read", (Throwable)e);
                }
                break;
            }
            case DOMSBFORREAD: {
                try {
                    this.state = ProgState.DOLSBFORREAD;
                    this.prog.writeCV(valMSB, this.valueMSB, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing write strobe for read", (Throwable)e);
                }
                break;
            }
            case DOLSBFORREAD: {
                try {
                    this.state = ProgState.FINISHREAD;
                    this.prog.writeCV("204", this.valueLSB, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing write strobe for read", (Throwable)e);
                }
                break;
            }
            case DOSIFORWRITE: {
                if (this.valueSI != -1) {
                    try {
                        this.state = ProgState.DOWRITEFIRST;
                        this.prog.writeCV(indexSI, this.valueSI, this);
                    }
                    catch (ProgrammerException e) {
                        log.error("Exception doing write SI for write", (Throwable)e);
                    }
                    break;
                }
                try {
                    this.state = ProgState.DOWRITEFIRST;
                    this.prog.writeCV(indexSI, this._val, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing write SI for write", (Throwable)e);
                }
                break;
            }
            case DOWRITEFIRST: {
                if (this.valueSI != -1) {
                    try {
                        this.state = ProgState.FINISHWRITE;
                        this.prog.writeCV(valMSB, this._val / 256, this);
                    }
                    catch (ProgrammerException e) {
                        log.error("Exception doing write MSB for write", (Throwable)e);
                    }
                    break;
                }
                try {
                    this.state = ProgState.FINISHWRITE;
                    this.prog.writeCV(valMSB, this.valueMSB, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing write MSB for write", (Throwable)e);
                }
                break;
            }
            case FINISHWRITE: {
                if (this.valueSI != -1) {
                    try {
                        this.state = ProgState.PROGRAMMING;
                        this.prog.writeCV("204", this._val & 0xFF, this);
                    }
                    catch (ProgrammerException e) {
                        log.error("Exception doing final write", (Throwable)e);
                    }
                    break;
                }
                try {
                    this.state = ProgState.PROGRAMMING;
                    this.prog.writeCV("204", this.valueLSB, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing final write", (Throwable)e);
                }
                break;
            }
            case PROGRAMMING: {
                ProgListener temp = this._usingProgrammer;
                this._usingProgrammer = null;
                this.state = ProgState.NOTPROGRAMMING;
                temp.programmingOpReply(this.upperByte * 256 + value, status);
                break;
            }
            default: {
                log.error("Unexpected state on reply: {}", (Object)this.state);
                this._usingProgrammer = null;
                this.state = ProgState.NOTPROGRAMMING;
            }
        }
    }

    static enum ProgState {
        PROGRAMMING,
        DOSIFORREAD,
        DOSTROBEFORREAD,
        DOMSBFORREAD,
        DOLSBFORREAD,
        DOREADFIRST,
        FINISHREAD,
        DOSIFORWRITE,
        DOWRITEFIRST,
        FINISHWRITE,
        NOTPROGRAMMING;

    }
}

