/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import jmri.NamedBeanHandle;
import jmri.Turnout;
import jmri.implementation.Bundle;
import jmri.implementation.DoubleTurnoutSignalHead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripleOutputSignalHead
extends DoubleTurnoutSignalHead {
    private NamedBeanHandle<Turnout> mBlue;
    private static final int[] validStates;
    private static final String[] validStateKeys;
    private static final Logger log;

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 64;
        nArray[3] = 4;
        nArray[4] = 16;
        nArray[5] = 2;
        nArray[6] = 128;
        nArray[7] = 8;
        nArray[8] = 32;
        validStates = nArray;
        validStateKeys = new String[]{"SignalHeadStateDark", "SignalHeadStateRed", "SignalHeadStateLunar", "SignalHeadStateYellow", "SignalHeadStateGreen", "SignalHeadStateFlashingRed", "SignalHeadStateFlashingLunar", "SignalHeadStateFlashingYellow", "SignalHeadStateFlashingGreen"};
        log = LoggerFactory.getLogger(TripleOutputSignalHead.class);
    }

    public TripleOutputSignalHead(String sys, String user, NamedBeanHandle<Turnout> green, NamedBeanHandle<Turnout> blue, NamedBeanHandle<Turnout> red) {
        super(sys, user, green, red);
        this.mBlue = blue;
    }

    public TripleOutputSignalHead(String sys, NamedBeanHandle<Turnout> green, NamedBeanHandle<Turnout> blue, NamedBeanHandle<Turnout> red) {
        super(sys, green, red);
        this.mBlue = blue;
    }

    @Override
    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    protected void updateOutput() {
        if (!this.mLit) {
            ((Turnout)this.mRed.getBean()).setCommandedState(2);
            this.mBlue.getBean().setCommandedState(2);
            ((Turnout)this.mGreen.getBean()).setCommandedState(2);
        } else if (!(this.mFlashOn || this.mAppearance != 32 && this.mAppearance != 8 && this.mAppearance != 128 && this.mAppearance != 2)) {
            ((Turnout)this.mRed.getBean()).setCommandedState(2);
            this.mBlue.getBean().setCommandedState(2);
            ((Turnout)this.mGreen.getBean()).setCommandedState(2);
        } else {
            switch (this.mAppearance) {
                case 1: 
                case 2: {
                    ((Turnout)this.mRed.getBean()).setCommandedState(4);
                    this.mBlue.getBean().setCommandedState(2);
                    ((Turnout)this.mGreen.getBean()).setCommandedState(2);
                    break;
                }
                case 4: 
                case 8: {
                    ((Turnout)this.mRed.getBean()).setCommandedState(4);
                    this.mBlue.getBean().setCommandedState(2);
                    ((Turnout)this.mGreen.getBean()).setCommandedState(4);
                    break;
                }
                case 16: 
                case 32: {
                    ((Turnout)this.mRed.getBean()).setCommandedState(2);
                    this.mBlue.getBean().setCommandedState(2);
                    ((Turnout)this.mGreen.getBean()).setCommandedState(4);
                    break;
                }
                case 64: 
                case 128: {
                    ((Turnout)this.mRed.getBean()).setCommandedState(4);
                    this.mBlue.getBean().setCommandedState(4);
                    ((Turnout)this.mGreen.getBean()).setCommandedState(4);
                    break;
                }
                default: {
                    log.warn("Unexpected new appearance: {}", (Object)this.mAppearance);
                }
                case 0: {
                    ((Turnout)this.mRed.getBean()).setCommandedState(2);
                    this.mBlue.getBean().setCommandedState(2);
                    ((Turnout)this.mGreen.getBean()).setCommandedState(2);
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.mBlue = null;
        super.dispose();
    }

    public NamedBeanHandle<Turnout> getBlue() {
        return this.mBlue;
    }

    public void setBlue(NamedBeanHandle<Turnout> t) {
        this.mBlue = t;
    }

    @Override
    public int[] getValidStates() {
        return Arrays.copyOf(validStates, validStates.length);
    }

    @Override
    public String[] getValidStateKeys() {
        return Arrays.copyOf(validStateKeys, validStateKeys.length);
    }

    @Override
    public String[] getValidStateNames() {
        String[] stateNames = new String[validStateKeys.length];
        int i = 0;
        String[] stringArray = validStateKeys;
        int n = validStateKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String stateKey = stringArray[n2];
            stateNames[i++] = Bundle.getMessage(stateKey);
            ++n2;
        }
        return stateNames;
    }

    @Override
    boolean isTurnoutUsed(Turnout t) {
        if (super.isTurnoutUsed(t)) {
            return true;
        }
        return this.getBlue() != null && t.equals(this.getBlue().getBean());
    }

    @Override
    void readOutput() {
    }
}

