/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.SignalSystem;
import jmri.beans.Bean;
import jmri.implementation.Bundle;
import jmri.jmrit.XmlFile;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.util.FileUtil;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalSpeedMap
extends Bean
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize {
    private final HashMap<String, Float> _table = new LinkedHashMap<String, Float>();
    private final HashMap<String, String> _headTable = new LinkedHashMap<String, String>();
    private int _interpretation;
    private int _sStepDelay;
    private int _numSteps = 4;
    private float _stepIncrement = 0.04f;
    private float _throttleFactor = 0.75f;
    private float _scale = 87.1f;
    public static final int PERCENT_NORMAL = 1;
    public static final int PERCENT_THROTTLE = 2;
    public static final int SPEED_MPH = 3;
    public static final int SPEED_KMPH = 4;
    private PropertyChangeListener warrantPreferencesListener = null;
    private static final Logger log = LoggerFactory.getLogger(SignalSpeedMap.class);

    public SignalSpeedMap() {
        this.loadMap();
        this.warrantPreferencesListener = evt -> {
            WarrantPreferences preferences = WarrantPreferences.getDefault();
            SignalSpeedMap map = this;
            switch (evt.getPropertyName()) {
                case "appearances": {
                    map.setAppearances(preferences.getAppearances());
                    break;
                }
                case "layoutScale": {
                    map.setLayoutScale(preferences.getLayoutScale());
                    break;
                }
                case "interpretation": 
                case "speedNames": {
                    map.setAspects(preferences.getSpeedNames(), preferences.getInterpretation());
                    break;
                }
                case "throttleScale": {
                    map.setDefaultThrottleFactor(preferences.getThrottleScale());
                    break;
                }
                case "rampIncrement": 
                case "timeIncrement": {
                    map.setRampParams(preferences.getThrottleIncrement(), preferences.getTimeIncrement());
                }
            }
        };
    }

    @Override
    public void initialize() {
        InstanceManager.getOptionalDefault(WarrantPreferences.class).ifPresent(wp -> wp.addPropertyChangeListener(this.warrantPreferencesListener));
        InstanceManager.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals(InstanceManager.getDefaultsPropertyName(WarrantPreferences.class))) {
                InstanceManager.getDefault(WarrantPreferences.class).addPropertyChangeListener(this.warrantPreferencesListener);
            }
        });
    }

    void loadMap() {
        URL path = FileUtil.findURL("signalSpeeds.xml", "", "xml/signals");
        XmlFile xf = new XmlFile(){};
        try {
            this.loadRoot(xf.rootFromURL(path));
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.warn("signalSpeeds file ({}) doesn't exist in XmlFile search path.", (Object)path);
            throw new IllegalArgumentException("signalSpeeds file (" + path + ") doesn't exist in XmlFile search path.");
        }
        catch (IOException | JDOMException e) {
            log.error("error reading file \"{}\" due to: {}", (Object)path, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRoot(@Nonnull Element root) {
        try {
            String sval;
            Element e = root.getChild("interpretation");
            switch (sval = e.getText().toUpperCase()) {
                case "PERCENTNORMAL": {
                    this._interpretation = 1;
                    break;
                }
                case "PERCENTTHROTTLE": {
                    this._interpretation = 2;
                    break;
                }
                default: {
                    throw new JDOMException("invalid content for interpretation: " + sval);
                }
            }
            log.debug("_interpretation= {}", (Object)this._interpretation);
            e = root.getChild("msPerIncrement");
            this._sStepDelay = 1000;
            try {
                this._sStepDelay = Integer.parseInt(e.getText());
            }
            catch (NumberFormatException numberFormatException) {
                throw new JDOMException("invalid content for msPerIncrement: " + e.getText());
            }
            if (this._sStepDelay < 200) {
                this._sStepDelay = 200;
                log.warn("\"msPerIncrement\" must be at least 200 milliseconds.");
            }
            log.debug("_sStepDelay = {}", (Object)this._sStepDelay);
            e = root.getChild("stepsPerIncrement");
            try {
                this._numSteps = Integer.parseInt(e.getText());
            }
            catch (NumberFormatException numberFormatException) {
                throw new JDOMException("invalid content for stepsPerIncrement: " + e.getText());
            }
            if (this._numSteps < 1) {
                this._numSteps = 1;
            }
            List list = root.getChild("aspectSpeeds").getChildren();
            this._table.clear();
            int i = 0;
            while (i < list.size()) {
                Float speed;
                String name = ((Element)list.get(i)).getName();
                try {
                    speed = Float.valueOf(((Element)list.get(i)).getText());
                }
                catch (NumberFormatException numberFormatException) {
                    log.error("invalid content for {} = {}", (Object)name, (Object)((Element)list.get(i)).getText());
                    throw new JDOMException("invalid content for " + name + " = " + ((Element)list.get(i)).getText());
                }
                log.debug("Add {}, {} to AspectSpeed Table", (Object)name, (Object)speed);
                this._table.put(name, speed);
                ++i;
            }
            HashMap<String, String> hashMap = this._headTable;
            synchronized (hashMap) {
                this._headTable.clear();
                List l = root.getChild("appearanceSpeeds").getChildren();
                int i2 = 0;
                while (i2 < l.size()) {
                    String name = ((Element)l.get(i2)).getName();
                    String speed = ((Element)l.get(i2)).getText();
                    this._headTable.put(Bundle.getMessage(name), speed);
                    log.debug("Add {}={}, {} to AppearanceSpeed Table", new Object[]{name, Bundle.getMessage(name), speed});
                    ++i2;
                }
            }
        }
        catch (JDOMException e) {
            log.error("error reading speed map elements due to: {}", (Throwable)e);
        }
    }

    public boolean checkSpeed(String name) {
        if (name == null) {
            return false;
        }
        return this._table.get(name) != null;
    }

    public String getAspectSpeed(@Nonnull String aspect, @Nonnull SignalSystem system) {
        String property = (String)system.getProperty(aspect, "speed");
        log.debug("getAspectSpeed: aspect={}, speed={}", (Object)aspect, (Object)property);
        return property;
    }

    public String getAspectExitSpeed(@Nonnull String aspect, @Nonnull SignalSystem system) {
        String property = (String)system.getProperty(aspect, "speed2");
        log.debug("getAspectSpeed: aspect={}, speed2={}", (Object)aspect, (Object)property);
        return property;
    }

    public String getAppearanceSpeed(@Nonnull String name) throws NumberFormatException {
        String speed = this._headTable.get(name);
        log.debug("getAppearanceSpeed Appearance={}, speed={}", (Object)name, (Object)speed);
        return speed;
    }

    public Enumeration<String> getAppearanceIterator() {
        return Collections.enumeration(this._headTable.keySet());
    }

    public Enumeration<String> getSpeedIterator() {
        return Collections.enumeration(this._table.keySet());
    }

    public Vector<String> getValidSpeedNames() {
        return new Vector<String>(this._table.keySet());
    }

    public float getSpeed(@Nonnull String name) throws IllegalArgumentException {
        if (!this.checkSpeed(name)) {
            log.warn("attempting to get speed for invalid name: '{}'", (Object)name);
            throw new IllegalArgumentException("attempting to get speed from invalid name: \"" + name + "\"");
        }
        Float speed = this._table.get(name);
        if (speed == null) {
            return 0.0f;
        }
        return speed.floatValue();
    }

    public String getNamedSpeed(float speed) {
        Enumeration<String> e = this.getSpeedIterator();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (!this._table.get(key).equals(Float.valueOf(speed))) continue;
            return key;
        }
        return null;
    }

    public int getInterpretation() {
        return this._interpretation;
    }

    public int getStepDelay() {
        return this._sStepDelay;
    }

    public float getStepIncrement() {
        return this._stepIncrement;
    }

    public void setAspects(@Nonnull HashMap<String, Float> map, int interpretation) {
        HashMap<String, Float> oldMap = new HashMap<String, Float>(this._table);
        int oldInterpretation = this._interpretation;
        this._table.clear();
        this._table.putAll(map);
        this._interpretation = interpretation;
        if (interpretation != oldInterpretation) {
            this.firePropertyChange("interpretation", oldInterpretation, interpretation);
        }
        if (!map.equals(oldMap)) {
            this.firePropertyChange("aspects", oldMap, new HashMap<String, Float>(map));
        }
    }

    public void setAspectTable(@Nonnull Iterator<Map.Entry<String, Float>> iter, int interpretation) {
        this._table.clear();
        while (iter.hasNext()) {
            Map.Entry<String, Float> ent = iter.next();
            this._table.put(ent.getKey(), ent.getValue());
        }
        this._interpretation = interpretation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppearances(@Nonnull HashMap<String, String> map) {
        HashMap<String, String> hashMap = this._headTable;
        synchronized (hashMap) {
            HashMap<String, String> old = new HashMap<String, String>(this._headTable);
            this._headTable.clear();
            this._headTable.putAll(map);
            if (!map.equals(old)) {
                this.firePropertyChange("Appearances", old, new HashMap<String, String>(this._headTable));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppearanceTable(@Nonnull Iterator<Map.Entry<String, String>> iter) {
        HashMap<String, String> hashMap = this._headTable;
        synchronized (hashMap) {
            this._headTable.clear();
            while (iter.hasNext()) {
                Map.Entry<String, String> ent = iter.next();
                this._headTable.put(ent.getKey(), ent.getValue());
            }
        }
    }

    public void setRampParams(float throttleIncr, int msIncrTime) {
        this._sStepDelay = msIncrTime;
        this._stepIncrement = throttleIncr;
    }

    public void setDefaultThrottleFactor(float f) {
        this._throttleFactor = f;
    }

    public float getDefaultThrottleFactor() {
        return this._throttleFactor;
    }

    public void setLayoutScale(float s) {
        this._scale = s;
    }

    public float getLayoutScale() {
        return this._scale;
    }
}

