/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalMastRepeater {
    public static final int BOTHWAY = 0;
    public static final int MASTERTOSLAVE = 1;
    public static final int SLAVETOMASTER = 2;
    protected NamedBeanHandleManager nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
    protected NamedBeanHandle<SignalMast> _master;
    protected NamedBeanHandle<SignalMast> _slave;
    boolean _enabled = true;
    int _direction = 0;
    PropertyChangeListener mastListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (SignalMastRepeater.this.disposed) {
                return;
            }
            if (e.getSource() == SignalMastRepeater.this.getMasterMast()) {
                SignalMastRepeater.this.updateStatus(SignalMastRepeater.this.getMasterMast(), SignalMastRepeater.this.getSlaveMast());
            } else {
                SignalMastRepeater.this.updateStatus(SignalMastRepeater.this.getSlaveMast(), SignalMastRepeater.this.getMasterMast());
            }
        }
    };
    boolean disposed = false;
    private static final Logger log = LoggerFactory.getLogger(SignalMastRepeater.class);

    public SignalMastRepeater(@Nonnull SignalMast master, @Nonnull SignalMast slave) {
        this._master = this.nbhm.getNamedBeanHandle(master.getDisplayName(), master);
        this._slave = this.nbhm.getNamedBeanHandle(slave.getDisplayName(), slave);
    }

    public SignalMastRepeater(@Nonnull String master, @Nonnull String slave) {
        SignalMast masterMast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(master);
        if (masterMast == null) {
            throw new IllegalArgumentException("master mast must exist, \"" + master + "\" doesn't");
        }
        this._master = this.nbhm.getNamedBeanHandle(master, masterMast);
        SignalMast slaveMast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(slave);
        if (slaveMast == null) {
            throw new IllegalArgumentException("slave mast must exist, \"" + slave + "\" doesn't");
        }
        this._slave = this.nbhm.getNamedBeanHandle(slave, slaveMast);
    }

    @Nonnull
    public SignalMast getMasterMast() {
        return this._master.getBean();
    }

    @Nonnull
    public SignalMast getSlaveMast() {
        return this._slave.getBean();
    }

    @Nonnull
    public String getMasterMastName() {
        return this._master.getName();
    }

    @Nonnull
    public String getSlaveMastName() {
        return this._slave.getName();
    }

    public int getDirection() {
        return this._direction;
    }

    public void setDirection(int dir) {
        if (dir == this._direction) {
            return;
        }
        this._direction = dir;
        this.getMasterMast().removePropertyChangeListener(this.mastListener);
        this.getSlaveMast().removePropertyChangeListener(this.mastListener);
        this.initialise();
    }

    public void setEnabled(boolean en) {
        if (this._enabled == en) {
            return;
        }
        this._enabled = en;
        this.getMasterMast().removePropertyChangeListener(this.mastListener);
        this.getSlaveMast().removePropertyChangeListener(this.mastListener);
        this.initialise();
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public void initialise() {
        if (this.disposed) {
            log.error("Trying to initialise a repeater that has already been disposed");
        }
        if (!this._enabled) {
            return;
        }
        this.getMasterMast().removePropertyChangeListener(this.mastListener);
        this.getSlaveMast().removePropertyChangeListener(this.mastListener);
        switch (this._direction) {
            case 1: {
                this.getMasterMast().addPropertyChangeListener(this.mastListener);
                this.updateStatus(this.getMasterMast(), this.getSlaveMast());
                break;
            }
            case 2: {
                this.getSlaveMast().addPropertyChangeListener(this.mastListener);
                this.updateStatus(this.getSlaveMast(), this.getMasterMast());
                break;
            }
            default: {
                this.getMasterMast().addPropertyChangeListener(this.mastListener);
                this.getSlaveMast().addPropertyChangeListener(this.mastListener);
                this.updateStatus(this.getMasterMast(), this.getSlaveMast());
            }
        }
    }

    void updateStatus(@Nonnull SignalMast mastFrom, @Nonnull SignalMast mastTo) {
        if (log.isDebugEnabled()) {
            log.debug("Updating from mast {}:{} to mast {}", new Object[]{mastFrom.getDisplayName(), mastFrom.getAspect(), mastTo.getDisplayName()});
        }
        if (mastFrom.getAspect() != null) {
            mastTo.setAspect(mastFrom.getAspect());
        }
    }

    public void dispose() {
        this.disposed = true;
        this.getMasterMast().removePropertyChangeListener(this.mastListener);
        this.getSlaveMast().removePropertyChangeListener(this.mastListener);
        this._master = null;
        this._slave = null;
    }
}

