/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.implementation.AbstractSignalMast;
import jmri.implementation.Bundle;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalHeadSignalMast
extends AbstractSignalMast {
    private static final String mastType = "IF$shsm";
    private List<NamedBeanHandle<SignalHead>> heads;
    private static final Logger log = LoggerFactory.getLogger(SignalHeadSignalMast.class);

    public SignalHeadSignalMast(String systemName, String userName) {
        super(systemName, userName);
        this.configureFromName(systemName);
    }

    public SignalHeadSignalMast(String systemName) {
        super(systemName);
        this.configureFromName(systemName);
    }

    private void configureFromName(String systemName) {
        String[] parts = systemName.split(":");
        if (parts.length < 3) {
            log.error("SignalMast system name needs at least three parts: {}", (Object)systemName);
            throw new IllegalArgumentException("System name needs at least three parts: " + systemName);
        }
        if (!parts[0].equals(mastType)) {
            log.warn("SignalMast system name should start with {} but is {}", (Object)mastType, (Object)systemName);
        }
        String prefix = parts[0];
        String system = parts[1];
        String mast = parts[2];
        if (mast.indexOf(40) == -1) {
            this.setMastType(mast);
            this.configureSignalSystemDefinition(system);
            this.configureAspectTable(system, mast);
            this.configureHeads(parts, 3);
        } else {
            mast = mast.substring(0, mast.indexOf("("));
            this.setMastType(mast);
            String interim = systemName.substring(prefix.length() + 1 + system.length() + 1);
            String parenstring = interim.substring(interim.indexOf("("), interim.length());
            List<String> parens = StringUtil.splitParens(parenstring);
            this.configureSignalSystemDefinition(system);
            this.configureAspectTable(system, mast);
            String[] heads = new String[parens.size()];
            int i = 0;
            for (String p : parens) {
                heads[i] = p.substring(1, p.length() - 1);
                ++i;
            }
            this.configureHeads(heads, 0);
        }
    }

    private void configureHeads(String[] parts, int start) {
        this.heads = new ArrayList<NamedBeanHandle<SignalHead>>();
        int i = start;
        while (i < parts.length) {
            String name = parts[i];
            SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(name);
            if (head == null) {
                log.warn("Attempting to create Mast from non-existant signal head {}", (Object)name);
            } else {
                NamedBeanHandle<SignalHead> s = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, head);
                this.heads.add(s);
            }
            ++i;
        }
    }

    @Override
    public void setAspect(@Nonnull String aspect) {
        if (!this.map.checkAspect(aspect)) {
            log.warn("attempting to set invalid aspect: {} on mast: {}", (Object)aspect, (Object)this.getDisplayName());
            throw new IllegalArgumentException("attempting to set invalid aspect: " + aspect + " on mast: " + this.getDisplayName());
        }
        if (this.disabledAspects.contains(aspect)) {
            log.warn("attempting to set an aspect that has been disabled: {} on mast: {}", (Object)aspect, (Object)this.getDisplayName());
            throw new IllegalArgumentException("attempting to set an aspect that has been disabled: " + aspect + " on mast: " + this.getDisplayName());
        }
        if (log.isDebugEnabled()) {
            log.debug("setAspect \"{}\", numHeads= {}", (Object)aspect, (Object)this.heads.size());
        }
        this.setAppearances(aspect);
        super.setAspect(aspect);
    }

    @Override
    public void setHeld(boolean state) {
        for (NamedBeanHandle<SignalHead> h : this.heads) {
            try {
                h.getBean().setHeld(state);
            }
            catch (NullPointerException nullPointerException) {
                log.error("NPE caused when trying to set Held due to missing signal head in mast {}", (Object)this.getDisplayName());
            }
        }
        super.setHeld(state);
    }

    @Override
    public void setLit(boolean state) {
        for (NamedBeanHandle<SignalHead> h : this.heads) {
            try {
                h.getBean().setLit(state);
            }
            catch (NullPointerException nullPointerException) {
                log.error("NPE caused when trying to set Lit due to missing signal head in mast {}", (Object)this.getDisplayName());
            }
        }
        super.setLit(state);
    }

    public List<NamedBeanHandle<SignalHead>> getHeadsUsed() {
        return this.heads;
    }

    public void setAppearances(String aspect) {
        if (this.map == null) {
            log.error("No appearance map defined, unable to set appearance {}", (Object)this.getDisplayName());
            return;
        }
        if (this.map.getSignalSystem() != null && this.map.getSignalSystem().checkAspect(aspect) && this.map.getAspectSettings(aspect) != null) {
            log.warn("Attempt to set {} to undefined aspect: {}", (Object)this.getSystemName(), (Object)aspect);
        } else if (this.map.getAspectSettings(aspect) != null && this.heads.size() > this.map.getAspectSettings(aspect).length) {
            log.warn("setAppearance to \"{}\" finds {} heads but only {} settings", new Object[]{aspect, this.heads.size(), this.map.getAspectSettings(aspect).length});
        }
        int delay = 0;
        try {
            if (this.map.getProperty(aspect, "delay") != null) {
                delay = Integer.parseInt(this.map.getProperty(aspect, "delay"));
            }
        }
        catch (Exception exception) {
            log.debug("No delay set");
        }
        HashMap<SignalHead, Integer> delayedSet = new HashMap<SignalHead, Integer>(this.heads.size());
        int i = 0;
        while (i < this.heads.size()) {
            boolean error = false;
            if (this.heads.get(i) == null) {
                log.error("Head {} unexpectedly null in setAppearances while setting aspect \"{}\" for {}", new Object[]{i, aspect, this.getSystemName()});
                error = true;
            }
            if (this.heads.get(i).getBean() == null) {
                log.error("Head {} getBean() unexpectedly null in setAppearances while setting aspect \"{}\" for {}", new Object[]{i, aspect, this.getSystemName()});
                error = true;
            }
            if (this.map.getAspectSettings(aspect) == null) {
                log.error("Couldn't get table array for aspect \"{}\" in setAppearances for {}", (Object)aspect, (Object)this.getSystemName());
                error = true;
            }
            if (!error) {
                SignalHead head = this.heads.get(i).getBean();
                int[] dsam = this.map.getAspectSettings(aspect);
                if (i < dsam.length) {
                    int toSet = dsam[i];
                    if (delay == 0) {
                        head.setAppearance(toSet);
                        log.debug("Setting {} to {}", (Object)head.getSystemName(), (Object)head.getAppearanceName(toSet));
                    } else {
                        delayedSet.put(head, toSet);
                    }
                } else {
                    log.error("     head '{}' appearance not set for aspect '{}'", (Object)head.getSystemName(), (Object)aspect);
                }
            } else {
                log.error("     head appearance not set due to above error");
            }
            ++i;
        }
        if (delay != 0) {
            final HashMap<SignalHead, Integer> thrDelayedSet = delayedSet;
            final int thrDelay = delay;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    SignalHeadSignalMast.this.setDelayedAppearances(thrDelayedSet, thrDelay);
                }
            };
            Thread thr = ThreadingUtil.newThread(r);
            thr.setName(String.valueOf(this.getDisplayName()) + " delayed set appearance");
            thr.setDaemon(true);
            try {
                thr.start();
            }
            catch (IllegalThreadStateException ex) {
                log.error(ex.toString());
            }
        }
    }

    private void setDelayedAppearances(final HashMap<SignalHead, Integer> delaySet, final int delay) {
        Iterator<SignalHead> iterator = delaySet.keySet().iterator();
        while (iterator.hasNext()) {
            SignalHead head;
            final SignalHead thrHead = head = iterator.next();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        thrHead.setAppearance((Integer)delaySet.get(thrHead));
                        if (log.isDebugEnabled()) {
                            log.debug("Setting {} to {}", (Object)thrHead.getSystemName(), (Object)thrHead.getAppearanceName((Integer)delaySet.get(thrHead)));
                        }
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            };
            Thread thr = ThreadingUtil.newThread(r);
            thr.setName(this.getDisplayName());
            thr.setDaemon(true);
            try {
                thr.start();
                thr.join();
            }
            catch (IllegalThreadStateException | InterruptedException ex) {
                log.error(ex.toString());
            }
        }
    }

    public static List<SignalHead> getSignalHeadsUsed() {
        ArrayList<SignalHead> headsUsed = new ArrayList<SignalHead>();
        for (SignalMast mast : InstanceManager.getDefault(SignalMastManager.class).getNamedBeanSet()) {
            if (!(mast instanceof SignalHeadSignalMast)) continue;
            List<NamedBeanHandle<SignalHead>> masthead = ((SignalHeadSignalMast)mast).getHeadsUsed();
            for (NamedBeanHandle<SignalHead> bean : masthead) {
                headsUsed.add(bean.getBean());
            }
        }
        return headsUsed;
    }

    public static String isHeadUsed(SignalHead head) {
        for (SignalMast mast : InstanceManager.getDefault(SignalMastManager.class).getNamedBeanSet()) {
            if (!(mast instanceof SignalHeadSignalMast)) continue;
            List<NamedBeanHandle<SignalHead>> masthead = ((SignalHeadSignalMast)mast).getHeadsUsed();
            for (NamedBeanHandle<SignalHead> bean : masthead) {
                if (bean.getBean() != head) continue;
                return mast.getDisplayName();
            }
        }
        return null;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        NamedBean nb = (NamedBean)evt.getOldValue();
        if ("CanDelete".equals(evt.getPropertyName()) && nb instanceof SignalHead) {
            for (NamedBeanHandle<SignalHead> bean : this.getHeadsUsed()) {
                if (!bean.getBean().equals(nb)) continue;
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("InUseSignalHeadSignalMastVeto", this.getDisplayName()), e);
            }
        }
    }
}

