/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import jmri.ConditionalAction;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Sensor;
import jmri.implementation.DefaultConditional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorGroupConditional
extends DefaultConditional {
    private static final Logger log = LoggerFactory.getLogger(SensorGroupConditional.class);

    public SensorGroupConditional(String systemName, String userName) {
        super(systemName, userName);
    }

    @Override
    public int calculate(boolean enabled, PropertyChangeEvent evt) {
        int currentState = super.calculate(false, evt);
        if (!enabled || evt == null) {
            return currentState;
        }
        Sensor evtSensor = (Sensor)evt.getSource();
        if (evtSensor == null) {
            return currentState;
        }
        String listener = evtSensor.getSystemName();
        log.debug("SGConditional \"{}\" ({}) has event from \"{}\"", new Object[]{this.getUserName(), this.getSystemName(), listener});
        if (4 == (Integer)evt.getNewValue()) {
            return currentState;
        }
        int i = 0;
        while (i < this._actionList.size()) {
            ConditionalAction action = (ConditionalAction)this._actionList.get(i);
            Sensor sn = InstanceManager.sensorManagerInstance().getSensor(action.getDeviceName());
            if (sn == null) {
                log.error("invalid sensor name in action - {}", (Object)action.getDeviceName());
                return currentState;
            }
            if (sn != evtSensor && sn.getState() != action.getActionData()) {
                try {
                    sn.setKnownState(action.getActionData());
                }
                catch (JmriException jmriException) {
                    log.warn("Exception setting sensor {} in action", (Object)action.getDeviceName());
                }
            }
            ++i;
        }
        log.debug("SGConditional \"{}\" ({}), state= {}has set the group actions for {}", new Object[]{this.getUserName(), this.getSystemName(), currentState, listener});
        return currentState;
    }
}

