/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.util.List;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.NmraPacket;
import jmri.TurnoutOperator;
import jmri.implementation.AbstractTurnout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawTurnoutOperator
extends TurnoutOperator {
    long interval;
    int maxTries;
    int tries = 0;
    int address = 0;
    CommandStation c;
    private static final Logger log = LoggerFactory.getLogger(RawTurnoutOperator.class);

    public RawTurnoutOperator(AbstractTurnout t, long i, int mt) {
        super(t);
        String sysName = t.getSystemName();
        int startAddress = sysName.lastIndexOf("T");
        this.address = Integer.parseInt(sysName.substring(startAddress + 1, sysName.length()));
        String prefix = t.getSystemName().substring(0, startAddress);
        List<CommandStation> connList = InstanceManager.getList(CommandStation.class);
        int x = 0;
        while (x < connList.size()) {
            CommandStation station = connList.get(x);
            if (station.getSystemPrefix().equals(prefix)) {
                this.c = station;
                break;
            }
            ++x;
        }
        if (this.c == null) {
            this.c = InstanceManager.getNullableDefault(CommandStation.class);
            log.error("No match against the command station for {}, so will use the default", (Object)sysName);
        }
        this.interval = i;
        this.maxTries = mt;
    }

    private void sendCommand() {
        byte[] pkt = NmraPacket.accDecoderPkt(this.address, this.myTurnout.getCommandedState() == 2);
        this.c.sendPacket(pkt, 1);
    }

    @Override
    public void run() {
        try {
            this.operatorCheck();
            this.sendCommand();
            while (++this.tries < this.maxTries) {
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.operatorCheck();
                this.sendCommand();
            }
            this.myTurnout.setKnownStateToCommanded();
        }
        catch (TurnoutOperator.TurnoutOperatorException turnoutOperatorException) {}
    }
}

