/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.util.Arrays;
import jmri.NamedBeanHandle;
import jmri.Turnout;
import jmri.implementation.Bundle;
import jmri.implementation.TripleTurnoutSignalHead;

public class QuadOutputSignalHead
extends TripleTurnoutSignalHead {
    NamedBeanHandle<Turnout> mLunar;
    private static final int[] validStates;
    private static final String[] validStateKeys;

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 64;
        nArray[3] = 4;
        nArray[4] = 16;
        nArray[5] = 2;
        nArray[6] = 128;
        nArray[7] = 8;
        nArray[8] = 32;
        validStates = nArray;
        validStateKeys = new String[]{"SignalHeadStateDark", "SignalHeadStateRed", "SignalHeadStateLunar", "SignalHeadStateYellow", "SignalHeadStateGreen", "SignalHeadStateFlashingRed", "SignalHeadStateFlashingLunar", "SignalHeadStateFlashingYellow", "SignalHeadStateFlashingGreen"};
    }

    public QuadOutputSignalHead(String sys, String user, NamedBeanHandle<Turnout> green, NamedBeanHandle<Turnout> yellow, NamedBeanHandle<Turnout> red, NamedBeanHandle<Turnout> lunar) {
        super(sys, user, green, yellow, red);
        this.mLunar = lunar;
    }

    public QuadOutputSignalHead(String sys, NamedBeanHandle<Turnout> green, NamedBeanHandle<Turnout> yellow, NamedBeanHandle<Turnout> red, NamedBeanHandle<Turnout> lunar) {
        super(sys, green, yellow, red);
        this.mLunar = lunar;
    }

    @Override
    protected void updateOutput() {
        if (!this.mLit) {
            super.updateOutput();
        } else if (!(this.mFlashOn || this.mAppearance != 32 && this.mAppearance != 8 && this.mAppearance != 2 && this.mAppearance != 128)) {
            ((Turnout)this.mRed.getBean()).setCommandedState(2);
            ((Turnout)this.mYellow.getBean()).setCommandedState(2);
            ((Turnout)this.mGreen.getBean()).setCommandedState(2);
            this.mLunar.getBean().setCommandedState(2);
        } else {
            switch (this.mAppearance) {
                case 64: 
                case 128: {
                    this.mLunar.getBean().setCommandedState(4);
                    ((Turnout)this.mRed.getBean()).setCommandedState(2);
                    ((Turnout)this.mYellow.getBean()).setCommandedState(2);
                    ((Turnout)this.mGreen.getBean()).setCommandedState(2);
                    break;
                }
                default: {
                    this.mLunar.getBean().setCommandedState(2);
                    super.updateOutput();
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.mLunar = null;
        super.dispose();
    }

    public NamedBeanHandle<Turnout> getLunar() {
        return this.mLunar;
    }

    public void setLunar(NamedBeanHandle<Turnout> t) {
        this.mLunar = t;
    }

    @Override
    public int[] getValidStates() {
        return Arrays.copyOf(validStates, validStates.length);
    }

    @Override
    public String[] getValidStateKeys() {
        return Arrays.copyOf(validStateKeys, validStateKeys.length);
    }

    @Override
    public String[] getValidStateNames() {
        String[] stateNames = new String[validStateKeys.length];
        int i = 0;
        String[] stringArray = validStateKeys;
        int n = validStateKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String stateKey = stringArray[n2];
            stateNames[i++] = Bundle.getMessage(stateKey);
            ++n2;
        }
        return stateNames;
    }

    @Override
    boolean isTurnoutUsed(Turnout t) {
        if (super.isTurnoutUsed(t)) {
            return true;
        }
        return this.getLunar() != null && t.equals(this.getLunar().getBean());
    }
}

