/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.jmrix.AbstractProgrammerFacade;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpsModeDelayedProgrammerFacade
extends AbstractProgrammerFacade
implements ProgListener {
    int _val;
    String _cv;
    String _addrType;
    int _readDelay;
    int _writeDelay;
    int _delay;
    private volatile transient ProgListener _usingProgrammer;
    ProgState state = ProgState.NOTPROGRAMMING;
    private static final Logger log = LoggerFactory.getLogger(OpsModeDelayedProgrammerFacade.class);

    public OpsModeDelayedProgrammerFacade(Programmer prog, int writeDelay) {
        super(prog);
        log.debug("Constructing OpsModeDelayedProgrammerFacade");
        this._usingProgrammer = null;
        this.prog = prog;
        this._readDelay = 0;
        this._writeDelay = writeDelay;
    }

    @Override
    public synchronized void writeCV(String cv, int val, ProgListener p) throws ProgrammerException {
        log.debug("writeCV entry: ProgListener p is {}", (Object)p);
        this.useProgrammer(p);
        this.state = ProgState.WRITECOMMANDSENT;
        this.prog.writeCV(cv, val, this);
    }

    @Override
    public synchronized void readCV(String cv, ProgListener p) throws ProgrammerException {
        this.readCV(cv, p, 0);
    }

    @Override
    public synchronized void readCV(String cv, ProgListener p, int startVal) throws ProgrammerException {
        this.useProgrammer(p);
        this.state = ProgState.READCOMMANDSENT;
        this.prog.readCV(cv, this, startVal);
    }

    @Override
    public synchronized void confirmCV(String cv, int val, ProgListener p) throws ProgrammerException {
        this.useProgrammer(p);
        this.state = ProgState.READCOMMANDSENT;
        this.prog.confirmCV(cv, val, this);
    }

    protected synchronized void useProgrammer(ProgListener p) throws ProgrammerException {
        log.debug("useProgrammer entry: _usingProgrammer is {}", (Object)this._usingProgrammer);
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            if (log.isInfoEnabled()) {
                log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            }
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
        log.debug("useProgrammer exit: _usingProgrammer is {}", (Object)this._usingProgrammer);
    }

    @Override
    public synchronized void programmingOpReply(int value, int status) {
        log.debug("notifyProgListenerEnd value={}, status={}", (Object)value, (Object)status);
        if (status != 0) {
            log.debug("Reset and pass abort up");
            ProgListener temp = this._usingProgrammer;
            this._usingProgrammer = null;
            this.state = ProgState.NOTPROGRAMMING;
            temp.programmingOpReply(value, status);
            return;
        }
        if (this._usingProgrammer == null) {
            log.error("No listener to notify, reset and ignore");
            this.state = ProgState.NOTPROGRAMMING;
            return;
        }
        switch (this.state) {
            case READCOMMANDSENT: {
                this._delay = this._readDelay;
                break;
            }
            case WRITECOMMANDSENT: {
                this._delay = this._writeDelay;
                break;
            }
            default: {
                log.error("Unexpected state on reply: {}", (Object)this.state);
                this._usingProgrammer = null;
                this.state = ProgState.NOTPROGRAMMING;
            }
        }
        log.debug("delaying {} milliseconds", (Object)this._delay);
        ThreadingUtil.runOnLayoutDelayed(() -> {
            log.debug("going NOTPROGRAMMING after value {}, status={}", (Object)value, (Object)status);
            ProgListener temp = this._usingProgrammer;
            this._usingProgrammer = null;
            this.state = ProgState.NOTPROGRAMMING;
            log.debug("notifying value {} status {}", (Object)value, (Object)status);
            temp.programmingOpReply(value, status);
        }, this._delay);
    }

    static enum ProgState {
        READCOMMANDSENT,
        WRITECOMMANDSENT,
        NOTPROGRAMMING;

    }
}

