/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.NmraPacket;
import jmri.implementation.DccConsist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NmraConsist
extends DccConsist {
    private CommandStation commandStation = null;
    private static final Logger log = LoggerFactory.getLogger(NmraConsist.class);

    public NmraConsist(int address) {
        super(address);
        log.debug("Nmra Consist created for address: {}", (Object)address);
    }

    public NmraConsist(DccLocoAddress address) {
        this(address, InstanceManager.getDefault(CommandStation.class));
    }

    public NmraConsist(DccLocoAddress address, CommandStation cs) {
        super(address);
        this.commandStation = cs;
        log.debug("Nmra Consist created for address: {}", (Object)address.toString());
    }

    @Override
    protected void addToAdvancedConsist(DccLocoAddress LocoAddress2, boolean directionNormal) {
        if (log.isDebugEnabled()) {
            log.debug("Add Locomotive {} to advanced consist {} With Direction Normal {}.", new Object[]{LocoAddress2.toString(), this.consistAddress.toString(), directionNormal});
        }
        byte[] contents = NmraPacket.consistControl(LocoAddress2.getNumber(), LocoAddress2.isLongAddress(), this.consistAddress.getNumber(), directionNormal);
        this.commandStation.sendPacket(contents, 4);
        this.notifyConsistListeners(LocoAddress2, 2);
    }

    @Override
    protected void removeFromAdvancedConsist(DccLocoAddress LocoAddress2) {
        if (log.isDebugEnabled()) {
            log.debug("Remove Locomotive {} from advanced consist {}.", (Object)LocoAddress2.toString(), (Object)this.consistAddress.toString());
        }
        byte[] contents = NmraPacket.consistControl(LocoAddress2.getNumber(), LocoAddress2.isLongAddress(), 0, true);
        this.commandStation.sendPacket(contents, 4);
        this.notifyConsistListeners(LocoAddress2, 2);
    }
}

