/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.util.Arrays;
import jmri.NamedBeanHandle;
import jmri.Turnout;
import jmri.implementation.Bundle;
import jmri.implementation.DefaultSignalHead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergSD2SignalHead
extends DefaultSignalHead {
    NamedBeanHandle<Turnout> mInput1 = null;
    NamedBeanHandle<Turnout> mInput2 = null;
    NamedBeanHandle<Turnout> mInput3 = null;
    int mAspects = 2;
    boolean mFeather = false;
    boolean mHome = true;
    private static final int[] validStates2AspectHome = new int[]{1, 16};
    private static final String[] validStateKeys2AspectHome = new String[]{"SignalHeadStateRed", "SignalHeadStateGreen"};
    private static final int[] validStates2AspectDistant = new int[]{4, 16};
    private static final String[] validStateKeys2AspectDistant = new String[]{"SignalHeadStateYellow", "SignalHeadStateGreen"};
    private static final int[] validStates3Aspect = new int[]{1, 4, 16};
    private static final String[] validStateKeys3Aspect = new String[]{"SignalHeadStateRed", "SignalHeadStateYellow", "SignalHeadStateGreen"};
    private static final int[] validStates4Aspect = new int[]{1, 4, 64, 16};
    private static final String[] validStateKeys4Aspect = new String[]{"SignalHeadStateRed", "SignalHeadStateYellow", "SignalHeadStateLunar", "SignalHeadStateGreen"};
    private static final Logger log = LoggerFactory.getLogger(MergSD2SignalHead.class);

    public MergSD2SignalHead(String sys, String user, int aspect, NamedBeanHandle<Turnout> t1, NamedBeanHandle<Turnout> t2, NamedBeanHandle<Turnout> t3, boolean feather, boolean home) {
        super(sys, user);
        this.mAspects = aspect;
        this.mInput1 = t1;
        if (t2 != null) {
            this.mInput2 = t2;
        }
        if (t3 != null) {
            this.mInput3 = t3;
        }
        this.mFeather = feather;
        this.mHome = home;
        if (this.mHome) {
            this.setAppearance(1);
        } else {
            this.setAppearance(4);
        }
    }

    public MergSD2SignalHead(String sys, int aspect, NamedBeanHandle<Turnout> t1, NamedBeanHandle<Turnout> t2, NamedBeanHandle<Turnout> t3, boolean feather, boolean home) {
        super(sys);
        this.mAspects = aspect;
        this.mInput1 = t1;
        if (t2 != null) {
            this.mInput2 = t2;
        }
        if (t3 != null) {
            this.mInput3 = t3;
        }
        this.mFeather = feather;
        this.mHome = home;
        if (this.mHome) {
            this.setAppearance(1);
        } else {
            this.setAppearance(4);
        }
    }

    @Override
    public void setAppearance(int newAppearance) {
        int oldAppearance = this.mAppearance;
        this.mAppearance = newAppearance;
        boolean valid = false;
        switch (this.mAspects) {
            case 2: {
                if (this.mHome) {
                    if (newAppearance != 1 && newAppearance != 16) break;
                    valid = true;
                    break;
                }
                if (newAppearance != 16 && newAppearance != 4) break;
                valid = true;
                break;
            }
            case 3: {
                if (newAppearance != 1 && newAppearance != 4 && newAppearance != 16) break;
                valid = true;
                break;
            }
            case 4: {
                if (newAppearance != 1 && newAppearance != 4 && newAppearance != 16 && newAppearance != 64) break;
                valid = true;
                break;
            }
            default: {
                valid = false;
            }
        }
        if (oldAppearance != newAppearance && valid) {
            this.updateOutput();
            this.firePropertyChange("Appearance", oldAppearance, newAppearance);
        }
    }

    @Override
    public void setLit(boolean newLit) {
        boolean oldLit = this.mLit;
        this.mLit = newLit;
        if (oldLit != newLit) {
            this.updateOutput();
            this.firePropertyChange("Lit", oldLit, newLit);
        }
    }

    @Override
    protected void updateOutput() {
        switch (this.mAppearance) {
            case 1: {
                this.mInput1.getBean().setCommandedState(2);
                break;
            }
            case 4: {
                if (this.mHome) {
                    this.mInput1.getBean().setCommandedState(4);
                    if (this.mInput2 == null) break;
                    this.mInput2.getBean().setCommandedState(2);
                    break;
                }
                this.mInput1.getBean().setCommandedState(2);
                break;
            }
            case 64: {
                this.mInput1.getBean().setCommandedState(4);
                this.mInput2.getBean().setCommandedState(4);
                this.mInput3.getBean().setCommandedState(2);
                break;
            }
            case 16: {
                this.mInput1.getBean().setCommandedState(4);
                if (this.mInput2 != null) {
                    this.mInput2.getBean().setCommandedState(4);
                }
                if (this.mInput3 == null) break;
                this.mInput3.getBean().setCommandedState(4);
                break;
            }
            default: {
                this.mInput1.getBean().setCommandedState(2);
                log.warn("Unexpected new appearance: {}", (Object)this.mAppearance);
            }
        }
    }

    @Override
    public void dispose() {
        this.mInput1 = null;
        this.mInput2 = null;
        this.mInput3 = null;
        super.dispose();
    }

    public NamedBeanHandle<Turnout> getInput1() {
        return this.mInput1;
    }

    public NamedBeanHandle<Turnout> getInput2() {
        return this.mInput2;
    }

    public NamedBeanHandle<Turnout> getInput3() {
        return this.mInput3;
    }

    public int getAspects() {
        return this.mAspects;
    }

    public boolean getFeather() {
        return this.mFeather;
    }

    public boolean getHome() {
        return this.mHome;
    }

    public void setInput1(NamedBeanHandle<Turnout> t) {
        this.mInput1 = t;
    }

    public void setInput2(NamedBeanHandle<Turnout> t) {
        this.mInput2 = t;
    }

    public void setInput3(NamedBeanHandle<Turnout> t) {
        this.mInput3 = t;
    }

    public void setAspects(int i) {
        this.mAspects = i;
    }

    public void setFeather(boolean boo) {
        this.mFeather = boo;
    }

    public void setHome(boolean boo) {
        this.mHome = boo;
    }

    @Override
    public int[] getValidStates() {
        if (!this.mHome) {
            return Arrays.copyOf(validStates2AspectDistant, validStates2AspectDistant.length);
        }
        switch (this.mAspects) {
            case 2: {
                return Arrays.copyOf(validStates2AspectHome, validStates2AspectHome.length);
            }
            case 3: {
                return Arrays.copyOf(validStates3Aspect, validStates3Aspect.length);
            }
            case 4: {
                return Arrays.copyOf(validStates4Aspect, validStates4Aspect.length);
            }
        }
        log.warn("Unexpected number of aspects: {}", (Object)this.mAspects);
        return Arrays.copyOf(validStates3Aspect, validStates3Aspect.length);
    }

    @Override
    public String[] getValidStateKeys() {
        if (!this.mHome) {
            return Arrays.copyOf(validStateKeys2AspectDistant, validStateKeys2AspectDistant.length);
        }
        switch (this.mAspects) {
            case 2: {
                return Arrays.copyOf(validStateKeys2AspectHome, validStateKeys2AspectHome.length);
            }
            case 3: {
                return Arrays.copyOf(validStateKeys3Aspect, validStateKeys3Aspect.length);
            }
            case 4: {
                return Arrays.copyOf(validStateKeys4Aspect, validStateKeys3Aspect.length);
            }
        }
        log.warn("Unexpected number of aspects: {}", (Object)this.mAspects);
        return Arrays.copyOf(validStateKeys3Aspect, validStateKeys3Aspect.length);
    }

    @Override
    public String[] getValidStateNames() {
        String[] stateNames = new String[this.getValidStateKeys().length];
        int i = 0;
        String[] stringArray = this.getValidStateKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String stateKey = stringArray[n2];
            stateNames[i++] = Bundle.getMessage(stateKey);
            ++n2;
        }
        return stateNames;
    }

    @Override
    boolean isTurnoutUsed(Turnout t) {
        if (this.getInput1() != null && t.equals(this.getInput1().getBean())) {
            return true;
        }
        if (this.getInput2() != null && t.equals(this.getInput2().getBean())) {
            return true;
        }
        return this.getInput3() != null && t.equals(this.getInput3().getBean());
    }
}

