/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Turnout;
import jmri.implementation.AbstractSignalMast;
import jmri.implementation.Bundle;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatrixSignalMast
extends AbstractSignalMast {
    private int mastBitNum = 6;
    private int mDelay = 0;
    private static final String errorChars = "nnnnnn";
    private final char[] errorBits = "nnnnnn".toCharArray();
    private static final String emptyChars = "000000";
    private final char[] emptyBits = "000000".toCharArray();
    private static final String mastType = "IF$xsm";
    private final HashMap<String, char[]> aspectToOutput = new HashMap(16);
    private char[] unLitBits;
    protected HashMap<String, NamedBeanHandle<Turnout>> outputsToBeans = new HashMap();
    private boolean resetPreviousStates = false;
    private static volatile int lastRef = 0;
    private static final Logger log = LoggerFactory.getLogger(MatrixSignalMast.class);

    public MatrixSignalMast(String systemName, String userName) {
        super(systemName, userName);
        this.configureFromName(systemName);
    }

    public MatrixSignalMast(String systemName) {
        super(systemName);
        this.configureFromName(systemName);
    }

    private void configureFromName(@Nonnull String systemName) {
        String[] parts = systemName.split(":");
        if (parts.length < 3) {
            log.error("SignalMast system name needs at least three parts: {}", (Object)systemName);
            throw new IllegalArgumentException("System name needs at least three parts: " + systemName);
        }
        if (!parts[0].equals(mastType)) {
            log.warn("SignalMast system name should start with \"{}\" but is \"{}\"", (Object)mastType, (Object)systemName);
        }
        String system = parts[1];
        String mast = parts[2];
        mast = mast.substring(0, mast.indexOf("("));
        this.setMastType(mast);
        String tmp = parts[2].substring(parts[2].indexOf("($") + 2, parts[2].indexOf(")"));
        try {
            int autoNumber = Integer.parseInt(tmp);
            if (autoNumber > MatrixSignalMast.getLastRef()) {
                MatrixSignalMast.setLastRef(autoNumber);
            }
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("Auto generated SystemName \"{}\" is not in the correct format", (Object)systemName);
        }
        this.configureSignalSystemDefinition(system);
        this.configureAspectTable(system, mast);
    }

    public synchronized void setBitsForAspect(String aspect, char[] bitArray) {
        if (this.aspectToOutput.containsKey(aspect)) {
            if (log.isDebugEnabled()) {
                log.debug("Aspect {} is already defined as {}", (Object)aspect, (Object)Arrays.toString(this.aspectToOutput.get(aspect)));
            }
            this.aspectToOutput.remove(aspect);
        }
        this.aspectToOutput.put(aspect, bitArray);
    }

    public synchronized char[] getBitsForAspect(String aspect) {
        if (!this.aspectToOutput.containsKey(aspect) || this.aspectToOutput.get(aspect) == null) {
            log.error("Trying to get aspect {} but it has not been configured", (Object)aspect);
            return this.errorBits;
        }
        return this.aspectToOutput.get(aspect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAspect(@Nonnull String aspect) {
        if (!this.map.checkAspect(aspect)) {
            log.warn("attempting to set invalid Aspect: {} on mast {}", (Object)aspect, (Object)this.getDisplayName());
            throw new IllegalArgumentException("attempting to set invalid Aspect: " + aspect + " on mast: " + this.getDisplayName());
        }
        if (this.disabledAspects.contains(aspect)) {
            log.warn("attempting to set an Aspect that has been Disabled: {} on mast {}", (Object)aspect, (Object)this.getDisplayName());
            throw new IllegalArgumentException("attempting to set an Aspect that has been Disabled: " + aspect + " on mast: " + this.getDisplayName());
        }
        if (this.getLit()) {
            MatrixSignalMast matrixSignalMast = this;
            synchronized (matrixSignalMast) {
                if (this.resetPreviousStates) {
                    if (this.aspectToOutput.containsKey("Stop")) {
                        this.updateOutputs(this.getBitsForAspect("Stop"));
                    } else if (this.unLitBits != null) {
                        this.updateOutputs(this.unLitBits);
                    }
                }
                if (this.aspectToOutput.containsKey(aspect) && this.aspectToOutput.get(aspect) != this.errorBits) {
                    char[] bitArray = this.getBitsForAspect(aspect);
                    this.updateOutputs(bitArray);
                } else {
                    log.error("Trying to set an aspect ({}) on signal mast {} which has not been configured", (Object)aspect, (Object)this.getDisplayName());
                }
            }
        } else {
            log.debug("Mast set to unlit, will not send aspect change to hardware");
        }
        super.setAspect(aspect);
    }

    @Override
    public void setLit(boolean newLit) {
        if (!this.allowUnLit() || newLit == this.getLit()) {
            return;
        }
        super.setLit(newLit);
        if (newLit) {
            if (this.getAspect() != null) {
                this.setAspect(this.getAspect());
            }
        } else if (this.unLitBits != null) {
            this.updateOutputs(this.unLitBits);
        }
    }

    public void setUnLitBits(@Nonnull char[] bits) {
        this.unLitBits = bits;
    }

    public void setUnLitBits(@Nonnull String bitString) {
        this.setUnLitBits(bitString.toCharArray());
    }

    @Nonnull
    public char[] getUnLitBits() {
        if (this.unLitBits != null) {
            return this.unLitBits;
        }
        return this.emptyBits;
    }

    @Nonnull
    public String getUnLitChars() {
        if (this.unLitBits != null) {
            return String.valueOf(this.unLitBits);
        }
        log.error("Returning 0 values because unLitBits is empty");
        return emptyChars.substring(0, this.mastBitNum);
    }

    @CheckForNull
    private Turnout getOutputBean(int colNum) {
        String key = "output" + colNum;
        if (colNum > 0 && colNum <= this.outputsToBeans.size()) {
            return this.outputsToBeans.get(key).getBean();
        }
        log.error("Trying to read bean for output {} which has not been configured", (Object)colNum);
        return null;
    }

    @CheckForNull
    public NamedBeanHandle<Turnout> getOutputHandle(int colNum) {
        String key = "output" + colNum;
        if (colNum > 0 && colNum <= this.outputsToBeans.size()) {
            return this.outputsToBeans.get(key);
        }
        log.error("Trying to read output NamedBeanHandle {} which has not been configured", (Object)key);
        return null;
    }

    @Nonnull
    public String getOutputName(int colnum) {
        String key = "output" + colnum;
        if (colnum > 0 && colnum <= this.outputsToBeans.size()) {
            return this.outputsToBeans.get(key).getName();
        }
        log.error("Trying to read name of output {} which has not been configured", (Object)colnum);
        return "";
    }

    public synchronized void setBitstring(@Nonnull String aspect, @Nonnull String bitString) {
        if (this.aspectToOutput.containsKey(aspect)) {
            log.debug("Aspect {} is already defined so will override", (Object)aspect);
            this.aspectToOutput.remove(aspect);
        }
        char[] bitArray = bitString.toCharArray();
        this.aspectToOutput.put(aspect, bitArray);
    }

    public synchronized void setBitstring(String aspect, char[] bitArray) {
        if (this.aspectToOutput.containsKey(aspect)) {
            log.debug("Aspect {} is already defined so will override", (Object)aspect);
            this.aspectToOutput.remove(aspect);
        }
        this.aspectToOutput.put(aspect, bitArray);
    }

    @Nonnull
    public synchronized String getBitstring(@Nonnull String aspect) {
        if (this.aspectToOutput.containsKey(aspect)) {
            return new String(this.aspectToOutput.get(aspect));
        }
        return "";
    }

    @Nonnull
    public List<String> getOutputs() {
        ArrayList<String> outputlist = new ArrayList<String>();
        int index = 1;
        while (this.outputsToBeans.containsKey("output" + index)) {
            outputlist.add(this.outputsToBeans.get("output" + index).getName());
            ++index;
        }
        return outputlist;
    }

    public void setOutput(@Nonnull String colname, @Nonnull String turnoutname) {
        Turnout turn = InstanceManager.turnoutManagerInstance().getTurnout(turnoutname);
        if (turn == null) {
            log.error("setOutput couldn't locate turnout {}", (Object)turnoutname);
            return;
        }
        NamedBeanHandle<Turnout> namedTurnout = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(turnoutname, turn);
        if (this.outputsToBeans.containsKey(colname)) {
            log.debug("Output {} is already defined so will override", (Object)colname);
            this.outputsToBeans.remove(colname);
        }
        this.outputsToBeans.put(colname, namedTurnout);
    }

    public void updateOutputs(char[] bits) {
        if (bits == null) {
            log.debug("Empty char[] received");
        } else {
            int i = 0;
            while (i < this.outputsToBeans.size()) {
                int newState;
                log.debug("Setting bits[1] = {} for output #{}", (Object)Character.valueOf(bits[i]), (Object)i);
                Turnout t = this.getOutputBean(i + 1);
                if (t != null) {
                    t.setBinaryOutput(true);
                }
                if (bits[i] == '1' && t != null && t.getCommandedState() != 2) {
                    newState = 2;
                } else if (bits[i] == '0' && t != null && t.getCommandedState() != 4) {
                    newState = 4;
                } else if (bits[i] == 'n' || bits[i] == 'u') {
                    newState = -1;
                } else {
                    newState = -2;
                    log.debug("Element {} not converted to state for output #{}", (Object)Character.valueOf(bits[i]), (Object)i);
                }
                if (newState >= 0 && t != null) {
                    int toState = newState;
                    Turnout setTurnout = t;
                    ThreadingUtil.runOnLayoutEventually(() -> setTurnout.setCommandedStateAtInterval(toState));
                    try {
                        Thread.sleep(this.mDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        log.debug("interrupted in updateOutputs");
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                ++i;
            }
        }
    }

    public void resetPreviousStates(boolean boo) {
        this.resetPreviousStates = boo;
    }

    public boolean resetPreviousStates() {
        return this.resetPreviousStates;
    }

    boolean isTurnoutUsed(Turnout t) {
        int i = 1;
        while (i <= this.outputsToBeans.size()) {
            if (t.equals(this.getOutputBean(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int getLastRef() {
        return lastRef;
    }

    protected static void setLastRef(int newVal) {
        lastRef = newVal;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Turnout && this.isTurnoutUsed((Turnout)evt.getOldValue())) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
            throw new PropertyVetoException(Bundle.getMessage("InUseTurnoutSignalMastVeto", this.getDisplayName()), e);
        }
    }

    public void setBitNum(int number) {
        this.mastBitNum = number;
    }

    public void setBitNum(char[] bits) {
        this.mastBitNum = bits.length;
    }

    public int getBitNum() {
        return this.mastBitNum;
    }

    @Override
    public void setAspectDisabled(String aspect) {
        if (aspect == null || aspect.equals("")) {
            return;
        }
        if (!this.map.checkAspect(aspect)) {
            log.warn("attempting to disable an aspect: {} that is not on mast {}", (Object)aspect, (Object)this.getDisplayName());
            return;
        }
        if (!this.disabledAspects.contains(aspect)) {
            this.disabledAspects.add(aspect);
            this.firePropertyChange("aspectDisabled", null, aspect);
        }
    }

    public void setMatrixMastCommandDelay(int delay) {
        if (delay >= 0) {
            this.mDelay = delay;
        }
    }

    public int getMatrixMastCommandDelay() {
        return this.mDelay;
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

