/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import jmri.Conditional;
import jmri.NamedBeanHandle;
import jmri.implementation.JmriSimplePropertyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriMultiStatePropertyListener
extends JmriSimplePropertyListener {
    ArrayList<Integer> _states = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(JmriMultiStatePropertyListener.class);

    JmriMultiStatePropertyListener(String propName, int type, String name, Conditional.Type varType, Conditional client, int state) {
        super(propName, type, name, varType, client);
        this._states.add(state);
    }

    JmriMultiStatePropertyListener(String propName, int type, NamedBeanHandle<?> namedBean, Conditional.Type varType, Conditional client, int state) {
        super(propName, type, namedBean, varType, client);
        this._states.add(state);
    }

    public void setState(int state) {
        this._states.add(state);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int oldState;
        int newState;
        log.debug("\"{}\" sent PropertyChangeEvent {}, old value =\"{}\", new value =\"{}, enabled = {}", new Object[]{this._varName, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue(), this._enabled});
        if (this.getPropertyName().equals(evt.getPropertyName()) && (newState = ((Number)evt.getNewValue()).intValue()) != (oldState = ((Number)evt.getOldValue()).intValue())) {
            int i = 0;
            while (i < this._states.size()) {
                int state = this._states.get(i);
                if (oldState == state || newState == state) {
                    this.calculateClient(i, evt);
                }
                ++i;
            }
        }
    }
}

