/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.util.Date;
import jmri.Conditional;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.implementation.JmriSimplePropertyListener;

public class JmriClockPropertyListener
extends JmriSimplePropertyListener {
    static int SIZE = 10;
    int numRanges = 0;
    int[] _beginTimes = new int[SIZE];
    int[] _endTimes = new int[SIZE];
    boolean[] _rangeList = new boolean[SIZE];
    Timebase _fastClock;
    int _currentMinutes;

    JmriClockPropertyListener(String propName, int type, String name, Conditional.Type varType, Conditional client, int beginTime, int endTime) {
        super(propName, type, name, varType, client);
        this._beginTimes[0] = this.fixMidnight(beginTime);
        this._endTimes[0] = this.fixMidnight(endTime);
        this._rangeList[0] = false;
        this.numRanges = 1;
        this._fastClock = InstanceManager.getDefault(Timebase.class);
        Date currentTime = this._fastClock.getTime();
        this._currentMinutes = currentTime.getHours() * 60 + currentTime.getMinutes();
    }

    private int fixMidnight(int time) {
        if (time > 1440) {
            time -= 1440;
        }
        return time;
    }

    public void setRange(int beginTime, int endTime) {
        if (this.numRanges >= this._rangeList.length) {
            int[] temp = new int[this.numRanges + SIZE];
            System.arraycopy(this._beginTimes, 0, temp, 0, this._beginTimes.length);
            this._beginTimes = temp;
            temp = new int[this.numRanges + SIZE];
            System.arraycopy(this._endTimes, 0, temp, 0, this._endTimes.length);
            this._endTimes = temp;
            boolean[] bools = new boolean[this.numRanges + SIZE];
            System.arraycopy(this._rangeList, 0, bools, 0, this._rangeList.length);
            this._rangeList = bools;
        }
        this._beginTimes[this.numRanges] = this.fixMidnight(beginTime);
        this._endTimes[this.numRanges] = this.fixMidnight(endTime);
        this._rangeList[this.numRanges] = false;
        ++this.numRanges;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Date currentTime = this._fastClock.getTime();
        this._currentMinutes = currentTime.getHours() * 60 + currentTime.getMinutes();
        boolean[] newRangeList = new boolean[this._rangeList.length];
        int i = 0;
        while (i < this.numRanges) {
            newRangeList[i] = this._beginTimes[i] < this._endTimes[i] ? this._beginTimes[i] <= this._currentMinutes && this._currentMinutes <= this._endTimes[i] : this._beginTimes[i] <= this._currentMinutes || this._currentMinutes <= this._endTimes[i];
            ++i;
        }
        i = 0;
        while (i < this.numRanges) {
            if (this._rangeList[i] != newRangeList[i]) {
                this._rangeList = newRangeList;
                super.propertyChange(evt);
            }
            ++i;
        }
    }
}

