/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import jmri.implementation.Bundle;
import jmri.profile.Profile;
import jmri.profile.ProfileUtils;
import jmri.spi.PreferencesManager;
import jmri.util.FileUtil;
import jmri.util.prefs.AbstractPreferencesManager;
import jmri.util.prefs.InitializationException;

public class FileLocationsPreferences
extends AbstractPreferencesManager {
    public static final String USER_FILES = "user-files";
    public static final String SCRIPTS = "scripts";

    @Override
    public void initialize(Profile profile) throws InitializationException {
        if (!this.isInitialized(profile)) {
            Preferences shared = ProfileUtils.getPreferences(profile, this.getClass(), true);
            Preferences perNode = ProfileUtils.getPreferences(profile, this.getClass(), false);
            String userFiles = shared.get(USER_FILES, "profile:");
            if (!userFiles.startsWith("profile:")) {
                userFiles = perNode.get(USER_FILES, userFiles);
            }
            FileUtil.setUserFilesPath(profile, FileUtil.getAbsoluteFilename(profile, userFiles));
            String scripts = shared.get(SCRIPTS, "profile:");
            if (!scripts.startsWith("profile:") && !scripts.startsWith("program:")) {
                scripts = perNode.get(SCRIPTS, scripts);
            }
            FileUtil.setScriptsPath(profile, FileUtil.getAbsoluteFilename(profile, scripts));
            this.setInitialized(profile, true);
            try {
                if (!FileUtil.getFile(profile, userFiles).isDirectory()) {
                    String message = "UserFilesIsNotDir";
                    userFiles = FileUtil.getAbsoluteFilename(profile, userFiles);
                    throw new InitializationException(Bundle.getMessage(Locale.ENGLISH, message, userFiles), Bundle.getMessage(message, userFiles));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                String message = "UserFilesDoesNotExist";
                userFiles = FileUtil.getAbsoluteFilename(profile, userFiles);
                throw new InitializationException(Bundle.getMessage(Locale.ENGLISH, message, userFiles), Bundle.getMessage(message, userFiles));
            }
            try {
                if (!FileUtil.getFile(profile, scripts).isDirectory()) {
                    String message = "ScriptsIsNotDir";
                    scripts = FileUtil.getAbsoluteFilename(profile, scripts);
                    throw new InitializationException(Bundle.getMessage(Locale.ENGLISH, message, scripts), Bundle.getMessage(message, scripts));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                String message = "ScriptsDoesNotExist";
                scripts = FileUtil.getAbsoluteFilename(profile, scripts);
                throw new InitializationException(Bundle.getMessage(Locale.ENGLISH, message, scripts), Bundle.getMessage(message, scripts));
            }
        }
    }

    @Override
    @Nonnull
    public Set<Class<? extends PreferencesManager>> getRequires() {
        return new HashSet<Class<? extends PreferencesManager>>();
    }

    @Override
    public void savePreferences(Profile profile) {
        Preferences shared = ProfileUtils.getPreferences(profile, this.getClass(), true);
        Preferences perNode = ProfileUtils.getPreferences(profile, this.getClass(), false);
        shared.put(USER_FILES, FileUtil.getPortableFilename(profile, FileUtil.getUserFilesPath(profile), true, false));
        shared.put(SCRIPTS, FileUtil.getPortableFilename(profile, FileUtil.getScriptsPath(profile)));
        perNode.put(USER_FILES, FileUtil.getPortableFilename(profile, FileUtil.getUserFilesPath(profile), true, false));
        perNode.put(SCRIPTS, FileUtil.getPortableFilename(profile, FileUtil.getScriptsPath(profile)));
    }
}

