/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Timer;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.Turnout;
import jmri.implementation.DefaultSignalHead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleTurnoutSignalHead
extends DefaultSignalHead {
    NamedBeanHandle<Turnout> mRed;
    NamedBeanHandle<Turnout> mGreen;
    int mRedCommanded;
    int mGreenCommanded;
    Timer readUpdateTimer;
    private PropertyChangeListener turnoutChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("KnownState")) {
                if (propertyChangeEvent.getSource().equals(DoubleTurnoutSignalHead.this.mRed.getBean()) && propertyChangeEvent.getNewValue().equals(DoubleTurnoutSignalHead.this.mRedCommanded)) {
                    return;
                }
                if (propertyChangeEvent.getSource().equals(DoubleTurnoutSignalHead.this.mGreen.getBean()) && propertyChangeEvent.getNewValue().equals(DoubleTurnoutSignalHead.this.mGreenCommanded)) {
                    return;
                }
                if (DoubleTurnoutSignalHead.this.readUpdateTimer == null) {
                    DoubleTurnoutSignalHead.this.readUpdateTimer = new Timer(200, actionEvent -> DoubleTurnoutSignalHead.this.readOutput());
                    DoubleTurnoutSignalHead.this.readUpdateTimer.setRepeats(false);
                    DoubleTurnoutSignalHead.this.readUpdateTimer.start();
                } else {
                    DoubleTurnoutSignalHead.this.readUpdateTimer.restart();
                }
            }
        }
    };
    private static final Logger log = LoggerFactory.getLogger(DoubleTurnoutSignalHead.class);

    public DoubleTurnoutSignalHead(String sys, String user, NamedBeanHandle<Turnout> green, NamedBeanHandle<Turnout> red) {
        super(sys, user);
        this.setRed(red);
        this.setGreen(green);
    }

    public DoubleTurnoutSignalHead(String sys, NamedBeanHandle<Turnout> green, NamedBeanHandle<Turnout> red) {
        super(sys);
        this.setRed(red);
        this.setGreen(green);
    }

    @Override
    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    protected void updateOutput() {
        if (!this.mLit) {
            this.commandState(2, 2);
            return;
        }
        if (!(this.mFlashOn || this.mAppearance != 32 && this.mAppearance != 8 && this.mAppearance != 2)) {
            this.commandState(2, 2);
            return;
        }
        switch (this.mAppearance) {
            case 1: 
            case 2: {
                this.commandState(4, 2);
                break;
            }
            case 4: 
            case 8: {
                this.commandState(4, 4);
                break;
            }
            case 16: 
            case 32: {
                this.commandState(2, 4);
                break;
            }
            default: {
                log.warn("Unexpected new appearance: {}", (Object)this.mAppearance);
            }
            case 0: {
                this.commandState(2, 2);
            }
        }
    }

    void commandState(int red, int green) {
        this.mRedCommanded = red;
        this.mRed.getBean().setCommandedState(red);
        this.mGreenCommanded = green;
        this.mGreen.getBean().setCommandedState(green);
    }

    @Override
    public void dispose() {
        if (this.mRed != null) {
            this.mRed.getBean().removePropertyChangeListener(this.turnoutChangeListener);
        }
        if (this.mGreen != null) {
            this.mGreen.getBean().removePropertyChangeListener(this.turnoutChangeListener);
        }
        this.mRed = null;
        this.mGreen = null;
        InstanceManager.turnoutManagerInstance().removeVetoableChangeListener(this);
        super.dispose();
    }

    public NamedBeanHandle<Turnout> getRed() {
        return this.mRed;
    }

    public NamedBeanHandle<Turnout> getGreen() {
        return this.mGreen;
    }

    public void setRed(NamedBeanHandle<Turnout> t) {
        if (this.mRed != null) {
            this.mRed.getBean().removePropertyChangeListener(this.turnoutChangeListener);
        }
        this.mRed = t;
        if (this.mRed != null) {
            this.mRed.getBean().addPropertyChangeListener(this.turnoutChangeListener);
        }
    }

    public void setGreen(NamedBeanHandle<Turnout> t) {
        if (this.mGreen != null) {
            this.mGreen.getBean().removePropertyChangeListener(this.turnoutChangeListener);
        }
        this.mGreen = t;
        if (this.mGreen != null) {
            this.mGreen.getBean().addPropertyChangeListener(this.turnoutChangeListener);
        }
    }

    @Override
    boolean isTurnoutUsed(Turnout t) {
        if (this.getRed() != null && t.equals(this.getRed().getBean())) {
            return true;
        }
        return this.getGreen() != null && t.equals(this.getGreen().getBean());
    }

    void readOutput() {
        if (this.mAppearance == 32 || this.mAppearance == 8 || this.mAppearance == 2 || this.mAppearance == 128) {
            return;
        }
        int red = this.mRed.getBean().getKnownState();
        int green = this.mGreen.getBean().getKnownState();
        if (this.mRedCommanded == red && this.mGreenCommanded == green) {
            return;
        }
        if (red == 2 && green == 2) {
            this.setAppearance(0);
        } else if (red == 4 && green == 2) {
            this.setAppearance(1);
        } else if (red == 4 && green == 4) {
            this.setAppearance(4);
        } else if (red == 2 && green == 4) {
            this.setAppearance(16);
        }
    }
}

