/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import jmri.InstanceManager;
import jmri.SignalSystem;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import jmri.implementation.SignalSpeedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignalSystem
extends AbstractNamedBean
implements SignalSystem {
    float maximumLineSpeed = 0.0f;
    protected HashMap<String, Hashtable<String, Object>> aspects = new LinkedHashMap<String, Hashtable<String, Object>>();
    protected Vector<String> keys = new Vector();
    protected Vector<String> imageTypes = new Vector();
    private static final Logger log = LoggerFactory.getLogger(DefaultSignalSystem.class);

    public DefaultSignalSystem(String systemName, String userName) {
        super(systemName, userName);
    }

    public DefaultSignalSystem(String systemName) {
        super(systemName);
    }

    @Override
    public void setProperty(String aspect, String key, Object value) {
        this.getTable(aspect).put(key, value);
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
    }

    @Override
    public Object getProperty(String aspect, String key) {
        if (aspect == null) {
            return null;
        }
        return this.getTable(aspect).get(key);
    }

    @Override
    public void setImageType(String type) {
        if (!this.imageTypes.contains(type)) {
            this.imageTypes.add(type);
        }
    }

    @Override
    public Enumeration<String> getImageTypeList() {
        return this.imageTypes.elements();
    }

    @Override
    public String getAspect(Object obj, String key) {
        if (obj == null) {
            return null;
        }
        Set<String> aspectKeys = this.aspects.keySet();
        for (String aspect : aspectKeys) {
            if (!this.getTable(aspect).containsKey(key) || !this.getTable(aspect).get(key).equals(obj)) continue;
            return aspect;
        }
        return null;
    }

    protected Hashtable<String, Object> getTable(String aspect) {
        Hashtable<String, Object> t = this.aspects.get(aspect);
        if (t == null) {
            t = new Hashtable();
            this.aspects.put(aspect, t);
        }
        return t;
    }

    @Override
    public Enumeration<String> getAspects() {
        return new Vector<String>(this.aspects.keySet()).elements();
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.keys.elements();
    }

    @Override
    public boolean checkAspect(String aspect) {
        return this.aspects.get(aspect) != null;
    }

    public void loadDefaults() {
        log.debug("start loadDefaults");
        String key = Bundle.getMessage("SignalAspectKey");
        String aspect = Bundle.getMessage("SignalAspectDefaultRed");
        String value = Bundle.getMessage("SignalAspect_" + key + "_" + aspect);
        this.setProperty(aspect, key, value);
        aspect = Bundle.getMessage("SignalAspectDefaultYellow");
        value = Bundle.getMessage("SignalAspect_" + key + "_" + aspect);
        this.setProperty(aspect, key, value);
        aspect = Bundle.getMessage("SignalAspectDefaultGreen");
        value = Bundle.getMessage("SignalAspect_" + key + "_" + aspect);
        this.setProperty(aspect, key, value);
    }

    @Override
    public int getState() {
        return 8;
    }

    @Override
    public void setState(int s) {
    }

    @Override
    public float getMaximumLineSpeed() {
        if (this.maximumLineSpeed == 0.0f) {
            for (String as : this.aspects.keySet()) {
                String speed = (String)this.getProperty(as, "speed");
                if (speed == null) continue;
                float aspectSpeed = 0.0f;
                try {
                    aspectSpeed = Float.parseFloat(speed);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        aspectSpeed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(speed);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.debug("Speed {} not found in map", (Object)speed);
                    }
                }
                if (!(aspectSpeed > this.maximumLineSpeed)) continue;
                this.maximumLineSpeed = aspectSpeed;
            }
        }
        if (this.maximumLineSpeed == 0.0f) {
            this.maximumLineSpeed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed("Maximum");
        }
        return this.maximumLineSpeed;
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameSignalSystem");
    }

    @Override
    public String summary() {
        StringBuilder retval = new StringBuilder();
        retval.append(this.toString());
        retval.append("\n  BeanType: ").append(this.getBeanType());
        retval.append("\n  keys:");
        for (String key : this.keys) {
            retval.append("\n    ").append(key);
        }
        retval.append("\n  aspects:");
        Set<String> values = this.aspects.keySet();
        for (String value : values) {
            retval.append("\n    ").append(value);
        }
        retval.append("\n  maximumLineSpeed = ").append(this.getMaximumLineSpeed());
        return new String(retval);
    }
}

