/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import jmri.Block;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.Path;
import jmri.Section;
import jmri.Sensor;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.Turnout;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.ConnectivityUtil;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockConnectivityTools;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrackExpectedState;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignalMastLogic
extends AbstractNamedBean
implements SignalMastLogic,
VetoableChangeListener {
    SignalMast source;
    SignalMast destination;
    String stopAspect;
    Hashtable<SignalMast, DestinationMast> destList = new Hashtable();
    LayoutEditor editor;
    boolean useAutoGenBlock = true;
    boolean useAutoGenTurnouts = true;
    LayoutBlock facingBlock = null;
    LayoutBlock remoteProtectingBlock = null;
    boolean disposing = false;
    volatile boolean inWait = false;
    protected PropertyChangeListener propertyDestinationMastListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            SignalMast mast = (SignalMast)e.getSource();
            if (mast == DefaultSignalMastLogic.this.destination) {
                if (log.isDebugEnabled()) {
                    log.debug("destination mast change {}", (Object)mast.getDisplayName());
                }
                DefaultSignalMastLogic.this.setSignalAppearance();
            }
        }
    };
    protected PropertyChangeListener propertySourceMastListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            SignalMast mast = (SignalMast)e.getSource();
            if (mast == DefaultSignalMastLogic.this.source && e.getPropertyName().equals("Held")) {
                if (log.isDebugEnabled()) {
                    log.debug("source mast change {} {}", (Object)mast.getDisplayName(), (Object)e.getPropertyName());
                }
                DefaultSignalMastLogic.this.setSignalAppearance();
            }
        }
    };
    private static final Logger log = LoggerFactory.getLogger(DefaultSignalMastLogic.class);

    public DefaultSignalMastLogic(@Nonnull SignalMast source) {
        super(source.toString());
        this.source = source;
        try {
            this.stopAspect = source.getAppearanceMap().getSpecificAppearance(2);
            this.source.addPropertyChangeListener(this.propertySourceMastListener);
            if (source.getAspect() == null) {
                source.setAspect(this.stopAspect);
            }
        }
        catch (Exception ex) {
            log.error("Error while creating Signal Logic {}", (Throwable)ex);
        }
    }

    @Override
    public void setFacingBlock(LayoutBlock facing) {
        this.facingBlock = facing;
    }

    @Override
    public LayoutBlock getFacingBlock() {
        return this.facingBlock;
    }

    @Override
    public LayoutBlock getProtectingBlock(@Nonnull SignalMast dest) {
        if (!this.destList.containsKey(dest)) {
            return null;
        }
        return this.destList.get(dest).getProtectingBlock();
    }

    @Override
    public SignalMast getSourceMast() {
        return this.source;
    }

    @Override
    public void replaceSourceMast(SignalMast oldMast, SignalMast newMast) {
        if (oldMast != this.source) {
            return;
        }
        this.source.removePropertyChangeListener(this.propertySourceMastListener);
        this.source = newMast;
        this.stopAspect = this.source.getAppearanceMap().getSpecificAppearance(2);
        this.source.addPropertyChangeListener(this.propertySourceMastListener);
        if (this.source.getAspect() == null) {
            this.source.setAspect(this.stopAspect);
        }
        for (SignalMast sm : this.getDestinationList()) {
            DestinationMast destMast = this.destList.get(sm);
            if (destMast.getAssociatedSection() == null) continue;
            String oldUserName = destMast.getAssociatedSection().getUserName();
            String newUserName = String.valueOf(this.source.getDisplayName()) + ":" + sm.getDisplayName();
            if (oldUserName != null) {
                InstanceManager.getDefault(NamedBeanHandleManager.class).renameBean(oldUserName, newUserName, destMast.getAssociatedSection());
                continue;
            }
            log.warn("AssociatedSection oldUserName null for destination mast {}, skipped", (Object)destMast.getDisplayName());
        }
        this.firePropertyChange("updatedSource", oldMast, newMast);
    }

    @Override
    public void replaceDestinationMast(SignalMast oldMast, SignalMast newMast) {
        if (!this.destList.containsKey(oldMast)) {
            return;
        }
        DestinationMast destMast = this.destList.get(oldMast);
        destMast.updateDestinationMast(newMast);
        if (this.destination == oldMast) {
            oldMast.removePropertyChangeListener(this.propertyDestinationMastListener);
            newMast.addPropertyChangeListener(this.propertyDestinationMastListener);
            this.destination = newMast;
            this.setSignalAppearance();
        }
        this.destList.remove(oldMast);
        if (destMast.getAssociatedSection() != null) {
            String oldUserName = destMast.getAssociatedSection().getUserName();
            String newUserName = String.valueOf(this.source.getDisplayName()) + ":" + newMast.getDisplayName();
            if (oldUserName != null) {
                InstanceManager.getDefault(NamedBeanHandleManager.class).renameBean(oldUserName, newUserName, destMast.getAssociatedSection());
            } else {
                log.warn("AssociatedSection oldUserName null for destination mast {}, skipped", (Object)destMast.getDisplayName());
            }
        }
        this.destList.put(newMast, destMast);
        this.firePropertyChange("updatedDestination", oldMast, newMast);
    }

    @Override
    public void setDestinationMast(SignalMast dest) {
        if (this.destList.containsKey(dest)) {
            log.debug("Destination mast '{}' was already defined in SML with this source mast", (Object)dest.getDisplayName());
            return;
        }
        int oldSize = this.destList.size();
        this.destList.put(dest, new DestinationMast(dest));
        this.firePropertyChange("length", oldSize, this.destList.size());
    }

    @Override
    public boolean isDestinationValid(SignalMast dest) {
        if (dest == null) {
            return false;
        }
        return this.destList.containsKey(dest);
    }

    @Override
    public List<SignalMast> getDestinationList() {
        ArrayList<SignalMast> out = new ArrayList<SignalMast>();
        Enumeration<SignalMast> en = this.destList.keys();
        while (en.hasMoreElements()) {
            out.add(en.nextElement());
        }
        return out;
    }

    @Override
    public String getComment(SignalMast dest) {
        if (!this.destList.containsKey(dest)) {
            return "";
        }
        return this.destList.get(dest).getComment();
    }

    @Override
    public void setComment(String comment, SignalMast dest) {
        if (!this.destList.containsKey(dest)) {
            return;
        }
        this.destList.get(dest).setComment(comment);
    }

    @Override
    public void setStore(int store, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        this.destList.get(destination).setStore(store);
    }

    @Override
    public int getStoreState(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return 4;
        }
        return this.destList.get(destination).getStoreState();
    }

    @Override
    public void setEnabled(SignalMast dest) {
        if (!this.destList.containsKey(dest)) {
            return;
        }
        this.destList.get(dest).setEnabled();
    }

    @Override
    public void setDisabled(SignalMast dest) {
        if (!this.destList.containsKey(dest)) {
            return;
        }
        this.destList.get(dest).setDisabled();
    }

    @Override
    public boolean isEnabled(SignalMast dest) {
        if (!this.destList.containsKey(dest)) {
            return false;
        }
        return this.destList.get(dest).isEnabled();
    }

    @Override
    public boolean isActive(SignalMast dest) {
        if (!this.destList.containsKey(dest)) {
            return false;
        }
        return this.destList.get(dest).isActive();
    }

    @Override
    public SignalMast getActiveDestination() {
        for (SignalMast sm : this.getDestinationList()) {
            if (!this.destList.get(sm).isActive()) continue;
            return sm;
        }
        return null;
    }

    @Override
    public boolean removeDestination(SignalMast dest) {
        int oldSize = this.destList.size();
        if (this.destList.containsKey(dest)) {
            this.destList.get(dest).dispose();
            this.destList.remove(dest);
            this.firePropertyChange("length", oldSize, this.destList.size());
        }
        return this.destList.isEmpty();
    }

    @Override
    public void disableLayoutEditorUse() {
        for (DestinationMast dest : this.destList.values()) {
            try {
                dest.useLayoutEditor(false);
            }
            catch (JmriException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void useLayoutEditor(boolean boo, SignalMast destination) throws JmriException {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        if (boo) {
            log.debug("Set use layout editor");
            SortedSet<LayoutEditor> layout = InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class);
            log.debug("userLayoutEditor finds layout list size is {}", (Object)Integer.toString(layout.size()));
            for (LayoutEditor editor : layout) {
                if (log.isDebugEnabled()) {
                    log.debug(editor.getLayoutName());
                }
                if (this.facingBlock != null) continue;
                this.facingBlock = InstanceManager.getDefault(LayoutBlockManager.class).getFacingBlockByMast(this.getSourceMast(), editor);
            }
        }
        this.destList.get(destination).useLayoutEditor(boo);
    }

    @Override
    public int setupDirectionSensors() {
        int errorCount = 0;
        for (SignalMast sm : this.getDestinationList()) {
            String displayName = sm.getDisplayName();
            Section sec = this.getAssociatedSection(sm);
            Block facingBlock = null;
            if (sec != null) {
                Sensor fwd = sec.getForwardBlockingSensor();
                Sensor rev = sec.getReverseBlockingSensor();
                LayoutBlock lBlock = this.getFacingBlock();
                if (lBlock == null) {
                    try {
                        this.useLayoutEditor(true, sm);
                    }
                    catch (JmriException jmriException) {
                        continue;
                    }
                }
                if (lBlock != null) {
                    facingBlock = lBlock.getBlock();
                    EntryPoint fwdEntryPoint = sec.getEntryPointFromBlock(facingBlock, 4);
                    EntryPoint revEntryPoint = sec.getEntryPointFromBlock(facingBlock, 8);
                    log.debug("Mast[{}] Sec[{}] Fwd[{}] Rev [{}]", new Object[]{displayName, sec, fwd, rev});
                    if (fwd != null && fwdEntryPoint != null) {
                        this.addSensor(fwd.getUserName(), 4, sm);
                        log.debug("Mast[{}] Sec[{}] Fwd[{}] fwdEP[{}] revEP[{}]", new Object[]{displayName, sec, fwd, fwdEntryPoint.getBlock().getUserName()});
                        continue;
                    }
                    if (rev != null && revEntryPoint != null) {
                        this.addSensor(rev.getUserName(), 4, sm);
                        log.debug("Mast[{}] Sec[{}] Rev [{}] fwdEP[{}] revEP[{}]", new Object[]{displayName, sec, rev, revEntryPoint.getBlock().getUserName()});
                        continue;
                    }
                    log.error("Mast[{}] Cannot Establish entry point to protected section", (Object)displayName);
                    ++errorCount;
                    continue;
                }
                log.error("Mast[{}] No Facing Block", (Object)displayName);
                ++errorCount;
                continue;
            }
            log.error("Mast[{}] No Associated Section", (Object)displayName);
            ++errorCount;
        }
        return errorCount;
    }

    @Override
    public void removeDirectionSensors() {
    }

    @Override
    public boolean useLayoutEditor(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return false;
        }
        return this.destList.get(destination).useLayoutEditor();
    }

    @Override
    public void useLayoutEditorDetails(boolean turnouts, boolean blocks, SignalMast destination) throws JmriException {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        this.destList.get(destination).useLayoutEditorDetails(turnouts, blocks);
    }

    @Override
    public boolean useLayoutEditorBlocks(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return false;
        }
        return this.destList.get(destination).useLayoutEditorBlocks();
    }

    @Override
    public boolean useLayoutEditorTurnouts(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return false;
        }
        return this.destList.get(destination).useLayoutEditorTurnouts();
    }

    @Override
    public Section getAssociatedSection(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return null;
        }
        return this.destList.get(destination).getAssociatedSection();
    }

    @Override
    public void setAssociatedSection(Section sec, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        this.destList.get(destination).setAssociatedSection(sec);
    }

    @Override
    public boolean allowAutoMaticSignalMastGeneration(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return false;
        }
        return this.destList.get(destination).allowAutoSignalMastGen();
    }

    @Override
    public void allowAutoMaticSignalMastGeneration(boolean allow, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        this.destList.get(destination).allowAutoSignalMastGen(allow);
    }

    @Override
    public void allowTurnoutLock(boolean lock, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        this.destList.get(destination).allowTurnoutLock(lock);
    }

    @Override
    public boolean isTurnoutLockAllowed(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return false;
        }
        return this.destList.get(destination).isTurnoutLockAllowed();
    }

    @Override
    public void setTurnouts(Hashtable<NamedBeanHandle<Turnout>, Integer> turnouts, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        this.destList.get(destination).setTurnouts(turnouts);
    }

    @Override
    public void setAutoTurnouts(Hashtable<Turnout, Integer> turnouts, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        this.destList.get(destination).setAutoTurnouts(turnouts);
    }

    @Override
    public void setBlocks(Hashtable<Block, Integer> blocks, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        this.destList.get(destination).setBlocks(blocks);
    }

    @Override
    public void setAutoBlocks(LinkedHashMap<Block, Integer> blocks, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        this.destList.get(destination).setAutoBlocks(blocks);
    }

    @Override
    public void setMasts(Hashtable<SignalMast, String> masts, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        this.destList.get(destination).setMasts(masts);
    }

    @Override
    public void setAutoMasts(Hashtable<SignalMast, String> masts, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        this.destList.get(destination).setAutoMasts(masts, true);
    }

    @Override
    public void setSensors(Hashtable<NamedBeanHandle<Sensor>, Integer> sensors, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        this.destList.get(destination).setSensors(sensors);
    }

    @Override
    public void addSensor(String sensorName, int state, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        Sensor sen = InstanceManager.sensorManagerInstance().getSensor(sensorName);
        if (sen != null) {
            NamedBeanHandle<Sensor> namedSensor = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, sen);
            this.destList.get(destination).addSensor(namedSensor, state);
        }
    }

    @Override
    public void removeSensor(String sensorName, SignalMast destination) {
        Sensor sen = InstanceManager.sensorManagerInstance().getSensor(sensorName);
        this.removeSensor(sen, destination);
    }

    public void removeSensor(Sensor sen, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        if (sen != null) {
            this.destList.get(destination).removeSensor(sen);
        }
    }

    @Override
    public List<Block> getBlocks(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return new ArrayList<Block>();
        }
        return this.destList.get(destination).getBlocks();
    }

    @Override
    public List<Block> getAutoBlocks(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return new ArrayList<Block>();
        }
        return this.destList.get(destination).getAutoBlocks();
    }

    @Override
    public List<Block> getAutoBlocksBetweenMasts(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return new ArrayList<Block>();
        }
        return this.destList.get(destination).getAutoBlocksBetweenMasts();
    }

    @Override
    public List<Turnout> getTurnouts(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return new ArrayList<Turnout>();
        }
        return this.destList.get(destination).getTurnouts();
    }

    @Override
    public List<NamedBeanHandle<Turnout>> getNamedTurnouts(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return new ArrayList<NamedBeanHandle<Turnout>>();
        }
        return this.destList.get(destination).getNamedTurnouts();
    }

    public void removeTurnout(Turnout turn, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return;
        }
        if (turn != null) {
            this.destList.get(destination).removeTurnout(turn);
        }
    }

    @Override
    public List<Turnout> getAutoTurnouts(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return new ArrayList<Turnout>();
        }
        return this.destList.get(destination).getAutoTurnouts();
    }

    @Override
    public List<Sensor> getSensors(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return new ArrayList<Sensor>();
        }
        return this.destList.get(destination).getSensors();
    }

    @Override
    public List<NamedBeanHandle<Sensor>> getNamedSensors(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return new ArrayList<NamedBeanHandle<Sensor>>();
        }
        return this.destList.get(destination).getNamedSensors();
    }

    @Override
    public List<SignalMast> getSignalMasts(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return new ArrayList<SignalMast>();
        }
        return this.destList.get(destination).getSignalMasts();
    }

    @Override
    public List<SignalMast> getAutoMasts(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return new ArrayList<SignalMast>();
        }
        return this.destList.get(destination).getAutoSignalMasts();
    }

    @Override
    public void initialise() {
        Enumeration<SignalMast> en = this.destList.keys();
        while (en.hasMoreElements()) {
            this.destList.get(en.nextElement()).initialise();
        }
    }

    @Override
    public void initialise(SignalMast destination) {
        if (this.disposing) {
            return;
        }
        if (!this.destList.containsKey(destination)) {
            return;
        }
        this.destList.get(destination).initialise();
    }

    @Override
    public LinkedHashMap<Block, Integer> setupLayoutEditorTurnoutDetails(List<LayoutBlock> blks, SignalMast destination) {
        if (this.disposing) {
            return new LinkedHashMap<Block, Integer>();
        }
        if (!this.destList.containsKey(destination)) {
            return new LinkedHashMap<Block, Integer>();
        }
        return this.destList.get(destination).setupLayoutEditorTurnoutDetails(blks);
    }

    @Override
    public void setupLayoutEditorDetails() {
        if (this.disposing) {
            return;
        }
        Enumeration<SignalMast> en = this.destList.keys();
        while (en.hasMoreElements()) {
            try {
                this.destList.get(en.nextElement()).setupLayoutEditorDetails();
            }
            catch (JmriException jmriException) {}
        }
    }

    boolean checkStates() {
        SignalMast oldActiveMast = this.destination;
        if (this.destination != null) {
            this.firePropertyChange("state", oldActiveMast, null);
            log.debug("Remove listener from destination");
            this.destination.removePropertyChangeListener(this.propertyDestinationMastListener);
            if (this.destList.containsKey(this.destination)) {
                this.destList.get(this.destination).clearTurnoutLock();
            }
        }
        Enumeration<SignalMast> en = this.destList.keys();
        log.debug("checkStates enumerates over {} mast(s)", (Object)this.destList.size());
        while (en.hasMoreElements()) {
            SignalMast key = en.nextElement();
            log.debug("  Destination mast {}", (Object)key.getDisplayName());
            log.debug("    isEnabled: {}", (Object)this.destList.get(key).isEnabled());
            log.debug("    isActive: {}", (Object)this.destList.get(key).isActive());
            if (!this.destList.get(key).isEnabled() || !this.destList.get(key).isActive()) continue;
            this.destination = key;
            log.debug("      Add listener to destination");
            this.destination.addPropertyChangeListener(this.propertyDestinationMastListener);
            log.debug("      firePropertyChange: \"state\"");
            this.firePropertyChange("state", oldActiveMast, this.destination);
            this.destList.get(key).lockTurnouts();
            return true;
        }
        return false;
    }

    @Override
    public boolean areBlocksIncluded(List<Block> blks) {
        Enumeration<SignalMast> en = this.destList.keys();
        while (en.hasMoreElements()) {
            SignalMast dm = en.nextElement();
            boolean included = false;
            int i = 0;
            while (i < blks.size()) {
                included = this.destList.get(dm).isBlockIncluded(blks.get(i));
                if (included) {
                    return true;
                }
                included = this.destList.get(dm).isAutoBlockIncluded(blks.get(i));
                if (included) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public int getBlockState(Block block, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return -1;
        }
        return this.destList.get(destination).getBlockState(block);
    }

    @Override
    public boolean isBlockIncluded(Block block, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return false;
        }
        return this.destList.get(destination).isBlockIncluded(block);
    }

    @Override
    public boolean isTurnoutIncluded(Turnout turnout, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return false;
        }
        return this.destList.get(destination).isTurnoutIncluded(turnout);
    }

    @Override
    public boolean isSensorIncluded(Sensor sensor, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return false;
        }
        return this.destList.get(destination).isSensorIncluded(sensor);
    }

    @Override
    public boolean isSignalMastIncluded(SignalMast signal, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return false;
        }
        return this.destList.get(destination).isSignalMastIncluded(signal);
    }

    @Override
    public int getAutoBlockState(Block block, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return -1;
        }
        return this.destList.get(destination).getAutoBlockState(block);
    }

    @Override
    public int getSensorState(Sensor sensor, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return -1;
        }
        return this.destList.get(destination).getSensorState(sensor);
    }

    @Override
    public int getTurnoutState(Turnout turnout, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return -1;
        }
        return this.destList.get(destination).getTurnoutState(turnout);
    }

    @Override
    public int getAutoTurnoutState(Turnout turnout, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return -1;
        }
        return this.destList.get(destination).getAutoTurnoutState(turnout);
    }

    @Override
    public String getSignalMastState(SignalMast mast, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return null;
        }
        return this.destList.get(destination).getSignalMastState(mast);
    }

    @Override
    public String getAutoSignalMastState(SignalMast mast, SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return null;
        }
        return this.destList.get(destination).getAutoSignalMastState(mast);
    }

    @Override
    public float getMaximumSpeed(SignalMast destination) {
        if (!this.destList.containsKey(destination)) {
            return -1.0f;
        }
        return this.destList.get(destination).getMinimumSpeed();
    }

    synchronized void setSignalAppearance() {
        log.debug("setMastAppearance (Aspect) called for {}", (Object)this.source.getDisplayName());
        if (this.inWait) {
            log.debug("setMastAppearance (Aspect) called with inWait set, returning");
            return;
        }
        this.inWait = true;
        InstanceManager.getDefault(SignalSpeedMap.class);
        int tempDelay = InstanceManager.getDefault(SignalMastLogicManager.class).getSignalLogicDelay() / 2;
        log.debug("SignalMastLogicManager started (delay)");
        ThreadingUtil.runOnLayoutDelayed(() -> {
            this.setMastAppearance();
            this.inWait = false;
        }, tempDelay);
    }

    void setMastAppearance() {
        log.debug("Set source Signal Mast Aspect");
        if (this.getSourceMast().getHeld()) {
            log.debug("Signal is at a Held state so will set to the aspect defined for Held or Danger");
            String heldAspect = this.getSourceMast().getAppearanceMap().getSpecificAppearance(0);
            if (heldAspect != null) {
                log.debug("  Setting to HELD value of {}", (Object)heldAspect);
                ThreadingUtil.runOnLayout(() -> this.getSourceMast().setAspect(heldAspect));
            } else {
                String dangerAspect = this.getSourceMast().getAppearanceMap().getSpecificAppearance(2);
                log.debug("  Setting to DANGER value of {}", (Object)dangerAspect);
                ThreadingUtil.runOnLayout(() -> this.getSourceMast().setAspect(dangerAspect));
            }
            return;
        }
        if (!this.checkStates()) {
            log.debug("Advanced routes not clear, set Stop aspect");
            this.getSourceMast().setAspect(this.stopAspect);
            return;
        }
        String[] advancedAspect = this.destination.getHeld() ? (this.destination.getAppearanceMap().getSpecificAppearance(0) != null ? this.getSourceMast().getAppearanceMap().getValidAspectsForAdvancedAspect(this.destination.getAppearanceMap().getSpecificAppearance(0)) : this.getSourceMast().getAppearanceMap().getValidAspectsForAdvancedAspect(this.destination.getAppearanceMap().getSpecificAppearance(2))) : this.getSourceMast().getAppearanceMap().getValidAspectsForAdvancedAspect(this.destination.getAspect());
        log.debug("distant aspect is {}", (Object)this.destination.getAspect());
        log.debug("advanced aspect is {}", advancedAspect != null ? advancedAspect : "<null>");
        if (advancedAspect != null) {
            String aspect = this.stopAspect;
            if (this.destList.get((Object)this.destination).permissiveBlock) {
                if (!this.getSourceMast().isPermissiveSmlDisabled()) {
                    aspect = this.getSourceMast().getAppearanceMap().getSpecificAppearance(1);
                }
            } else {
                int i = 0;
                while (i < advancedAspect.length) {
                    if (!this.getSourceMast().isAspectDisabled(advancedAspect[i])) {
                        aspect = advancedAspect[i];
                        break;
                    }
                    ++i;
                }
                ArrayList<Integer> divergAspects = new ArrayList<Integer>();
                ArrayList<Integer> nonDivergAspects = new ArrayList<Integer>();
                ArrayList<Integer> eitherAspects = new ArrayList<Integer>();
                if (advancedAspect.length > 1) {
                    float maxSigSpeed = -1.0f;
                    float maxPathSpeed = this.destList.get(this.destination).getMinimumSpeed();
                    boolean divergRoute = this.destList.get((Object)this.destination).turnoutThrown;
                    log.debug("Diverging route? {}", (Object)divergRoute);
                    boolean divergFlagsAvailable = false;
                    int i2 = 0;
                    while (i2 < advancedAspect.length) {
                        String div = null;
                        if (!this.getSourceMast().isAspectDisabled(advancedAspect[i2])) {
                            div = (String)this.getSourceMast().getSignalSystem().getProperty(advancedAspect[i2], "route");
                        }
                        if (div != null) {
                            if (div.equals("Diverging")) {
                                log.debug("Aspect {} added as Diverging Route", (Object)advancedAspect[i2]);
                                divergAspects.add(i2);
                                divergFlagsAvailable = true;
                                log.debug("Using Diverging Flag");
                            } else if (div.equals("Either")) {
                                log.debug("Aspect {} added as both Diverging and Normal Route", (Object)advancedAspect[i2]);
                                nonDivergAspects.add(i2);
                                divergAspects.add(i2);
                                divergFlagsAvailable = true;
                                eitherAspects.add(i2);
                                log.debug("Using Diverging Flag");
                            } else {
                                log.debug("Aspect {} added as Normal Route", (Object)advancedAspect[i2]);
                                nonDivergAspects.add(i2);
                                log.debug("Aspect {} added as Normal Route", (Object)advancedAspect[i2]);
                            }
                        } else {
                            nonDivergAspects.add(i2);
                            log.debug("Aspect {} added as Normal Route", (Object)advancedAspect[i2]);
                        }
                        ++i2;
                    }
                    if (eitherAspects.equals(divergAspects) && divergAspects.size() < nonDivergAspects.size()) {
                        log.debug("'Either' aspects equals divergAspects and is less than non-diverging aspects");
                        divergFlagsAvailable = false;
                    }
                    log.debug("path max speed : {}", (Object)Float.valueOf(maxPathSpeed));
                    i2 = 0;
                    while (i2 < advancedAspect.length) {
                        if (!this.getSourceMast().isAspectDisabled(advancedAspect[i2])) {
                            String strSpeed = (String)this.getSourceMast().getSignalSystem().getProperty(advancedAspect[i2], "speed");
                            if (log.isDebugEnabled()) {
                                log.debug("Aspect Speed = {} for aspect {}", (Object)strSpeed, (Object)advancedAspect[i2]);
                            }
                            log.debug(advancedAspect[i2]);
                            if (divergRoute && divergFlagsAvailable && divergAspects.contains(i2) || (divergRoute && !divergFlagsAvailable || !divergRoute) && nonDivergAspects.contains(i2)) {
                                log.debug("In list");
                                if (strSpeed != null && !strSpeed.isEmpty()) {
                                    float speed = 0.0f;
                                    try {
                                        speed = Float.parseFloat(strSpeed);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        try {
                                            speed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(strSpeed);
                                        }
                                        catch (Exception exception) {
                                            log.warn("Using speed = 0.0 because could not understand \"{}\"", (Object)strSpeed);
                                        }
                                    }
                                    if (log.isDebugEnabled()) {
                                        log.debug("{} signal state speed {} maxSigSpeed {} maxPathSpeed {}", new Object[]{this.destination.getDisplayName(), Float.valueOf(speed), Float.valueOf(maxSigSpeed), Float.valueOf(maxPathSpeed)});
                                    }
                                    if (maxPathSpeed == 0.0f) {
                                        if (maxSigSpeed == -1.0f) {
                                            log.debug("min speed on this route is equal to 0 so will set this as our max speed");
                                            maxSigSpeed = speed;
                                            aspect = advancedAspect[i2];
                                            log.debug("Aspect to set is {}", (Object)aspect);
                                        } else if (speed > maxSigSpeed) {
                                            log.debug("new speed is faster than old will use this");
                                            maxSigSpeed = speed;
                                            aspect = advancedAspect[i2];
                                            log.debug("Aspect to set is {}", (Object)aspect);
                                        }
                                    } else if (speed > maxSigSpeed && maxSigSpeed < maxPathSpeed && speed <= maxPathSpeed) {
                                        log.debug("our minimum speed on this route is less than our state speed, we will set this as our max speed");
                                        maxSigSpeed = speed;
                                        aspect = advancedAspect[i2];
                                        log.debug("Aspect to set is {}", (Object)aspect);
                                    } else if (maxSigSpeed > maxPathSpeed && speed < maxSigSpeed) {
                                        log.debug("our max signal speed is greater than our path speed on this route, our speed is less that the maxSigSpeed");
                                        maxSigSpeed = speed;
                                        aspect = advancedAspect[i2];
                                        log.debug("Aspect to set is {}", (Object)aspect);
                                    } else if (maxSigSpeed == -1.0f) {
                                        log.debug("maxSigSpeed returned as -1");
                                        maxSigSpeed = speed;
                                        aspect = advancedAspect[i2];
                                        log.debug("Aspect to set is {}", (Object)aspect);
                                    }
                                }
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug("Aspect has been disabled {}", (Object)advancedAspect[i2]);
                        }
                        ++i2;
                    }
                }
            }
            if (aspect != null && !aspect.equals("")) {
                log.debug("setMastAppearance setting aspect \"{}\"", (Object)aspect);
                String aspectSet = aspect;
                try {
                    ThreadingUtil.runOnLayout(() -> this.getSourceMast().setAspect(aspectSet));
                }
                catch (Exception ex) {
                    log.error("Exception while setting Signal Logic: {}", (Throwable)ex);
                }
                return;
            }
        }
        log.debug("Aspect returned is not valid, setting stop");
        ThreadingUtil.runOnLayout(() -> this.getSourceMast().setAspect(this.stopAspect));
    }

    @Override
    public void setConflictingLogic(SignalMast sm, LevelXing lx) {
        if (sm == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("setConflicting logic mast {}", (Object)sm.getDisplayName());
        }
        if (sm == this.source) {
            log.debug("source is us so exit");
            return;
        }
        Enumeration<SignalMast> en = this.destList.keys();
        while (en.hasMoreElements()) {
            SignalMast dm = en.nextElement();
            if (this.destList.get(dm).isBlockIncluded(lx.getLayoutBlockAC())) {
                this.destList.get(dm).addAutoSignalMast(sm);
                continue;
            }
            if (this.destList.get(dm).isBlockIncluded(lx.getLayoutBlockBD())) {
                this.destList.get(dm).addAutoSignalMast(sm);
                continue;
            }
            if (this.destList.get(dm).isAutoBlockIncluded(lx.getLayoutBlockAC())) {
                this.destList.get(dm).addAutoSignalMast(sm);
                continue;
            }
            if (this.destList.get(dm).isAutoBlockIncluded(lx.getLayoutBlockBD())) {
                this.destList.get(dm).addAutoSignalMast(sm);
                continue;
            }
            log.debug("Block not found");
        }
    }

    @Override
    public void removeConflictingLogic(SignalMast sm, LevelXing lx) {
        if (sm == this.source) {
            return;
        }
        Enumeration<SignalMast> en = this.destList.keys();
        while (en.hasMoreElements()) {
            SignalMast dm = en.nextElement();
            if (this.destList.get(dm).isBlockIncluded(lx.getLayoutBlockAC())) {
                this.destList.get(dm).removeAutoSignalMast(sm);
                continue;
            }
            if (!this.destList.get(dm).isBlockIncluded(lx.getLayoutBlockBD())) continue;
            this.destList.get(dm).removeAutoSignalMast(sm);
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        NamedBean nb = (NamedBean)evt.getOldValue();
        if ("CanDelete".equals(evt.getPropertyName())) {
            boolean found = false;
            StringBuilder message = new StringBuilder();
            if (nb instanceof SignalMast) {
                if (nb.equals(this.source)) {
                    message.append("Has SignalMast Logic attached which will be <b>Deleted</b> to <ul>");
                    for (SignalMast sm : this.getDestinationList()) {
                        message.append("<li>");
                        message.append(sm.getDisplayName());
                        message.append("</li>");
                    }
                    message.append("</ul>");
                    throw new PropertyVetoException(message.toString(), evt);
                }
                if (this.isDestinationValid((SignalMast)nb)) {
                    throw new PropertyVetoException("Is the end point mast for logic attached to signal mast " + this.source.getDisplayName() + " which will be <b>Deleted</b> ", evt);
                }
                for (SignalMast sm : this.getDestinationList()) {
                    if (!this.isSignalMastIncluded((SignalMast)nb, sm)) continue;
                    message.append("<li>");
                    message.append("Used in conflicting logic of " + this.source.getDisplayName() + " & " + sm.getDisplayName());
                    message.append("</li>");
                }
            }
            if (nb instanceof Turnout) {
                for (SignalMast sm : this.getDestinationList()) {
                    if (!this.isTurnoutIncluded((Turnout)nb, sm)) continue;
                    message.append("<li>Is in logic between Signal Masts " + this.source.getDisplayName() + " " + sm.getDisplayName() + "</li>");
                    found = true;
                }
            }
            if (nb instanceof Sensor) {
                for (SignalMast sm : this.getDestinationList()) {
                    if (!this.isSensorIncluded((Sensor)nb, sm)) continue;
                    message.append("<li>");
                    message.append("Is in logic between Signal Masts " + this.source.getDisplayName() + " " + sm.getDisplayName());
                    message.append("</li>");
                    found = true;
                }
            }
            if (found) {
                throw new PropertyVetoException(message.toString(), evt);
            }
        } else if ("DoDelete".equals(evt.getPropertyName())) {
            if (nb instanceof SignalMast) {
                if (nb.equals(this.source)) {
                    this.dispose();
                }
                if (this.isDestinationValid((SignalMast)nb)) {
                    this.removeDestination((SignalMast)nb);
                }
                for (SignalMast sm : this.getDestinationList()) {
                    if (!this.isSignalMastIncluded((SignalMast)nb, sm)) continue;
                    log.warn("Unhandled condition: signal mast included during DoDelete");
                }
            }
            if (nb instanceof Turnout) {
                Turnout t = (Turnout)nb;
                for (SignalMast sm : this.getDestinationList()) {
                    if (!this.isTurnoutIncluded(t, sm)) continue;
                    this.removeTurnout(t, sm);
                }
            }
            if (nb instanceof Sensor) {
                Sensor s = (Sensor)nb;
                for (SignalMast sm : this.getDestinationList()) {
                    if (!this.isSensorIncluded(s, sm)) continue;
                    this.removeSensor(s, sm);
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.disposing = true;
        this.getSourceMast().removePropertyChangeListener(this.propertySourceMastListener);
        Enumeration<SignalMast> en = this.destList.keys();
        while (en.hasMoreElements()) {
            SignalMast dm = en.nextElement();
            this.destList.get(dm).dispose();
        }
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameSignalMastLogic");
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public void setState(int i) {
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            if (bean.equals(this.getSourceMast())) {
                report.add(new NamedBeanUsageReport("SMLSourceMast"));
            }
            this.getDestinationList().forEach(dest -> {
                if (bean.equals(dest)) {
                    report.add(new NamedBeanUsageReport("SMLDestinationMast"));
                }
                this.getAutoBlocks((SignalMast)dest).forEach(block -> {
                    if (bean.equals(block)) {
                        report.add(new NamedBeanUsageReport("SMLBlockAuto", (NamedBean)dest));
                    }
                });
                this.getBlocks((SignalMast)dest).forEach(block -> {
                    if (bean.equals(block)) {
                        report.add(new NamedBeanUsageReport("SMLBlockUser", (NamedBean)dest));
                    }
                });
                this.getAutoTurnouts((SignalMast)dest).forEach(turnout -> {
                    if (bean.equals(turnout)) {
                        report.add(new NamedBeanUsageReport("SMLTurnoutAuto", (NamedBean)dest));
                    }
                });
                this.getTurnouts((SignalMast)dest).forEach(turnout -> {
                    if (bean.equals(turnout)) {
                        report.add(new NamedBeanUsageReport("SMLTurnoutUser", (NamedBean)dest));
                    }
                });
                this.getSensors((SignalMast)dest).forEach(sensor -> {
                    if (bean.equals(sensor)) {
                        report.add(new NamedBeanUsageReport("SMLSensor", (NamedBean)dest));
                    }
                });
                this.getAutoMasts((SignalMast)dest).forEach(mast -> {
                    if (bean.equals(mast)) {
                        report.add(new NamedBeanUsageReport("SMLMastAuto", (NamedBean)dest));
                    }
                });
                this.getSignalMasts((SignalMast)dest).forEach(mast -> {
                    if (bean.equals(mast)) {
                        report.add(new NamedBeanUsageReport("SMLMastUser", (NamedBean)dest));
                    }
                });
            });
        }
        return report;
    }

    private class DestinationMast {
        LayoutBlock destinationBlock = null;
        LayoutBlock protectingBlock = null;
        List<NamedBeanSetting> userSetTurnouts = new ArrayList<NamedBeanSetting>(0);
        Hashtable<Turnout, Integer> autoTurnouts = new Hashtable(0);
        List<NamedBeanSetting> userSetMasts = new ArrayList<NamedBeanSetting>(0);
        Hashtable<SignalMast, String> autoMasts = new Hashtable(0);
        List<NamedBeanSetting> userSetSensors = new ArrayList<NamedBeanSetting>(0);
        List<NamedBeanSetting> userSetBlocks = new ArrayList<NamedBeanSetting>(0);
        boolean turnoutThrown = false;
        boolean permissiveBlock = false;
        boolean disposed = false;
        List<LevelXing> blockInXings = new ArrayList<LevelXing>();
        LinkedHashMap<Block, Integer> autoBlocks = new LinkedHashMap(0);
        List<Block> xingAutoBlocks = new ArrayList<Block>(0);
        List<Block> dblCrossoverAutoBlocks = new ArrayList<Block>(0);
        SignalMast destination;
        boolean active = false;
        boolean destMastInit = false;
        float minimumBlockSpeed = 0.0f;
        boolean useLayoutEditor = false;
        boolean useLayoutEditorTurnouts = false;
        boolean useLayoutEditorBlocks = false;
        boolean lockTurnouts = false;
        NamedBeanHandle<Section> associatedSection = null;
        String comment;
        boolean enable = true;
        int store = 0;
        boolean inWait = false;
        boolean allowAutoSignalMastGeneration = false;
        protected PropertyChangeListener propertySensorListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Sensor sen = (Sensor)e.getSource();
                log.debug("{} to {} destination sensor {} trigger {}", new Object[]{((DestinationMast)DestinationMast.this).DefaultSignalMastLogic.this.source.getDisplayName(), DestinationMast.this.destination.getDisplayName(), sen.getDisplayName(), e.getPropertyName()});
                if (e.getPropertyName().equals("KnownState")) {
                    int now = (Integer)e.getNewValue();
                    log.debug("current value {} value we want {}", (Object)now, (Object)DestinationMast.this.getSensorState(sen));
                    if (DestinationMast.this.isSensorIncluded(sen) && DestinationMast.this.getSensorState(sen) != now) {
                        log.debug("Sensor {} caused the signalmast to be set to danger", (Object)sen.getDisplayName());
                        if (DestinationMast.this.active) {
                            DestinationMast.this.active = false;
                            DefaultSignalMastLogic.this.setSignalAppearance();
                        }
                    } else if (DestinationMast.this.getSensorState(sen) == now) {
                        log.debug("{} sensor {} triggers a calculation of change", (Object)DestinationMast.this.destination.getDisplayName(), (Object)sen.getDisplayName());
                        DestinationMast.this.checkState();
                    }
                }
            }
        };
        protected PropertyChangeListener propertyTurnoutListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Turnout turn = (Turnout)e.getSource();
                if (e.getPropertyName().equals("KnownState")) {
                    int now = (Integer)e.getNewValue();
                    if (DestinationMast.this.isTurnoutIncluded(turn)) {
                        if (DestinationMast.this.getTurnoutState(turn) != now) {
                            if (log.isDebugEnabled()) {
                                log.debug("Turnout {} caused the signalmast to be set", (Object)turn.getDisplayName());
                                log.debug("From {} to {} Turnout {} caused the signalmast to be set to danger", new Object[]{DefaultSignalMastLogic.this.getSourceMast().getDisplayName(), DestinationMast.this.destination.getDisplayName(), turn.getDisplayName()});
                            }
                            if (DestinationMast.this.active) {
                                DestinationMast.this.active = false;
                                DefaultSignalMastLogic.this.setSignalAppearance();
                            }
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug("{} turnout {} triggers a calculation of change", (Object)DestinationMast.this.destination.getDisplayName(), (Object)turn.getDisplayName());
                            }
                            DestinationMast.this.checkState();
                        }
                    } else if (DestinationMast.this.autoTurnouts.containsKey(turn)) {
                        if (DestinationMast.this.getAutoTurnoutState(turn) != now) {
                            if (log.isDebugEnabled()) {
                                log.debug("Turnout {} auto caused the signalmast to be set", (Object)turn.getDisplayName());
                                log.debug("From {} to {} Auto Turnout {} auto caused the signalmast to be set to danger", new Object[]{DefaultSignalMastLogic.this.getSourceMast().getDisplayName(), DestinationMast.this.destination.getDisplayName(), turn.getDisplayName()});
                            }
                            if (DestinationMast.this.active) {
                                DestinationMast.this.active = false;
                                DefaultSignalMastLogic.this.setSignalAppearance();
                            }
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug("From {} to {} turnout {} triggers a calculation of change", new Object[]{DefaultSignalMastLogic.this.getSourceMast().getDisplayName(), DestinationMast.this.destination.getDisplayName(), turn.getDisplayName()});
                            }
                            DestinationMast.this.checkState();
                        }
                    }
                } else if (e.getPropertyName().equals("TurnoutStraightSpeedChange") || e.getPropertyName().equals("TurnoutDivergingSpeedChange")) {
                    DestinationMast.this.calculateSpeed();
                }
            }
        };
        protected PropertyChangeListener propertyBlockListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Block block = (Block)e.getSource();
                if (log.isDebugEnabled()) {
                    log.debug("{} destination block {} trigger {} {}", new Object[]{DestinationMast.this.destination.getDisplayName(), block.getDisplayName(), e.getPropertyName(), e.getNewValue()});
                }
                if (e.getPropertyName().equals("state") || e.getPropertyName().equals("allocated")) {
                    if (log.isDebugEnabled()) {
                        log.debug("Included in user entered block {}", (Object)Boolean.toString(DestinationMast.this.isBlockIncluded(block)));
                        log.debug("Included in AutoGenerated Block {}", (Object)Boolean.toString(DestinationMast.this.autoBlocks.containsKey(block)));
                    }
                    if (DestinationMast.this.isBlockIncluded(block)) {
                        if (log.isDebugEnabled()) {
                            log.debug("{} in manual block", (Object)DestinationMast.this.destination.getDisplayName());
                            log.debug("{}  {}", (Object)DestinationMast.this.getBlockState(block), (Object)block.getState());
                        }
                        DestinationMast.this.checkState();
                    } else if (DestinationMast.this.autoBlocks.containsKey(block)) {
                        if (log.isDebugEnabled()) {
                            log.debug("{} in auto block", (Object)DestinationMast.this.destination.getDisplayName());
                            log.debug("{}  {}", (Object)DestinationMast.this.getAutoBlockState(block), (Object)block.getState());
                        }
                        DestinationMast.this.checkState();
                    } else if (log.isDebugEnabled()) {
                        log.debug("{} Not found", (Object)DestinationMast.this.destination.getDisplayName());
                    }
                } else if (e.getPropertyName().equals("BlockSpeedChange")) {
                    DestinationMast.this.calculateSpeed();
                }
            }
        };
        protected PropertyChangeListener propertySignalMastListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SignalMast mast = (SignalMast)e.getSource();
                if (log.isDebugEnabled()) {
                    log.debug("{} signalmast change {} {}", new Object[]{DestinationMast.this.destination.getDisplayName(), mast.getDisplayName(), e.getPropertyName()});
                }
                if (e.getPropertyName().equals("Aspect")) {
                    String now = (String)e.getNewValue();
                    if (log.isDebugEnabled()) {
                        log.debug("{} match property {}", (Object)DestinationMast.this.destination.getDisplayName(), (Object)now);
                    }
                    if (DestinationMast.this.isSignalMastIncluded(mast)) {
                        if (!now.equals(DestinationMast.this.getSignalMastState(mast))) {
                            if (log.isDebugEnabled()) {
                                log.debug("{} in mast list SignalMast {} caused the signalmast to be set", (Object)DestinationMast.this.destination.getDisplayName(), (Object)mast.getDisplayName());
                                log.debug("SignalMast {} caused the signalmast to be set", (Object)mast.getDisplayName());
                            }
                            if (DestinationMast.this.active) {
                                DestinationMast.this.active = false;
                                DefaultSignalMastLogic.this.setSignalAppearance();
                            }
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug("{} in mast list signalmast change", (Object)DestinationMast.this.destination.getDisplayName());
                            }
                            DestinationMast.this.checkState();
                        }
                    } else if (DestinationMast.this.autoMasts.containsKey(mast)) {
                        if (!now.equals(DestinationMast.this.getAutoSignalMastState(mast))) {
                            if (log.isDebugEnabled()) {
                                log.debug("SignalMast {} caused the signalmast to be set", (Object)mast.getDisplayName());
                                log.debug("{} in auto mast list SignalMast {} caused the signalmast to be set", (Object)DestinationMast.this.destination.getDisplayName(), (Object)mast.getDisplayName());
                            }
                            if (DestinationMast.this.active) {
                                DestinationMast.this.active = false;
                                DefaultSignalMastLogic.this.setSignalAppearance();
                            }
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug("{} in auto mast list signalmast change", (Object)DestinationMast.this.destination.getDisplayName());
                            }
                            DestinationMast.this.checkState();
                        }
                    }
                }
            }
        };

        DestinationMast(SignalMast destination) {
            this.destination = destination;
            if (destination.getAspect() == null) {
                try {
                    destination.setAspect(destination.getAppearanceMap().getSpecificAppearance(2));
                }
                catch (Exception ex) {
                    log.error("Error while creating Signal Logic {}", (Throwable)ex);
                }
            }
        }

        void updateDestinationMast(SignalMast newMast) {
            this.destination = newMast;
            if (this.destination.getAspect() == null) {
                try {
                    this.destination.setAspect(this.destination.getAppearanceMap().getSpecificAppearance(2));
                }
                catch (Exception ex) {
                    log.error("Error while creating Signal Logic {}", (Throwable)ex);
                }
            }
        }

        LayoutBlock getProtectingBlock() {
            return this.protectingBlock;
        }

        String getDisplayName() {
            return this.destination.getDisplayName();
        }

        String getComment() {
            return this.comment;
        }

        void setComment(String comment) {
            String old = this.comment;
            this.comment = comment;
            DefaultSignalMastLogic.this.firePropertyChange("Comment", old, comment);
        }

        boolean isActive() {
            if (this.disposed) {
                log.error("checkState called even though this has been disposed of");
                return false;
            }
            return this.active;
        }

        float getMinimumSpeed() {
            return this.minimumBlockSpeed;
        }

        void setEnabled() {
            this.enable = true;
            DefaultSignalMastLogic.this.firePropertyChange("Enabled", false, this.destination);
        }

        void setDisabled() {
            this.enable = false;
            DefaultSignalMastLogic.this.firePropertyChange("Enabled", true, this.destination);
        }

        boolean isEnabled() {
            return this.enable;
        }

        void setStore(int store) {
            this.store = store;
        }

        int getStoreState() {
            return this.store;
        }

        void setAssociatedSection(Section section) {
            if (!(section == null || this.useLayoutEditor && this.useLayoutEditorBlocks)) {
                log.warn("This Logic {} to {} is not using the Layout Editor or its Blocks, the associated Section will not be populated correctly", (Object)DefaultSignalMastLogic.this.source.getDisplayName(), (Object)this.destination.getDisplayName());
            }
            if (section == null) {
                this.associatedSection = null;
                return;
            }
            this.associatedSection = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(section.getDisplayName(), section);
            if (!this.autoBlocks.isEmpty()) {
                this.createSectionDetails();
            }
        }

        Section getAssociatedSection() {
            if (this.associatedSection != null) {
                return this.associatedSection.getBean();
            }
            return null;
        }

        void createSectionDetails() {
            this.getAssociatedSection().removeAllBlocksFromSection();
            for (Block key : this.getAutoBlocksBetweenMasts()) {
                this.getAssociatedSection().addBlock(key);
            }
            String dir = Path.decodeDirection(DefaultSignalMastLogic.this.getFacingBlock().getNeighbourDirection(this.getProtectingBlock()));
            EntryPoint ep = new EntryPoint(this.getProtectingBlock().getBlock(), DefaultSignalMastLogic.this.getFacingBlock().getBlock(), dir);
            ep.setTypeForward();
            this.getAssociatedSection().addToForwardList(ep);
            LayoutBlock proDestLBlock = InstanceManager.getDefault(LayoutBlockManager.class).getProtectedBlockByNamedBean(this.destination, this.destinationBlock.getMaxConnectedPanel());
            if (proDestLBlock != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Add protecting Block {}", (Object)proDestLBlock.getDisplayName());
                }
                dir = Path.decodeDirection(proDestLBlock.getNeighbourDirection(this.destinationBlock));
                ep = new EntryPoint(this.destinationBlock.getBlock(), proDestLBlock.getBlock(), dir);
                ep.setTypeReverse();
                this.getAssociatedSection().addToReverseList(ep);
            } else if (log.isDebugEnabled()) {
                log.debug(" ### Protecting Block not found ### ");
            }
        }

        boolean isTurnoutLockAllowed() {
            return this.lockTurnouts;
        }

        void allowTurnoutLock(boolean lock) {
            if (this.lockTurnouts == lock) {
                return;
            }
            if (!lock) {
                this.clearTurnoutLock();
            }
            this.lockTurnouts = lock;
        }

        void setTurnouts(Hashtable<NamedBeanHandle<Turnout>, Integer> turnouts) {
            if (this.userSetTurnouts != null) {
                for (NamedBeanSetting nbh : this.userSetTurnouts) {
                    nbh.getBean().removePropertyChangeListener(this.propertyTurnoutListener);
                }
            }
            this.destMastInit = false;
            if (turnouts == null) {
                this.userSetTurnouts = new ArrayList<NamedBeanSetting>(0);
            } else {
                this.userSetTurnouts = new ArrayList<NamedBeanSetting>();
                Enumeration<NamedBeanHandle<Turnout>> e = turnouts.keys();
                while (e.hasMoreElements()) {
                    NamedBeanHandle<Turnout> nbh = e.nextElement();
                    NamedBeanSetting nbs = new NamedBeanSetting(nbh, turnouts.get(nbh));
                    this.userSetTurnouts.add(nbs);
                }
            }
            DefaultSignalMastLogic.this.firePropertyChange("turnouts", null, this.destination);
        }

        void setAutoTurnouts(Hashtable<Turnout, Integer> turnouts) {
            log.debug("{} called setAutoTurnouts with {}", (Object)this.destination.getDisplayName(), (Object)(turnouts != null ? turnouts.size() + " turnouts in hash table" : "null hash table reference"));
            if (this.autoTurnouts != null) {
                Enumeration<Turnout> keys = this.autoTurnouts.keys();
                while (keys.hasMoreElements()) {
                    Turnout key = keys.nextElement();
                    key.removePropertyChangeListener(this.propertyTurnoutListener);
                }
            }
            this.destMastInit = false;
            this.autoTurnouts = turnouts == null ? new Hashtable(0) : turnouts;
            DefaultSignalMastLogic.this.firePropertyChange("autoturnouts", null, this.destination);
        }

        void setBlocks(Hashtable<Block, Integer> blocks) {
            log.debug("{} Set blocks called", (Object)this.destination.getDisplayName());
            if (this.userSetBlocks != null) {
                for (NamedBeanSetting nbh : this.userSetBlocks) {
                    nbh.getBean().removePropertyChangeListener(this.propertyBlockListener);
                }
            }
            this.destMastInit = false;
            this.userSetBlocks = new ArrayList<NamedBeanSetting>(0);
            if (blocks != null) {
                this.userSetBlocks = new ArrayList<NamedBeanSetting>();
                Enumeration<Block> e = blocks.keys();
                while (e.hasMoreElements()) {
                    Block blk = e.nextElement();
                    NamedBeanHandle<Block> nbh = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(blk.getDisplayName(), blk);
                    NamedBeanSetting nbs = new NamedBeanSetting(nbh, blocks.get(blk));
                    this.userSetBlocks.add(nbs);
                }
            }
            DefaultSignalMastLogic.this.firePropertyChange("blocks", null, this.destination);
        }

        public void setAutoBlocks(LinkedHashMap<Block, Integer> blocks) {
            if (log.isDebugEnabled()) {
                log.debug("{} called setAutoBlocks with {}", (Object)this.destination.getDisplayName(), (Object)(blocks != null ? blocks.size() + " blocks in hash table" : "null hash table reference"));
            }
            if (this.autoBlocks != null) {
                for (Block key : this.autoBlocks.keySet()) {
                    key.removePropertyChangeListener(this.propertyBlockListener);
                }
            }
            this.destMastInit = false;
            if (blocks == null) {
                this.autoBlocks = new LinkedHashMap(0);
            } else {
                this.autoBlocks = blocks;
                if (DefaultSignalMastLogic.this.facingBlock != null && this.autoBlocks.containsKey(DefaultSignalMastLogic.this.facingBlock.getBlock())) {
                    this.autoBlocks.remove(DefaultSignalMastLogic.this.facingBlock.getBlock());
                }
                if (this.getAssociatedSection() != null) {
                    this.createSectionDetails();
                }
            }
            DefaultSignalMastLogic.this.firePropertyChange("autoblocks", null, this.destination);
        }

        void setMasts(Hashtable<SignalMast, String> masts) {
            if (this.userSetMasts != null) {
                for (NamedBeanSetting nbh : this.userSetMasts) {
                    nbh.getBean().removePropertyChangeListener(this.propertySignalMastListener);
                }
            }
            this.destMastInit = false;
            if (masts == null) {
                this.userSetMasts = new ArrayList<NamedBeanSetting>(0);
            } else {
                this.userSetMasts = new ArrayList<NamedBeanSetting>();
                Enumeration<SignalMast> e = masts.keys();
                while (e.hasMoreElements()) {
                    SignalMast mast = e.nextElement();
                    NamedBeanHandle<SignalMast> nbh = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(mast.getDisplayName(), mast);
                    NamedBeanSetting nbs = new NamedBeanSetting(nbh, masts.get(mast));
                    this.userSetMasts.add(nbs);
                }
            }
            DefaultSignalMastLogic.this.firePropertyChange("masts", null, this.destination);
        }

        void setAutoMasts(Hashtable<SignalMast, String> newAutoMasts, boolean overwrite) {
            SignalMast key;
            Enumeration<SignalMast> keys;
            if (log.isDebugEnabled()) {
                log.debug("{} setAutoMast Called", (Object)this.destination.getDisplayName());
            }
            if (this.autoMasts != null) {
                keys = this.autoMasts.keys();
                while (keys.hasMoreElements()) {
                    key = keys.nextElement();
                    key.removePropertyChangeListener(this.propertySignalMastListener);
                }
            }
            this.destMastInit = false;
            if (overwrite) {
                this.autoMasts = newAutoMasts == null ? new Hashtable(0) : newAutoMasts;
            } else if (newAutoMasts == null) {
                this.autoMasts = new Hashtable(0);
            } else {
                keys = newAutoMasts.keys();
                while (keys.hasMoreElements()) {
                    key = keys.nextElement();
                    this.autoMasts.put(key, newAutoMasts.get(key));
                }
            }
            int i = 0;
            while (i < this.blockInXings.size()) {
                this.blockInXings.get(i).addSignalMastLogic(DefaultSignalMastLogic.this.source);
                ++i;
            }
            DefaultSignalMastLogic.this.firePropertyChange("automasts", null, this.destination);
        }

        void setSensors(Hashtable<NamedBeanHandle<Sensor>, Integer> sensors) {
            if (this.userSetSensors != null) {
                for (NamedBeanSetting nbh : this.userSetSensors) {
                    nbh.getBean().removePropertyChangeListener(this.propertySensorListener);
                }
            }
            this.destMastInit = false;
            if (sensors == null) {
                this.userSetSensors = new ArrayList<NamedBeanSetting>(0);
            } else {
                this.userSetSensors = new ArrayList<NamedBeanSetting>();
                Enumeration<NamedBeanHandle<Sensor>> e = sensors.keys();
                while (e.hasMoreElements()) {
                    NamedBeanHandle<Sensor> nbh = e.nextElement();
                    NamedBeanSetting nbs = new NamedBeanSetting(nbh, sensors.get(nbh));
                    this.userSetSensors.add(nbs);
                }
            }
            DefaultSignalMastLogic.this.firePropertyChange("sensors", null, this.destination);
        }

        void addSensor(NamedBeanHandle<Sensor> sen, int state) {
            for (NamedBeanSetting nbh : this.userSetSensors) {
                if (!nbh.getBean().equals(sen.getBean())) continue;
                return;
            }
            sen.getBean().addPropertyChangeListener(this.propertySensorListener);
            NamedBeanSetting nbs = new NamedBeanSetting(sen, state);
            this.userSetSensors.add(nbs);
            DefaultSignalMastLogic.this.firePropertyChange("sensors", null, this.destination);
        }

        void removeSensor(NamedBeanHandle<Sensor> sen) {
            for (NamedBeanSetting nbh : this.userSetSensors) {
                if (!nbh.getBean().equals(sen.getBean())) continue;
                sen.getBean().removePropertyChangeListener(this.propertySensorListener);
                this.userSetSensors.remove(nbh);
                DefaultSignalMastLogic.this.firePropertyChange("sensors", null, this.destination);
                return;
            }
        }

        void removeSensor(Sensor sen) {
            for (NamedBeanSetting nbh : this.userSetSensors) {
                if (!nbh.getBean().equals(sen)) continue;
                sen.removePropertyChangeListener(this.propertySensorListener);
                this.userSetSensors.remove(nbh);
                DefaultSignalMastLogic.this.firePropertyChange("sensors", null, this.destination);
                return;
            }
        }

        List<Block> getBlocks() {
            ArrayList<Block> out = new ArrayList<Block>();
            for (NamedBeanSetting nbh : this.userSetBlocks) {
                out.add((Block)nbh.getBean());
            }
            return out;
        }

        List<Block> getAutoBlocks() {
            ArrayList<Block> out = new ArrayList<Block>();
            Set<Block> blockKeys = this.autoBlocks.keySet();
            for (Block key : blockKeys) {
                out.add(key);
            }
            return out;
        }

        List<Block> getAutoBlocksBetweenMasts() {
            if (DefaultSignalMastLogic.this.destList.get((Object)this.destination).xingAutoBlocks.size() == 0 && DefaultSignalMastLogic.this.destList.get((Object)this.destination).dblCrossoverAutoBlocks.size() == 0) {
                return this.getAutoBlocks();
            }
            List<Block> returnList = this.getAutoBlocks();
            for (Block blk : this.getAutoBlocks()) {
                if (!this.xingAutoBlocks.contains(blk)) continue;
                returnList.remove(blk);
            }
            for (Block blk : this.getAutoBlocks()) {
                if (!this.dblCrossoverAutoBlocks.contains(blk)) continue;
                returnList.remove(blk);
            }
            return returnList;
        }

        List<Turnout> getTurnouts() {
            ArrayList<Turnout> out = new ArrayList<Turnout>();
            for (NamedBeanSetting nbh : this.userSetTurnouts) {
                out.add((Turnout)nbh.getBean());
            }
            return out;
        }

        void removeTurnout(Turnout turn) {
            Iterator<NamedBeanSetting> nbh = this.userSetTurnouts.iterator();
            while (nbh.hasNext()) {
                NamedBeanSetting i = nbh.next();
                if (!i.getBean().equals(turn)) continue;
                turn.removePropertyChangeListener(this.propertyTurnoutListener);
                nbh.remove();
                DefaultSignalMastLogic.this.firePropertyChange("turnouts", null, this.destination);
            }
        }

        List<NamedBeanHandle<Turnout>> getNamedTurnouts() {
            ArrayList<NamedBeanHandle<Turnout>> out = new ArrayList<NamedBeanHandle<Turnout>>();
            for (NamedBeanSetting nbh : this.userSetTurnouts) {
                out.add(nbh.getNamedBean());
            }
            return out;
        }

        List<Turnout> getAutoTurnouts() {
            ArrayList<Turnout> out = new ArrayList<Turnout>();
            Enumeration<Turnout> en = this.autoTurnouts.keys();
            while (en.hasMoreElements()) {
                out.add(en.nextElement());
            }
            return out;
        }

        List<SignalMast> getSignalMasts() {
            ArrayList<SignalMast> out = new ArrayList<SignalMast>();
            for (NamedBeanSetting nbh : this.userSetMasts) {
                out.add((SignalMast)nbh.getBean());
            }
            return out;
        }

        List<SignalMast> getAutoSignalMasts() {
            ArrayList<SignalMast> out = new ArrayList<SignalMast>();
            Enumeration<SignalMast> en = this.autoMasts.keys();
            while (en.hasMoreElements()) {
                out.add(en.nextElement());
            }
            return out;
        }

        List<Sensor> getSensors() {
            ArrayList<Sensor> out = new ArrayList<Sensor>();
            for (NamedBeanSetting nbh : this.userSetSensors) {
                out.add((Sensor)nbh.getBean());
            }
            return out;
        }

        List<NamedBeanHandle<Sensor>> getNamedSensors() {
            ArrayList<NamedBeanHandle<Sensor>> out = new ArrayList<NamedBeanHandle<Sensor>>();
            for (NamedBeanSetting nbh : this.userSetSensors) {
                out.add(nbh.getNamedBean());
            }
            return out;
        }

        boolean isBlockIncluded(Block block) {
            for (NamedBeanSetting nbh : this.userSetBlocks) {
                if (!nbh.getBean().equals(block)) continue;
                return true;
            }
            return false;
        }

        boolean isAutoBlockIncluded(LayoutBlock block) {
            if (block != null) {
                return this.autoBlocks.containsKey(block.getBlock());
            }
            return false;
        }

        boolean isAutoBlockIncluded(Block block) {
            return this.autoBlocks.containsKey(block);
        }

        boolean isBlockIncluded(LayoutBlock block) {
            for (NamedBeanSetting nbh : this.userSetBlocks) {
                if (!nbh.getBean().equals(block.getBlock())) continue;
                return true;
            }
            return false;
        }

        boolean isTurnoutIncluded(Turnout turnout) {
            for (NamedBeanSetting nbh : this.userSetTurnouts) {
                if (!nbh.getBean().equals(turnout)) continue;
                return true;
            }
            return false;
        }

        boolean isSensorIncluded(Sensor sensor) {
            for (NamedBeanSetting nbh : this.userSetSensors) {
                if (!nbh.getBean().equals(sensor)) continue;
                return true;
            }
            return false;
        }

        boolean isSignalMastIncluded(SignalMast signal) {
            for (NamedBeanSetting nbh : this.userSetMasts) {
                if (!nbh.getBean().equals(signal)) continue;
                return true;
            }
            return false;
        }

        int getAutoBlockState(Block block) {
            if (this.autoBlocks == null) {
                return -1;
            }
            return this.autoBlocks.get(block);
        }

        int getBlockState(Block block) {
            if (this.userSetBlocks == null) {
                return -1;
            }
            for (NamedBeanSetting nbh : this.userSetBlocks) {
                if (!nbh.getBean().equals(block)) continue;
                return nbh.getSetting();
            }
            return -1;
        }

        int getSensorState(Sensor sensor) {
            if (this.userSetSensors == null) {
                return -1;
            }
            for (NamedBeanSetting nbh : this.userSetSensors) {
                if (!nbh.getBean().equals(sensor)) continue;
                return nbh.getSetting();
            }
            return -1;
        }

        int getTurnoutState(Turnout turnout) {
            if (this.userSetTurnouts == null) {
                return -1;
            }
            for (NamedBeanSetting nbh : this.userSetTurnouts) {
                if (!nbh.getBean().equals(turnout)) continue;
                return nbh.getSetting();
            }
            return -1;
        }

        int getAutoTurnoutState(Turnout turnout) {
            if (this.autoTurnouts == null) {
                return -1;
            }
            if (this.autoTurnouts.containsKey(turnout)) {
                return this.autoTurnouts.get(turnout);
            }
            return -1;
        }

        String getSignalMastState(SignalMast mast) {
            if (this.userSetMasts == null) {
                return null;
            }
            for (NamedBeanSetting nbh : this.userSetMasts) {
                if (!nbh.getBean().equals(mast)) continue;
                return nbh.getStringSetting();
            }
            return null;
        }

        String getAutoSignalMastState(SignalMast mast) {
            if (this.autoMasts == null) {
                return null;
            }
            return this.autoMasts.get(mast);
        }

        void checkState() {
            if (this.disposed) {
                log.error("checkState called even though this has been disposed of {}", (Object)DefaultSignalMastLogic.this.getSourceMast().getDisplayName());
                return;
            }
            if (!this.enable) {
                return;
            }
            if (this.inWait) {
                return;
            }
            log.debug("check Signal Dest State called");
            this.inWait = true;
            int tempDelay = InstanceManager.getDefault(SignalMastLogicManager.class).getSignalLogicDelay();
            ThreadingUtil.runOnLayoutDelayed(() -> {
                this.checkStateDetails();
                this.inWait = false;
            }, tempDelay);
        }

        private void checkStateDetails() {
            NamedBean key;
            this.turnoutThrown = false;
            this.permissiveBlock = false;
            if (this.disposed) {
                log.error("checkStateDetails called even though this has been disposed of {} {}", (Object)DefaultSignalMastLogic.this.getSourceMast().getDisplayName(), (Object)this.destination.getDisplayName());
                return;
            }
            if (!this.enable) {
                return;
            }
            log.debug("From {} to {} internal check state", (Object)DefaultSignalMastLogic.this.getSourceMast().getDisplayName(), (Object)this.destination.getDisplayName());
            this.active = false;
            if (this.useLayoutEditor && this.autoTurnouts.size() == 0 && this.autoBlocks.size() == 0) {
                return;
            }
            boolean state = true;
            Enumeration<Turnout> keys = this.autoTurnouts.keys();
            while (keys.hasMoreElements()) {
                Turnout key2 = keys.nextElement();
                if (key2.getKnownState() != this.autoTurnouts.get(key2).intValue()) {
                    if (key2.getState() == this.autoTurnouts.get(key2).intValue()) continue;
                    if (this.isTurnoutIncluded(key2)) {
                        if (key2.getState() != this.getTurnoutState(key2)) {
                            state = false;
                            continue;
                        }
                        if (key2.getState() != 4) continue;
                        this.turnoutThrown = true;
                        continue;
                    }
                    state = false;
                    continue;
                }
                if (key2.getState() != 4) continue;
                this.turnoutThrown = true;
            }
            for (NamedBeanSetting nbh : this.userSetTurnouts) {
                Turnout turnout = (Turnout)nbh.getBean();
                if (turnout.getKnownState() != nbh.getSetting()) {
                    state = false;
                    continue;
                }
                if (turnout.getState() != 4) continue;
                this.turnoutThrown = true;
            }
            Enumeration<SignalMast> mastKeys = this.autoMasts.keys();
            while (mastKeys.hasMoreElements()) {
                SignalMast signalMast = mastKeys.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug("{} {} {}", new Object[]{signalMast.getDisplayName(), signalMast.getAspect(), this.autoMasts.get(signalMast)});
                }
                if (signalMast.getAspect() == null || signalMast.getAspect().equals(this.autoMasts.get(signalMast))) continue;
                if (this.isSignalMastIncluded(signalMast)) {
                    if (this.getSignalMastState(signalMast).equals("") || signalMast.getAspect().equals(this.getSignalMastState(signalMast))) continue;
                    state = false;
                    continue;
                }
                state = false;
            }
            for (NamedBeanSetting namedBeanSetting : this.userSetMasts) {
                key = (SignalMast)namedBeanSetting.getBean();
                if (key.getAspect() != null && key.getAspect().equals(namedBeanSetting.getStringSetting())) continue;
                state = false;
            }
            for (NamedBeanSetting namedBeanSetting : this.userSetSensors) {
                key = (Sensor)namedBeanSetting.getBean();
                if (key.getKnownState() == namedBeanSetting.getSetting()) continue;
                state = false;
            }
            for (Map.Entry<Block, Integer> entry : this.autoBlocks.entrySet()) {
                if (log.isDebugEnabled()) {
                    log.debug("{} {} {}", new Object[]{entry.getKey().getDisplayName(), entry.getKey().getState(), entry.getValue()});
                }
                if (entry.getKey().getState() == this.autoBlocks.get(entry.getKey()).intValue()) continue;
                if (this.isBlockIncluded(entry.getKey())) {
                    if (this.getBlockState(entry.getKey()) == 3 || entry.getKey().getState() == this.getBlockState(entry.getKey())) continue;
                    if (entry.getKey().getState() == 2 && entry.getKey().getPermissiveWorking()) {
                        this.permissiveBlock = true;
                        continue;
                    }
                    state = false;
                    continue;
                }
                if (entry.getKey().getState() == 2 && entry.getKey().getPermissiveWorking()) {
                    this.permissiveBlock = true;
                    continue;
                }
                if (entry.getKey().getState() == 256) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Block {} is UNDETECTED so treat as unoccupied", (Object)entry.getKey().getDisplayName());
                    continue;
                }
                state = false;
            }
            for (NamedBeanSetting namedBeanSetting : this.userSetBlocks) {
                key = (Block)namedBeanSetting.getBean();
                if (namedBeanSetting.getSetting() == 3 || ((Block)key).getState() == namedBeanSetting.getSetting()) continue;
                if (((Block)key).getState() == 2 && ((Block)key).getPermissiveWorking()) {
                    this.permissiveBlock = true;
                    continue;
                }
                state = false;
            }
            if (this.permissiveBlock && DefaultSignalMastLogic.this.getSourceMast().getAppearanceMap().getSpecificAppearance(1) == null) {
                state = false;
            }
            if (state && this.getAssociatedSection() != null && InstanceManager.getNullableDefault(DispatcherFrame.class) != null && InstanceManager.getNullableDefault(LayoutBlockManager.class) != null && this.getAssociatedSection().getState() != 4) {
                LayoutBlockManager layoutBlockManager = InstanceManager.getDefault(LayoutBlockManager.class);
                for (Block block : this.autoBlocks.keySet()) {
                    LayoutBlock lb = layoutBlockManager.getLayoutBlock(block);
                    if (lb == null || !lb.getUseExtraColor()) continue;
                    state = false;
                    break;
                }
                if (!state) {
                    for (NamedBeanSetting namedBeanSetting : this.userSetBlocks) {
                        Block key5 = (Block)namedBeanSetting.getBean();
                        LayoutBlock lb = layoutBlockManager.getLayoutBlock(key5);
                        if (lb == null || !lb.getUseExtraColor()) continue;
                        state = false;
                        break;
                    }
                }
            }
            if (!state) {
                this.turnoutThrown = false;
                this.permissiveBlock = false;
            }
            this.active = state;
            ThreadingUtil.runOnLayout(() -> DefaultSignalMastLogic.this.setSignalAppearance());
        }

        void initialise() {
            NamedBean key;
            if (this.destMastInit || this.disposed) {
                return;
            }
            this.active = false;
            this.turnoutThrown = false;
            this.permissiveBlock = false;
            boolean routeclear = true;
            if (this.useLayoutEditor && this.autoTurnouts.size() == 0 && this.autoBlocks.size() == 0 && this.autoMasts.size() == 0) {
                return;
            }
            this.calculateSpeed();
            Enumeration<Turnout> keys = this.autoTurnouts.keys();
            while (keys.hasMoreElements()) {
                Turnout key2 = keys.nextElement();
                key2.addPropertyChangeListener(this.propertyTurnoutListener);
                if (key2.getKnownState() != this.autoTurnouts.get(key2).intValue()) {
                    if (key2.getState() == this.autoTurnouts.get(key2).intValue()) continue;
                    if (this.isTurnoutIncluded(key2)) {
                        if (key2.getState() != this.getTurnoutState(key2)) {
                            routeclear = false;
                            continue;
                        }
                        if (key2.getState() != 4) continue;
                        this.turnoutThrown = true;
                        continue;
                    }
                    routeclear = false;
                    continue;
                }
                if (key2.getState() != 4) continue;
                this.turnoutThrown = true;
            }
            for (NamedBeanSetting nbh : this.userSetTurnouts) {
                Turnout key3 = (Turnout)nbh.getBean();
                key3.addPropertyChangeListener(this.propertyTurnoutListener, nbh.getBeanName(), "Signal Mast Logic:" + DefaultSignalMastLogic.this.source.getDisplayName() + " to " + this.destination.getDisplayName());
                if (key3.getKnownState() != nbh.getSetting()) {
                    routeclear = false;
                    continue;
                }
                if (key3.getState() != 4) continue;
                this.turnoutThrown = true;
            }
            Enumeration<SignalMast> mastKeys = this.autoMasts.keys();
            while (mastKeys.hasMoreElements()) {
                SignalMast signalMast = mastKeys.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug("{} auto mast add list {}", (Object)this.destination.getDisplayName(), (Object)signalMast.getDisplayName());
                }
                signalMast.addPropertyChangeListener(this.propertySignalMastListener);
                if (signalMast.getAspect().equals(this.autoMasts.get(signalMast))) continue;
                if (this.isSignalMastIncluded(signalMast)) {
                    if (!signalMast.getAspect().equals(this.getSignalMastState(signalMast))) continue;
                    routeclear = false;
                    continue;
                }
                routeclear = false;
            }
            for (NamedBeanSetting namedBeanSetting : this.userSetMasts) {
                key = (SignalMast)namedBeanSetting.getBean();
                key.addPropertyChangeListener(this.propertySignalMastListener);
                if (log.isDebugEnabled()) {
                    log.debug("mast '{}' key aspect '{}'", (Object)this.destination.getDisplayName(), (Object)key.getAspect());
                }
                if (key.getAspect() != null && key.getAspect().equals(namedBeanSetting.getStringSetting())) continue;
                routeclear = false;
            }
            for (NamedBeanSetting namedBeanSetting : this.userSetSensors) {
                Sensor sensor = (Sensor)namedBeanSetting.getBean();
                sensor.addPropertyChangeListener(this.propertySensorListener, namedBeanSetting.getBeanName(), "Signal Mast Logic:" + DefaultSignalMastLogic.this.source.getDisplayName() + " to " + this.destination.getDisplayName());
                if (sensor.getKnownState() == namedBeanSetting.getSetting()) continue;
                routeclear = false;
            }
            for (Map.Entry entry : this.autoBlocks.entrySet()) {
                log.debug("{} auto block add list {}", (Object)this.destination.getDisplayName(), (Object)((Block)entry.getKey()).getDisplayName());
                ((Block)entry.getKey()).addPropertyChangeListener(this.propertyBlockListener);
                if (((Block)entry.getKey()).getState() == ((Integer)entry.getValue()).intValue()) continue;
                if (this.isBlockIncluded((Block)entry.getKey())) {
                    if (((Block)entry.getKey()).getState() == this.getBlockState((Block)entry.getKey())) continue;
                    if (((Block)entry.getKey()).getState() == 2 && ((Block)entry.getKey()).getPermissiveWorking()) {
                        this.permissiveBlock = true;
                        continue;
                    }
                    routeclear = false;
                    continue;
                }
                if (((Block)entry.getKey()).getState() == 2 && ((Block)entry.getKey()).getPermissiveWorking()) {
                    this.permissiveBlock = true;
                    continue;
                }
                if (((Block)entry.getKey()).getState() == 256) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Block {} is UNDETECTED so treat as unoccupied", (Object)((Block)entry.getKey()).getDisplayName());
                    continue;
                }
                routeclear = false;
            }
            for (NamedBeanSetting namedBeanSetting : this.userSetBlocks) {
                key = (Block)namedBeanSetting.getBean();
                ((AbstractNamedBean)key).addPropertyChangeListener(this.propertyBlockListener);
                if (((Block)key).getState() == this.getBlockState((Block)key)) continue;
                if (((Block)key).getState() == 2 && ((Block)key).getPermissiveWorking()) {
                    this.permissiveBlock = true;
                    continue;
                }
                routeclear = false;
            }
            if (this.permissiveBlock && DefaultSignalMastLogic.this.getSourceMast().getAppearanceMap().getSpecificAppearance(1) == null) {
                routeclear = false;
            }
            if (routeclear) {
                this.active = true;
                DefaultSignalMastLogic.this.setSignalAppearance();
            } else {
                this.permissiveBlock = false;
                this.turnoutThrown = false;
            }
            this.destMastInit = true;
        }

        void useLayoutEditor(boolean boo) throws JmriException {
            if (log.isDebugEnabled()) {
                log.debug("{} called useLayoutEditor({}), is {}", new Object[]{this.destination.getDisplayName(), boo, this.useLayoutEditor});
            }
            if (this.useLayoutEditor == boo) {
                return;
            }
            this.useLayoutEditor = boo;
            if (boo && InstanceManager.getDefault(LayoutBlockManager.class).routingStablised()) {
                this.setupLayoutEditorDetails();
            } else {
                this.destinationBlock = null;
                DefaultSignalMastLogic.this.facingBlock = null;
                this.protectingBlock = null;
                this.setAutoBlocks(null);
                this.setAutoTurnouts(null);
            }
        }

        void useLayoutEditorDetails(boolean turnouts, boolean blocks) throws JmriException {
            if (log.isDebugEnabled()) {
                log.debug("{} use layout editor details called {}", (Object)this.destination.getDisplayName(), (Object)this.useLayoutEditor);
            }
            this.useLayoutEditorTurnouts = turnouts;
            this.useLayoutEditorBlocks = blocks;
            if (this.useLayoutEditor && InstanceManager.getDefault(LayoutBlockManager.class).routingStablised()) {
                this.setupLayoutEditorDetails();
            }
        }

        void setupLayoutEditorDetails() throws JmriException {
            log.debug("setupLayoutEditorDetails: useLayoutEditor={} disposed={}", (Object)this.useLayoutEditor, (Object)this.disposed);
            if (!this.useLayoutEditor || this.disposed) {
                return;
            }
            LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
            if (this.destinationBlock != null && log.isDebugEnabled()) {
                log.debug("{} Set use layout editor", (Object)this.destination.getDisplayName());
            }
            SortedSet<LayoutEditor> layout = InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class);
            List<Object> protectingBlocks = new ArrayList();
            DefaultSignalMastLogic.this.remoteProtectingBlock = null;
            int i = 0;
            while (i < layout.size()) {
                if (log.isDebugEnabled()) {
                    log.debug("{} Layout name {}", (Object)this.destination.getDisplayName(), (Object)DefaultSignalMastLogic.this.editor.getLayoutName());
                }
                if (DefaultSignalMastLogic.this.facingBlock == null) {
                    DefaultSignalMastLogic.this.facingBlock = lbm.getFacingBlockByNamedBean(DefaultSignalMastLogic.this.getSourceMast(), DefaultSignalMastLogic.this.editor);
                }
                if (this.protectingBlock == null && protectingBlocks.isEmpty()) {
                    protectingBlocks = lbm.getProtectingBlocksByNamedBean(DefaultSignalMastLogic.this.getSourceMast(), DefaultSignalMastLogic.this.editor);
                }
                if (this.destinationBlock == null) {
                    this.destinationBlock = lbm.getFacingBlockByNamedBean(this.destination, DefaultSignalMastLogic.this.editor);
                }
                if (DefaultSignalMastLogic.this.remoteProtectingBlock == null) {
                    DefaultSignalMastLogic.this.remoteProtectingBlock = lbm.getProtectedBlockByNamedBean(this.destination, DefaultSignalMastLogic.this.editor);
                }
                ++i;
            }
            if (!this.useLayoutEditorTurnouts && !this.useLayoutEditorBlocks) {
                return;
            }
            if (DefaultSignalMastLogic.this.facingBlock == null) {
                log.error("No facing block found for source mast {}", (Object)DefaultSignalMastLogic.this.getSourceMast().getDisplayName());
                throw new JmriException("No facing block found for source mast " + DefaultSignalMastLogic.this.getSourceMast().getDisplayName());
            }
            if (this.destinationBlock == null) {
                log.error("No facing block found for destination mast {}", (Object)this.destination.getDisplayName());
                throw new JmriException("No facing block found for destination mast " + this.destination.getDisplayName());
            }
            List<Object> lblks = new ArrayList();
            if (this.protectingBlock == null) {
                log.debug("protecting block is null");
                String pBlkNames = "";
                StringBuffer lBlksNamesBuf = new StringBuffer();
                for (LayoutBlock layoutBlock : protectingBlocks) {
                    log.debug("checking layoutBlock {}", (Object)layoutBlock.getDisplayName());
                    pBlkNames = String.valueOf(pBlkNames) + layoutBlock.getDisplayName() + " (" + lbm.getLayoutBlockConnectivityTools().checkValidDest(DefaultSignalMastLogic.this.facingBlock, layoutBlock, this.destinationBlock, DefaultSignalMastLogic.this.remoteProtectingBlock, LayoutBlockConnectivityTools.Routing.MASTTOMAST) + "), ";
                    if (!lbm.getLayoutBlockConnectivityTools().checkValidDest(DefaultSignalMastLogic.this.facingBlock, layoutBlock, this.destinationBlock, DefaultSignalMastLogic.this.remoteProtectingBlock, LayoutBlockConnectivityTools.Routing.MASTTOMAST)) continue;
                    try {
                        lblks = lbm.getLayoutBlockConnectivityTools().getLayoutBlocks(DefaultSignalMastLogic.this.facingBlock, this.destinationBlock, layoutBlock, true, LayoutBlockConnectivityTools.Routing.MASTTOMAST);
                        this.protectingBlock = layoutBlock;
                        log.debug("building path names...");
                        for (LayoutBlock layoutBlock2 : lblks) {
                            lBlksNamesBuf.append(" ");
                            lBlksNamesBuf.append(layoutBlock2.getDisplayName());
                        }
                        break;
                    }
                    catch (JmriException jmriException) {
                        log.debug("path not found this time");
                    }
                }
                String string = new String(lBlksNamesBuf);
                if (this.protectingBlock == null) {
                    throw new JmriException("Path not valid, protecting block is null. Protecting block: " + pBlkNames + " not connected to " + DefaultSignalMastLogic.this.facingBlock.getDisplayName() + ". Layout block names: " + string);
                }
            }
            if (!lbm.getLayoutBlockConnectivityTools().checkValidDest(DefaultSignalMastLogic.this.facingBlock, this.protectingBlock, this.destinationBlock, DefaultSignalMastLogic.this.remoteProtectingBlock, LayoutBlockConnectivityTools.Routing.MASTTOMAST)) {
                throw new JmriException("Path not valid, destination check failed.");
            }
            if (log.isDebugEnabled()) {
                log.debug("{} face {}", (Object)this.destination.getDisplayName(), (Object)DefaultSignalMastLogic.this.facingBlock);
                log.debug("{} prot {}", (Object)this.destination.getDisplayName(), (Object)this.protectingBlock);
                log.debug("{} dest {}", (Object)this.destination.getDisplayName(), (Object)this.destinationBlock);
            }
            if (this.destinationBlock != null && this.protectingBlock != null && DefaultSignalMastLogic.this.facingBlock != null) {
                this.setAutoMasts(null, true);
                if (log.isDebugEnabled()) {
                    log.debug("{} face {}", (Object)this.destination.getDisplayName(), (Object)DefaultSignalMastLogic.this.facingBlock.getDisplayName());
                    log.debug("{} prot {}", (Object)this.destination.getDisplayName(), (Object)this.protectingBlock.getDisplayName());
                    log.debug("{} dest {}", (Object)this.destination.getDisplayName(), (Object)this.destinationBlock.getDisplayName());
                }
                try {
                    lblks = lbm.getLayoutBlockConnectivityTools().getLayoutBlocks(DefaultSignalMastLogic.this.facingBlock, this.destinationBlock, this.protectingBlock, true, LayoutBlockConnectivityTools.Routing.MASTTOMAST);
                }
                catch (JmriException jmriException) {
                    log.error("No blocks found by the layout editor for pair {}-{}", (Object)DefaultSignalMastLogic.this.source.getDisplayName(), (Object)this.destination.getDisplayName());
                }
                LinkedHashMap<Block, Integer> block = this.setupLayoutEditorTurnoutDetails(lblks);
                int i2 = 0;
                while (i2 < this.blockInXings.size()) {
                    this.blockInXings.get(i2).removeSignalMastLogic(DefaultSignalMastLogic.this.source);
                    ++i2;
                }
                this.blockInXings = new ArrayList<LevelXing>(0);
                this.xingAutoBlocks = new ArrayList<Block>(0);
                for (LayoutEditor lay : layout) {
                    for (LevelXing levelXing : lay.getLevelXings()) {
                        if (levelXing.getLayoutBlockAC() == null || levelXing.getLayoutBlockBD() == null || levelXing.getLayoutBlockAC() == levelXing.getLayoutBlockBD()) continue;
                        if (lblks.contains(levelXing.getLayoutBlockAC()) && levelXing.getLayoutBlockAC() != DefaultSignalMastLogic.this.facingBlock) {
                            block.put(levelXing.getLayoutBlockBD().getBlock(), 4);
                            this.xingAutoBlocks.add(levelXing.getLayoutBlockBD().getBlock());
                            this.blockInXings.add(levelXing);
                            continue;
                        }
                        if (!lblks.contains(levelXing.getLayoutBlockBD()) || levelXing.getLayoutBlockBD() == DefaultSignalMastLogic.this.facingBlock) continue;
                        block.put(levelXing.getLayoutBlockAC().getBlock(), 4);
                        this.xingAutoBlocks.add(levelXing.getLayoutBlockAC().getBlock());
                        this.blockInXings.add(levelXing);
                    }
                }
                if (this.useLayoutEditorBlocks) {
                    this.setAutoBlocks(block);
                } else {
                    this.setAutoBlocks(null);
                }
                if (!this.useLayoutEditorTurnouts) {
                    this.setAutoTurnouts(null);
                }
                this.setupAutoSignalMast(null, false);
            }
            this.initialise();
        }

        LinkedHashMap<Block, Integer> setupLayoutEditorTurnoutDetails(List<LayoutBlock> lblks) {
            Hashtable<Turnout, Integer> turnoutSettings = new Hashtable<Turnout, Integer>();
            LinkedHashMap<Block, Integer> block = new LinkedHashMap<Block, Integer>();
            int i = 0;
            while (i < lblks.size()) {
                if (log.isDebugEnabled()) {
                    log.debug(lblks.get(i).getDisplayName());
                }
                block.put(lblks.get(i).getBlock(), 4);
                if (i > 0) {
                    int nxtBlk = i + 1;
                    int preBlk = i - 1;
                    if (i == lblks.size() - 1) {
                        nxtBlk = i;
                    }
                    ConnectivityUtil connection = new ConnectivityUtil(lblks.get(i).getMaxConnectedPanel());
                    List<LayoutTrackExpectedState<LayoutTurnout>> turnoutList = i == lblks.size() - 1 && DefaultSignalMastLogic.this.remoteProtectingBlock != null ? connection.getTurnoutList(lblks.get(i).getBlock(), lblks.get(preBlk).getBlock(), DefaultSignalMastLogic.this.remoteProtectingBlock.getBlock()) : connection.getTurnoutList(lblks.get(i).getBlock(), lblks.get(preBlk).getBlock(), lblks.get(nxtBlk).getBlock());
                    int x = 0;
                    while (x < turnoutList.size()) {
                        LayoutTurnout lt = (LayoutTurnout)turnoutList.get(x).getObject();
                        if (lt instanceof LayoutSlip) {
                            LayoutSlip ls = (LayoutSlip)lt;
                            int slipState = turnoutList.get(x).getExpectedState();
                            int taState = ls.getTurnoutState(slipState);
                            Turnout tTemp = ls.getTurnout();
                            if (tTemp == null) {
                                log.error("Unexpected null Turnout in {}, skipped", (Object)ls);
                            } else {
                                turnoutSettings.put(ls.getTurnout(), taState);
                                int tbState = ls.getTurnoutBState(slipState);
                                turnoutSettings.put(ls.getTurnoutB(), tbState);
                            }
                        } else {
                            Turnout tempT;
                            String t = lt.getTurnoutName();
                            Turnout turnout = InstanceManager.turnoutManagerInstance().getTurnout(t);
                            if (log.isDebugEnabled() && (lt.getTurnoutType() == LayoutTurnout.TurnoutType.RH_TURNOUT || lt.getTurnoutType() == LayoutTurnout.TurnoutType.LH_TURNOUT || lt.getTurnoutType() == LayoutTurnout.TurnoutType.WYE_TURNOUT) && !lt.getBlockName().equals("")) {
                                log.debug("turnout in list is straight left/right wye");
                                log.debug("turnout block Name {}", (Object)lt.getBlockName());
                                log.debug("current {} - pre {}", (Object)lblks.get(i).getBlock().getDisplayName(), (Object)lblks.get(preBlk).getBlock().getDisplayName());
                                log.debug("A {}", (Object)lt.getConnectA());
                                log.debug("B {}", (Object)lt.getConnectB());
                                log.debug("C {}", (Object)lt.getConnectC());
                                log.debug("D {}", (Object)lt.getConnectD());
                            }
                            if (turnout != null) {
                                turnoutSettings.put(turnout, turnoutList.get(x).getExpectedState());
                            }
                            if ((tempT = lt.getSecondTurnout()) != null) {
                                turnoutSettings.put(tempT, turnoutList.get(x).getExpectedState());
                            }
                            if (lt.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER && turnoutList.get(x).getExpectedState() == 4) {
                                LayoutBlock tempLB;
                                if (lt.getLayoutBlock() == lblks.get(i) || lt.getLayoutBlockC() == lblks.get(i)) {
                                    tempLB = lt.getLayoutBlockB();
                                    if (tempLB != null) {
                                        this.dblCrossoverAutoBlocks.add(tempLB.getBlock());
                                        block.put(tempLB.getBlock(), 4);
                                    }
                                    if ((tempLB = lt.getLayoutBlockD()) != null) {
                                        this.dblCrossoverAutoBlocks.add(tempLB.getBlock());
                                        block.put(tempLB.getBlock(), 4);
                                    }
                                } else if (lt.getLayoutBlockB() == lblks.get(i) || lt.getLayoutBlockD() == lblks.get(i)) {
                                    tempLB = lt.getLayoutBlock();
                                    if (tempLB != null) {
                                        this.dblCrossoverAutoBlocks.add(tempLB.getBlock());
                                        block.put(tempLB.getBlock(), 4);
                                    }
                                    if ((tempLB = lt.getLayoutBlockC()) != null) {
                                        this.dblCrossoverAutoBlocks.add(tempLB.getBlock());
                                        block.put(tempLB.getBlock(), 4);
                                    }
                                }
                            }
                        }
                        ++x;
                    }
                }
                ++i;
            }
            if (this.useLayoutEditorTurnouts) {
                this.setAutoTurnouts(turnoutSettings);
            }
            return block;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void setupAutoSignalMast(SignalMastLogic sml, boolean overwrite) {
            Hashtable<SignalMast, String> masts;
            if (!this.allowAutoSignalMastGeneration) {
                return;
            }
            List<SignalMastLogic> smlList = InstanceManager.getDefault(SignalMastLogicManager.class).getLogicsByDestination(this.destination);
            ArrayList<Block> allBlock = new ArrayList<Block>();
            for (NamedBeanSetting nbh : this.userSetBlocks) {
                allBlock.add((Block)nbh.getBean());
            }
            Set<Block> blockKeys = this.autoBlocks.keySet();
            for (Block key : blockKeys) {
                if (allBlock.contains(key)) continue;
                allBlock.add(key);
            }
            if (sml != null) {
                masts = this.autoMasts;
                if (!sml.areBlocksIncluded(allBlock)) return;
                SignalMast mast = sml.getSourceMast();
                String danger = mast.getAppearanceMap().getSpecificAppearance(2);
                masts.put(mast, danger);
            } else {
                masts = new Hashtable();
                int i = 0;
                while (i < smlList.size()) {
                    if (smlList.get(i).areBlocksIncluded(allBlock)) {
                        SignalMast mast = smlList.get(i).getSourceMast();
                        String danger = mast.getAppearanceMap().getSpecificAppearance(2);
                        masts.put(mast, danger);
                    }
                    ++i;
                }
            }
            this.setAutoMasts(masts, overwrite);
        }

        void addAutoSignalMast(SignalMast mast) {
            String danger;
            if (log.isDebugEnabled()) {
                log.debug("{} add mast to auto list {}", (Object)this.destination.getDisplayName(), (Object)mast);
            }
            if ((danger = mast.getAppearanceMap().getSpecificAppearance(2)) == null) {
                log.error("Can not add SignalMast {} to logic for {} to {} as it does not have a Danger appearance configured", new Object[]{mast.getDisplayName(), DefaultSignalMastLogic.this.source.getDisplayName(), this.destination.getDisplayName()});
                return;
            }
            this.autoMasts.put(mast, danger);
            if (this.destMastInit) {
                mast.addPropertyChangeListener(this.propertySignalMastListener);
            }
            DefaultSignalMastLogic.this.firePropertyChange("automasts", null, this.destination);
        }

        void removeAutoSignalMast(SignalMast mast) {
            this.autoMasts.remove(mast);
            if (this.destMastInit) {
                mast.removePropertyChangeListener(this.propertySignalMastListener);
            }
            DefaultSignalMastLogic.this.firePropertyChange("automasts", this.destination, null);
        }

        boolean useLayoutEditor() {
            return this.useLayoutEditor;
        }

        boolean useLayoutEditorBlocks() {
            return this.useLayoutEditorBlocks;
        }

        boolean useLayoutEditorTurnouts() {
            return this.useLayoutEditorTurnouts;
        }

        boolean allowAutoSignalMastGen() {
            return this.allowAutoSignalMastGeneration;
        }

        void allowAutoSignalMastGen(boolean gen) {
            if (this.allowAutoSignalMastGeneration == gen) {
                return;
            }
            this.allowAutoSignalMastGeneration = gen;
        }

        void dispose() {
            this.disposed = true;
            this.clearTurnoutLock();
            this.destination.removePropertyChangeListener(DefaultSignalMastLogic.this.propertyDestinationMastListener);
            this.setBlocks(null);
            this.setAutoBlocks(null);
            this.setTurnouts(null);
            this.setAutoTurnouts(null);
            this.setSensors(null);
            this.setMasts(null);
            this.setAutoMasts(null, true);
        }

        void lockTurnouts() {
            if (this.disposed || !this.lockTurnouts || !this.active) {
                return;
            }
            for (NamedBeanSetting nbh : this.userSetTurnouts) {
                Turnout key = (Turnout)nbh.getBean();
                key.setLocked(3, true);
            }
            Enumeration<Turnout> keys = this.autoTurnouts.keys();
            while (keys.hasMoreElements()) {
                Turnout key = keys.nextElement();
                key.setLocked(3, true);
            }
        }

        void clearTurnoutLock() {
            if (!this.lockTurnouts && !this.active) {
                return;
            }
            Enumeration<Turnout> keys = this.autoTurnouts.keys();
            while (keys.hasMoreElements()) {
                Turnout key = keys.nextElement();
                key.setLocked(3, false);
            }
            for (NamedBeanSetting nbh : this.userSetTurnouts) {
                Turnout key = (Turnout)nbh.getBean();
                key.setLocked(3, false);
            }
        }

        protected void calculateSpeed() {
            if (log.isDebugEnabled()) {
                log.debug("{} calculate the speed setting for this logic ie what the signalmast will display", (Object)this.destination.getDisplayName());
            }
            this.minimumBlockSpeed = 0.0f;
            Enumeration<Turnout> keys = this.autoTurnouts.keys();
            while (keys.hasMoreElements()) {
                Turnout key = keys.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug("{} turnout {}", (Object)this.destination.getDisplayName(), (Object)key.getDisplayName());
                }
                if (this.isTurnoutIncluded(key)) continue;
                if (this.autoTurnouts.get(key) == 2) {
                    if (!(key.getStraightLimit() < this.minimumBlockSpeed) && this.minimumBlockSpeed != 0.0f || key.getStraightLimit() == -1.0f) continue;
                    this.minimumBlockSpeed = key.getStraightLimit();
                    if (!log.isDebugEnabled()) continue;
                    log.debug("{} turnout {} set speed to {}", new Object[]{this.destination.getDisplayName(), key.getDisplayName(), Float.valueOf(this.minimumBlockSpeed)});
                    continue;
                }
                if (!(key.getDivergingLimit() < this.minimumBlockSpeed) && this.minimumBlockSpeed != 0.0f || key.getDivergingLimit() == -1.0f) continue;
                this.minimumBlockSpeed = key.getDivergingLimit();
                if (!log.isDebugEnabled()) continue;
                log.debug("{} turnout {} set speed to {}", new Object[]{this.destination.getDisplayName(), key.getDisplayName(), Float.valueOf(this.minimumBlockSpeed)});
            }
            for (NamedBeanSetting nbh : this.userSetTurnouts) {
                Turnout key = (Turnout)nbh.getBean();
                if (nbh.getSetting() == 2) {
                    if (!(key.getStraightLimit() < this.minimumBlockSpeed) && this.minimumBlockSpeed != 0.0f || key.getStraightLimit() == -1.0f) continue;
                    this.minimumBlockSpeed = key.getStraightLimit();
                    if (!log.isDebugEnabled()) continue;
                    log.debug("{} turnout {} set speed to {}", new Object[]{this.destination.getDisplayName(), key.getDisplayName(), Float.valueOf(this.minimumBlockSpeed)});
                    continue;
                }
                if (nbh.getSetting() != 4 || !(key.getDivergingLimit() < this.minimumBlockSpeed) && this.minimumBlockSpeed != 0.0f || key.getDivergingLimit() == -1.0f) continue;
                this.minimumBlockSpeed = key.getDivergingLimit();
                if (!log.isDebugEnabled()) continue;
                log.debug("{} turnout {} set speed to {}", new Object[]{this.destination.getDisplayName(), key.getDisplayName(), Float.valueOf(this.minimumBlockSpeed)});
            }
            Set<Block> autoBlockKeys = this.autoBlocks.keySet();
            for (Block key : autoBlockKeys) {
                log.debug("{} auto block add list {}", (Object)this.destination.getDisplayName(), (Object)key.getDisplayName());
                if (this.isBlockIncluded(key) || !(key.getSpeedLimit() < this.minimumBlockSpeed) && this.minimumBlockSpeed != 0.0f || key.getSpeedLimit() == -1.0f) continue;
                this.minimumBlockSpeed = key.getSpeedLimit();
                if (!log.isDebugEnabled()) continue;
                log.debug("{} block {} set speed to {}", new Object[]{this.destination.getDisplayName(), key.getDisplayName(), Float.valueOf(this.minimumBlockSpeed)});
            }
            for (NamedBeanSetting nbh : this.userSetBlocks) {
                Block key = (Block)nbh.getBean();
                if (!(key.getSpeedLimit() < this.minimumBlockSpeed) && this.minimumBlockSpeed != 0.0f || key.getSpeedLimit() == -1.0f) continue;
                if (log.isDebugEnabled()) {
                    log.debug("{} block {} set speed to {}", new Object[]{this.destination.getDisplayName(), key.getDisplayName(), Float.valueOf(this.minimumBlockSpeed)});
                }
                this.minimumBlockSpeed = key.getSpeedLimit();
            }
        }

        private class NamedBeanSetting {
            NamedBeanHandle<?> namedBean;
            int setting = 0;
            String strSetting = null;

            NamedBeanSetting(NamedBeanHandle<?> namedBean, int setting) {
                this.namedBean = namedBean;
                this.setting = setting;
            }

            NamedBeanSetting(NamedBeanHandle<?> namedBean, String setting) {
                this.namedBean = namedBean;
                this.strSetting = setting;
            }

            NamedBean getBean() {
                return this.namedBean.getBean();
            }

            NamedBeanHandle<?> getNamedBean() {
                return this.namedBean;
            }

            int getSetting() {
                return this.setting;
            }

            String getStringSetting() {
                return this.strSetting;
            }

            String getBeanName() {
                return this.namedBean.getName();
            }
        }
    }
}

