/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.Route;
import jmri.Sensor;
import jmri.Turnout;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import jmri.jmrit.Sound;
import jmri.script.JmriScriptEngineManager;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRoute
extends AbstractNamedBean
implements Route,
VetoableChangeListener {
    protected String mControlTurnout = "";
    protected NamedBeanHandle<Turnout> mControlNamedTurnout = null;
    protected int mControlTurnoutState = 4;
    protected int mDelay = 0;
    protected String mLockControlTurnout = "";
    protected NamedBeanHandle<Turnout> mLockControlNamedTurnout = null;
    protected int mLockControlTurnoutState = 4;
    protected String mTurnoutsAlignedSensor = "";
    protected NamedBeanHandle<Sensor> mTurnoutsAlignedNamedSensor = null;
    protected String soundFilename;
    protected String scriptFilename;
    protected NamedBeanHandleManager nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
    ArrayList<OutputSensor> _outputSensorList = new ArrayList();
    ArrayList<ControlSensor> _controlSensorList = new ArrayList();
    protected transient PropertyChangeListener mTurnoutListener = null;
    protected transient PropertyChangeListener mLockTurnoutListener = null;
    ArrayList<OutputTurnout> _outputTurnoutList = new ArrayList();
    private boolean busy = false;
    private boolean _enabled = true;
    private boolean _locked = false;
    private boolean activatedRoute = false;
    private static final Logger log = LoggerFactory.getLogger(DefaultRoute.class);

    public DefaultRoute(String systemName, String userName) {
        super(systemName, userName);
    }

    public DefaultRoute(String systemName) {
        super(systemName);
        log.debug("default Route {} created", (Object)systemName);
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameRoute");
    }

    @Override
    public boolean getEnabled() {
        return this._enabled;
    }

    @Override
    public void setEnabled(boolean v) {
        boolean old = this._enabled;
        this._enabled = v;
        if (old != v) {
            this.firePropertyChange("Enabled", old, v);
        }
    }

    @Override
    public boolean getLocked() {
        return this._locked;
    }

    @Override
    public void setLocked(boolean v) {
        this.lockTurnouts(v);
        boolean old = this._locked;
        this._locked = v;
        if (old != v) {
            this.firePropertyChange("Locked", old, v);
        }
    }

    @Override
    public boolean canLock() {
        for (OutputTurnout oto : this._outputTurnoutList) {
            Turnout to = oto.getTurnout();
            if (to == null || !to.canLock(1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addOutputTurnout(String turnoutName, int turnoutState) {
        OutputTurnout outputTurnout = new OutputTurnout(turnoutName);
        if (!outputTurnout.setState(turnoutState)) {
            return false;
        }
        this._outputTurnoutList.add(outputTurnout);
        return true;
    }

    @Override
    public void clearOutputTurnouts() {
        this._outputTurnoutList = new ArrayList();
    }

    @Override
    public int getNumOutputTurnouts() {
        return this._outputTurnoutList.size();
    }

    @Override
    public String getOutputTurnoutByIndex(int index) {
        try {
            return this._outputTurnoutList.get(index).getName();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public boolean isOutputTurnoutIncluded(String turnoutName) throws IllegalArgumentException {
        Turnout t1 = InstanceManager.turnoutManagerInstance().provideTurnout(turnoutName);
        return this.isOutputTurnoutIncluded(t1);
    }

    boolean isOutputTurnoutIncluded(Turnout t1) {
        int i = 0;
        while (i < this._outputTurnoutList.size()) {
            if (this._outputTurnoutList.get(i).getTurnout() == t1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void deleteOutputTurnout(Turnout t) {
        int index = -1;
        int i = 0;
        while (i < this._outputTurnoutList.size()) {
            if (this._outputTurnoutList.get(i).getTurnout() == t) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            this._outputTurnoutList.remove(index);
        }
    }

    @Override
    public int getOutputTurnoutSetState(String name) throws IllegalArgumentException {
        Turnout t1 = InstanceManager.turnoutManagerInstance().provideTurnout(name);
        int i = 0;
        while (i < this._outputTurnoutList.size()) {
            if (this._outputTurnoutList.get(i).getTurnout() == t1) {
                return this._outputTurnoutList.get(i).getState();
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Turnout getOutputTurnout(int k) {
        try {
            return this._outputTurnoutList.get(k).getTurnout();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public int getOutputTurnoutState(int k) {
        try {
            return this._outputTurnoutList.get(k).getState();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
    }

    @Override
    public boolean addOutputSensor(String sensorName, int state) {
        OutputSensor outputSensor = new OutputSensor(sensorName);
        if (!outputSensor.setState(state)) {
            return false;
        }
        this._outputSensorList.add(outputSensor);
        return true;
    }

    @Override
    public void clearOutputSensors() {
        this._outputSensorList = new ArrayList();
    }

    @Override
    public int getNumOutputSensors() {
        return this._outputSensorList.size();
    }

    @Override
    public String getOutputSensorByIndex(int index) {
        try {
            return this._outputSensorList.get(index).getName();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public boolean isOutputSensorIncluded(String sensorName) throws IllegalArgumentException {
        Sensor s1 = InstanceManager.sensorManagerInstance().provideSensor(sensorName);
        return this.isOutputSensorIncluded(s1);
    }

    boolean isOutputSensorIncluded(Sensor s1) {
        int i = 0;
        while (i < this._outputSensorList.size()) {
            if (this._outputSensorList.get(i).getSensor() == s1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int getOutputSensorSetState(String name) throws IllegalArgumentException {
        Sensor s1 = InstanceManager.sensorManagerInstance().provideSensor(name);
        int i = 0;
        while (i < this._outputSensorList.size()) {
            if (this._outputSensorList.get(i).getSensor() == s1) {
                return this._outputSensorList.get(i).getState();
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Sensor getOutputSensor(int k) {
        try {
            return this._outputSensorList.get(k).getSensor();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public int getOutputSensorState(int k) {
        try {
            return this._outputSensorList.get(k).getState();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
    }

    void removeOutputSensor(Sensor s) {
        int index = -1;
        int i = 0;
        while (i < this._outputSensorList.size()) {
            if (this._outputSensorList.get(i).getSensor() == s) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            this._outputSensorList.remove(index);
        }
    }

    @Override
    public void setOutputScriptName(String filename) {
        this.scriptFilename = filename;
    }

    @Override
    public String getOutputScriptName() {
        return this.scriptFilename;
    }

    @Override
    public void setOutputSoundName(String filename) {
        this.soundFilename = filename;
    }

    @Override
    public String getOutputSoundName() {
        return this.soundFilename;
    }

    @Override
    public void setTurnoutsAlignedSensor(String sensorName) throws IllegalArgumentException {
        log.debug("setTurnoutsAlignedSensor {} {}", (Object)this.getSystemName(), (Object)sensorName);
        this.mTurnoutsAlignedSensor = sensorName;
        if (this.mTurnoutsAlignedSensor == null || this.mTurnoutsAlignedSensor.isEmpty()) {
            this.mTurnoutsAlignedNamedSensor = null;
            return;
        }
        Sensor s = InstanceManager.sensorManagerInstance().provideSensor(this.mTurnoutsAlignedSensor);
        this.mTurnoutsAlignedNamedSensor = this.nbhm.getNamedBeanHandle(this.mTurnoutsAlignedSensor, s);
    }

    @Override
    public String getTurnoutsAlignedSensor() {
        if (this.mTurnoutsAlignedNamedSensor != null) {
            return this.mTurnoutsAlignedNamedSensor.getName();
        }
        return this.mTurnoutsAlignedSensor;
    }

    @Override
    @CheckForNull
    public Sensor getTurnoutsAlgdSensor() throws IllegalArgumentException {
        if (this.mTurnoutsAlignedNamedSensor != null) {
            return this.mTurnoutsAlignedNamedSensor.getBean();
        }
        if (this.mTurnoutsAlignedSensor != null && !this.mTurnoutsAlignedSensor.isEmpty()) {
            Sensor s = InstanceManager.sensorManagerInstance().provideSensor(this.mTurnoutsAlignedSensor);
            this.mTurnoutsAlignedNamedSensor = this.nbhm.getNamedBeanHandle(this.mTurnoutsAlignedSensor, s);
            return s;
        }
        return null;
    }

    @Override
    public void clearRouteSensors() {
        this._controlSensorList = new ArrayList();
    }

    private boolean isControlSensorIncluded(ControlSensor sensor) {
        int i = 0;
        while (i < this._controlSensorList.size()) {
            if (this._controlSensorList.get(i).getName().equals(sensor.getName()) && this._controlSensorList.get(i).getState() == sensor.getState()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean addSensorToRoute(String sensorName, int mode) {
        log.debug("addSensorToRoute({}, {}) as {} in {}", new Object[]{sensorName, mode, this._controlSensorList.size(), this.getSystemName()});
        ControlSensor sensor = new ControlSensor(sensorName);
        if (!sensor.setState(mode)) {
            return false;
        }
        if (this.isControlSensorIncluded(sensor)) {
            log.debug("Not adding duplicate control sensor {} to route {}", (Object)sensorName, (Object)this.getSystemName());
        } else {
            this._controlSensorList.add(sensor);
        }
        if (this._controlSensorList.size() > 3) {
            log.warn("Sensor {} exceeded maximum number of control Sensors for Route: {}", (Object)sensorName, (Object)this.getSystemName());
        }
        return true;
    }

    @Override
    public String getRouteSensorName(int index) {
        try {
            return this._controlSensorList.get(index).getName();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public Sensor getRouteSensor(int index) {
        try {
            return this._controlSensorList.get(index).getSensor();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public int getRouteSensorMode(int index) {
        try {
            return this._controlSensorList.get(index).getState();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return 0;
        }
    }

    boolean isRouteSensorIncluded(Sensor s) {
        int i = 0;
        while (i < this._controlSensorList.size()) {
            if (this._controlSensorList.get(i).getSensor() == s) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void removeRouteSensor(Sensor s) {
        int index = -1;
        int i = 0;
        while (i < this._controlSensorList.size()) {
            if (this._controlSensorList.get(i).getSensor() == s) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            this._controlSensorList.remove(index);
        }
    }

    @Override
    public void setControlTurnout(String turnoutName) throws IllegalArgumentException {
        this.mControlTurnout = turnoutName;
        if (this.mControlTurnout == null || this.mControlTurnout.isEmpty()) {
            this.mControlNamedTurnout = null;
            return;
        }
        Turnout t = InstanceManager.turnoutManagerInstance().provideTurnout(this.mControlTurnout);
        this.mControlNamedTurnout = this.nbhm.getNamedBeanHandle(this.mControlTurnout, t);
    }

    @Override
    public String getControlTurnout() {
        if (this.mControlNamedTurnout != null) {
            return this.mControlNamedTurnout.getName();
        }
        return this.mControlTurnout;
    }

    @Override
    @CheckForNull
    public Turnout getCtlTurnout() throws IllegalArgumentException {
        if (this.mControlNamedTurnout != null) {
            return this.mControlNamedTurnout.getBean();
        }
        if (this.mControlTurnout != null && !this.mControlTurnout.isEmpty()) {
            Turnout t = InstanceManager.turnoutManagerInstance().provideTurnout(this.mControlTurnout);
            this.mControlNamedTurnout = this.nbhm.getNamedBeanHandle(this.mControlTurnout, t);
            return t;
        }
        return null;
    }

    @Override
    public void setLockControlTurnout(@CheckForNull String turnoutName) throws IllegalArgumentException {
        this.mLockControlTurnout = turnoutName;
        if (this.mLockControlTurnout == null || this.mLockControlTurnout.isEmpty()) {
            this.mLockControlNamedTurnout = null;
            return;
        }
        Turnout t = InstanceManager.turnoutManagerInstance().provideTurnout(this.mLockControlTurnout);
        this.mLockControlNamedTurnout = this.nbhm.getNamedBeanHandle(this.mLockControlTurnout, t);
    }

    @Override
    public String getLockControlTurnout() {
        if (this.mLockControlNamedTurnout != null) {
            return this.mLockControlNamedTurnout.getName();
        }
        return this.mLockControlTurnout;
    }

    @Override
    @CheckForNull
    public Turnout getLockCtlTurnout() throws IllegalArgumentException {
        if (this.mLockControlNamedTurnout != null) {
            return this.mLockControlNamedTurnout.getBean();
        }
        if (this.mLockControlTurnout != null && !this.mLockControlTurnout.isEmpty()) {
            Turnout t = InstanceManager.turnoutManagerInstance().provideTurnout(this.mLockControlTurnout);
            this.mLockControlNamedTurnout = this.nbhm.getNamedBeanHandle(this.mLockControlTurnout, t);
            return t;
        }
        return null;
    }

    @Override
    public void setRouteCommandDelay(int delay) {
        if (delay >= 0) {
            this.mDelay = delay;
        }
    }

    @Override
    public int getRouteCommandDelay() {
        return this.mDelay;
    }

    @Override
    public void setControlTurnoutState(int turnoutState) {
        if (turnoutState == 4 || turnoutState == 2 || turnoutState == 32 || turnoutState == 8 || turnoutState == 16) {
            this.mControlTurnoutState = turnoutState;
        } else {
            log.error("Attempt to set invalid control Turnout state for Route.");
        }
    }

    @Override
    public int getControlTurnoutState() {
        return this.mControlTurnoutState;
    }

    @Override
    public void setLockControlTurnoutState(int turnoutState) {
        if (turnoutState == 4 || turnoutState == 2 || turnoutState == 32) {
            this.mLockControlTurnoutState = turnoutState;
        } else {
            log.error("Attempt to set invalid lock control Turnout state for Route.");
        }
    }

    @Override
    public int getLockControlTurnoutState() {
        return this.mLockControlTurnoutState;
    }

    private void lockTurnouts(boolean lock) {
        int i = 0;
        while (i < this._outputTurnoutList.size()) {
            this._outputTurnoutList.get(i).getTurnout().setLocked(3, lock);
            ++i;
        }
    }

    @Override
    public void setRoute() {
        if (!this._outputTurnoutList.isEmpty() || !this._outputSensorList.isEmpty() || this.soundFilename != null || this.scriptFilename != null) {
            if (!this.busy) {
                log.debug("Setting route {}", (Object)this.getSystemName());
                this.setRouteBusy(true);
                SetRouteThread thread = new SetRouteThread(this);
                thread.setName("Route " + this.getDisplayName() + " setRoute");
                thread.start();
            } else {
                log.debug("Not setting route {} because busy", (Object)this.getSystemName());
            }
        } else {
            log.debug("Unable to set route {} because no turnouts or no sensors", (Object)this.getSystemName());
        }
    }

    protected void checkSensor(int newState, int oldState, Sensor sensor) {
        if (this.isVetoed()) {
            return;
        }
        String name = sensor.getSystemName();
        log.debug("check Sensor {} for {}", (Object)name, (Object)this.getSystemName());
        boolean fire = false;
        int i = 0;
        while (i < this._controlSensorList.size()) {
            Sensor s = this.getRouteSensor(i);
            if (s != null && s.equals(sensor)) {
                int mode = this.getRouteSensorMode(i);
                log.debug("match mode: {} new state: {} old state: {}", new Object[]{mode, newState, oldState});
                if (mode == 0 && newState == 2 || mode == 1 && newState == 4 || mode == 32 && newState != oldState) {
                    fire = true;
                }
            }
            ++i;
        }
        log.debug("check activated");
        if (!fire) {
            return;
        }
        log.debug("call setRoute for {}", (Object)this.getSystemName());
        this.setRoute();
    }

    void checkTurnout(int newState, int oldState, Turnout t) {
        if (this.isVetoed()) {
            return;
        }
        switch (this.mControlTurnoutState) {
            case 2: {
                if (newState != 2) break;
                this.setRoute();
                break;
            }
            case 4: {
                if (newState != 4) break;
                this.setRoute();
                break;
            }
            case 32: {
                if (newState == oldState) break;
                this.setRoute();
                break;
            }
        }
    }

    void checkLockTurnout(int newState, int oldState, Turnout t) {
        switch (this.mLockControlTurnoutState) {
            case 2: {
                this.setLocked(newState == 2);
                break;
            }
            case 4: {
                this.setLocked(newState == 4);
                break;
            }
            case 32: {
                if (newState == oldState) break;
                this.setLocked(!this.getLocked());
            }
        }
    }

    public void checkTurnoutAlignment() {
        Sensor sensor = this.getTurnoutsAlgdSensor();
        if (sensor != null) {
            try {
                if (this.isRouteBusy()) {
                    sensor.setKnownState(8);
                    return;
                }
                for (OutputTurnout ot : this._outputTurnoutList) {
                    Turnout turnout = ot.getTurnout();
                    int targetState = ot.getState();
                    if (!turnout.isConsistentState()) {
                        sensor.setKnownState(8);
                        return;
                    }
                    if (targetState == 8 || targetState == turnout.getKnownState()) continue;
                    sensor.setKnownState(4);
                    return;
                }
                sensor.setKnownState(2);
            }
            catch (JmriException jmriException) {
                log.warn("Exception setting sensor {} in route", (Object)this.getTurnoutsAlignedSensor());
            }
        }
    }

    @Override
    public void activateRoute() {
        Turnout lockCtl;
        int k;
        this.activatedRoute = true;
        if (!this.getTurnoutsAlignedSensor().isEmpty()) {
            k = 0;
            while (k < this._outputTurnoutList.size()) {
                this._outputTurnoutList.get(k).addListener();
                ++k;
            }
        }
        k = 0;
        while (k < this._controlSensorList.size()) {
            this._controlSensorList.get(k).addListener();
            ++k;
        }
        Turnout ctl = this.getCtlTurnout();
        if (ctl != null) {
            this.mTurnoutListener = e -> {
                if (e.getPropertyName().equals("KnownState")) {
                    int now = (Integer)e.getNewValue();
                    int then = (Integer)e.getOldValue();
                    this.checkTurnout(now, then, (Turnout)e.getSource());
                }
            };
            ctl.addPropertyChangeListener(this.mTurnoutListener, this.getControlTurnout(), "Route " + this.getDisplayName());
        }
        if ((lockCtl = this.getLockCtlTurnout()) != null) {
            this.mLockTurnoutListener = e -> {
                if (e.getPropertyName().equals("KnownState")) {
                    int now = (Integer)e.getNewValue();
                    int then = (Integer)e.getOldValue();
                    this.checkLockTurnout(now, then, (Turnout)e.getSource());
                }
            };
            lockCtl.addPropertyChangeListener(this.mLockTurnoutListener, this.getLockControlTurnout(), "Route " + this.getDisplayName());
        }
        this.checkTurnoutAlignment();
    }

    boolean isVetoed() {
        log.debug("check for veto");
        if (!this._enabled) {
            return true;
        }
        int i = 0;
        while (i < this._controlSensorList.size()) {
            ControlSensor controlSensor = this._controlSensorList.get(i);
            int s = controlSensor.getSensor().getKnownState();
            int mode = controlSensor.getState();
            if (mode == 2 && s == 2 || mode == 3 && s == 4) {
                return true;
            }
            ++i;
        }
        Turnout ctl = this.getCtlTurnout();
        if (ctl != null) {
            int tstate = ctl.getKnownState();
            if (this.mControlTurnoutState == 8 && tstate == 2) {
                return true;
            }
            if (this.mControlTurnoutState == 16 && tstate == 4) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void deActivateRoute() {
        if (!this.activatedRoute) {
            return;
        }
        this.activatedRoute = false;
        int k = 0;
        while (k < this._controlSensorList.size()) {
            this._controlSensorList.get(k).removeListener();
            ++k;
        }
        if (this.mTurnoutListener != null) {
            Turnout ctl = this.getCtlTurnout();
            if (ctl != null) {
                ctl.removePropertyChangeListener(this.mTurnoutListener);
            }
            this.mTurnoutListener = null;
        }
        if (this.mLockTurnoutListener != null) {
            Turnout lockCtl = this.getCtlTurnout();
            if (lockCtl != null) {
                lockCtl.removePropertyChangeListener(this.mLockTurnoutListener);
            }
            this.mLockTurnoutListener = null;
        }
        if (!this.mTurnoutsAlignedSensor.isEmpty()) {
            k = 0;
            while (k < this._outputTurnoutList.size()) {
                this._outputTurnoutList.get(k).removeListener();
                ++k;
            }
        }
    }

    protected void setRouteBusy(boolean busy) {
        this.busy = busy;
        this.checkTurnoutAlignment();
    }

    protected boolean isRouteBusy() {
        return this.busy;
    }

    @Override
    public int getState() {
        Sensor s = this.getTurnoutsAlgdSensor();
        if (s != null) {
            return s.getKnownState();
        }
        return 1;
    }

    @Override
    public void setState(int state) {
        this.setRoute();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        NamedBean nb = (NamedBean)evt.getOldValue();
        if ("CanDelete".equals(evt.getPropertyName())) {
            StringBuilder message = new StringBuilder();
            message.append("<b>").append(this.getDisplayName()).append("</b><ul>");
            boolean found = false;
            if (nb instanceof Turnout) {
                if (this.isOutputTurnoutIncluded((Turnout)nb)) {
                    message.append(Bundle.getMessage("InUseRouteOutputTurnout"));
                    found = true;
                }
                if (nb.equals(this.getCtlTurnout())) {
                    message.append(Bundle.getMessage("InUseRouteControlTurnout"));
                    found = true;
                }
                if (nb.equals(this.getLockCtlTurnout())) {
                    message.append(Bundle.getMessage("InUseRouteLockTurnout"));
                    found = true;
                }
            } else if (nb instanceof Sensor) {
                if (this.isOutputSensorIncluded((Sensor)nb)) {
                    message.append(Bundle.getMessage("InUseRouteOutputSensor"));
                    found = true;
                }
                if (nb.equals(this.getTurnoutsAlgdSensor())) {
                    message.append(Bundle.getMessage("InUseRouteAlignSensor"));
                    found = true;
                }
                if (this.isRouteSensorIncluded((Sensor)nb)) {
                    message.append(Bundle.getMessage("InUseRouteSensor"));
                    found = true;
                }
            }
            if (found) {
                message.append("</ul>");
                throw new PropertyVetoException(message.toString(), evt);
            }
        } else if ("DoDelete".equals(evt.getPropertyName())) {
            if (nb instanceof Turnout) {
                if (this.isOutputTurnoutIncluded((Turnout)nb)) {
                    this.deActivateRoute();
                    this.deleteOutputTurnout((Turnout)evt.getOldValue());
                }
                if (nb.equals(this.getCtlTurnout())) {
                    this.deActivateRoute();
                    this.setControlTurnout(null);
                }
                if (nb.equals(this.getLockCtlTurnout())) {
                    this.deActivateRoute();
                    this.setLockControlTurnout(null);
                }
            } else if (nb instanceof Sensor) {
                if (this.isOutputSensorIncluded((Sensor)nb)) {
                    this.deActivateRoute();
                    this.removeOutputSensor((Sensor)nb);
                }
                if (nb.equals(this.getTurnoutsAlgdSensor())) {
                    this.deActivateRoute();
                    this.setTurnoutsAlignedSensor(null);
                }
                if (this.isRouteSensorIncluded((Sensor)nb)) {
                    this.deActivateRoute();
                    this.removeRouteSensor((Sensor)nb);
                }
            }
            this.activateRoute();
        }
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            int i = 0;
            while (i < this.getNumOutputTurnouts()) {
                if (bean.equals(this.getOutputTurnout(i))) {
                    report.add(new NamedBeanUsageReport("RouteTurnoutOutput"));
                }
                ++i;
            }
            i = 0;
            while (i < this.getNumOutputSensors()) {
                if (bean.equals(this.getOutputSensor(i))) {
                    report.add(new NamedBeanUsageReport("RouteSensorOutput"));
                }
                ++i;
            }
            i = 0;
            while (i < this._controlSensorList.size()) {
                if (bean.equals(this.getRouteSensor(i))) {
                    report.add(new NamedBeanUsageReport("RouteSensorControl"));
                }
                ++i;
            }
            if (bean.equals(this.getTurnoutsAlgdSensor())) {
                report.add(new NamedBeanUsageReport("RouteSensorAligned"));
            }
            if (bean.equals(this.getCtlTurnout())) {
                report.add(new NamedBeanUsageReport("RouteTurnoutControl"));
            }
            if (bean.equals(this.getLockCtlTurnout())) {
                report.add(new NamedBeanUsageReport("RouteTurnoutLock"));
            }
        }
        return report;
    }

    private class ControlSensor
    extends OutputSensor
    implements PropertyChangeListener {
        ControlSensor(String name) {
            super(name);
        }

        @Override
        boolean setState(int state) {
            if (this._sensor == null) {
                return false;
            }
            this._state = state;
            return true;
        }

        void addListener() {
            if (this._sensor != null) {
                ((Sensor)this._sensor.getBean()).addPropertyChangeListener(this, this.getName(), "Route " + DefaultRoute.this.getDisplayName() + "Output Sensor");
            }
        }

        void removeListener() {
            if (this._sensor != null) {
                ((Sensor)this._sensor.getBean()).removePropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("KnownState")) {
                int now = (Integer)e.getNewValue();
                int then = (Integer)e.getOldValue();
                DefaultRoute.this.checkSensor(now, then, (Sensor)e.getSource());
            }
        }
    }

    private class OutputSensor {
        NamedBeanHandle<Sensor> _sensor;
        int _state = 2;

        OutputSensor(String name) throws IllegalArgumentException {
            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(name);
            this._sensor = DefaultRoute.this.nbhm.getNamedBeanHandle(name, sensor);
        }

        String getName() {
            if (this._sensor != null) {
                return this._sensor.getName();
            }
            return null;
        }

        boolean setState(int state) {
            if (this._sensor == null) {
                return false;
            }
            if (state != 2 && state != 4 && state != 8) {
                log.warn("Illegal Sensor state for Route: {}", (Object)this.getName());
                return false;
            }
            this._state = state;
            return true;
        }

        int getState() {
            return this._state;
        }

        Sensor getSensor() {
            if (this._sensor != null) {
                return this._sensor.getBean();
            }
            return null;
        }
    }

    private class OutputTurnout
    implements PropertyChangeListener {
        NamedBeanHandle<Turnout> _turnout;
        int _state;

        OutputTurnout(String name) throws IllegalArgumentException {
            Turnout turnout = InstanceManager.turnoutManagerInstance().provideTurnout(name);
            this._turnout = DefaultRoute.this.nbhm.getNamedBeanHandle(name, turnout);
        }

        String getName() {
            if (this._turnout != null) {
                return this._turnout.getName();
            }
            return null;
        }

        boolean setState(int state) {
            if (this._turnout == null) {
                return false;
            }
            if (state != 4 && state != 2 && state != 8) {
                log.warn("Illegal Turnout state for Route: {}", (Object)this.getName());
                return false;
            }
            this._state = state;
            return true;
        }

        int getState() {
            return this._state;
        }

        Turnout getTurnout() {
            return this._turnout != null ? this._turnout.getBean() : null;
        }

        void addListener() {
            if (this._turnout != null) {
                this._turnout.getBean().addPropertyChangeListener(this, this.getName(), "Route " + DefaultRoute.this.getDisplayName() + " Output Turnout");
            }
        }

        void removeListener() {
            if (this._turnout != null) {
                this._turnout.getBean().removePropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("KnownState") || e.getPropertyName().equals("CommandedState")) {
                DefaultRoute.this.checkTurnoutAlignment();
            }
        }
    }

    static class SetRouteThread
    extends Thread {
        private final DefaultRoute r;
        private static final Logger log = LoggerFactory.getLogger(SetRouteThread.class);

        public SetRouteThread(DefaultRoute aRoute) {
            this.r = aRoute;
        }

        @Override
        public void run() {
            if (this.r.getOutputScriptName() != null && !this.r.getOutputScriptName().isEmpty()) {
                JmriScriptEngineManager.getDefault().runScript(new File(FileUtil.getExternalFilename(this.r.getOutputScriptName())));
            }
            if (this.r.getOutputSoundName() != null && !this.r.getOutputSoundName().isEmpty()) {
                try {
                    new Sound(this.r.getOutputSoundName()).play();
                }
                catch (NullPointerException nullPointerException) {
                    log.error("Cannot find file {}", (Object)this.r.getOutputSoundName());
                }
            }
            int k = 0;
            while (k < this.r.getNumOutputSensors()) {
                Sensor t = this.r.getOutputSensor(k);
                if (t == null) {
                    log.warn("Sensor {} not found for Route {}", (Object)k, (Object)this.r.getDisplayName());
                } else {
                    int state = this.r.getOutputSensorState(k);
                    if (state == 8) {
                        int st = t.getKnownState();
                        state = st == 2 ? 4 : 2;
                    }
                    int toState = state;
                    Sensor setSensor = t;
                    ThreadingUtil.runOnLayoutEventually(() -> {
                        try {
                            setSensor.setKnownState(toState);
                        }
                        catch (JmriException jmriException) {
                            log.warn("Exception setting sensor {} in route", (Object)setSensor.getSystemName());
                        }
                    });
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                ++k;
            }
            int delay = this.r.getRouteCommandDelay();
            int k2 = 0;
            while (k2 < this.r.getNumOutputTurnouts()) {
                Turnout t = this.r.getOutputTurnout(k2);
                int state = this.r.getOutputTurnoutState(k2);
                if (state == 8) {
                    int st = t.getKnownState();
                    state = st == 2 ? 4 : 2;
                }
                int toState = state;
                Turnout setTurnout = t;
                ThreadingUtil.runOnLayoutEventually(() -> setTurnout.setCommandedStateAtInterval(toState));
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                ++k2;
            }
            this.r.setRouteBusy(false);
        }
    }
}

