/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import jmri.JmriException;
import jmri.RailCom;
import jmri.implementation.DefaultIdTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRailCom
extends DefaultIdTag
implements RailCom {
    private int currentState = 0;
    private int expectedCV = -1;
    Hashtable<Integer, Integer> cvValues = new Hashtable();
    private static final Logger log = LoggerFactory.getLogger(DefaultRailCom.class);

    public DefaultRailCom(String systemName) {
        super(systemName);
        this.setWhereLastSeen(null);
    }

    public DefaultRailCom(String systemName, String userName) {
        super(systemName, userName);
        this.setWhereLastSeen(null);
    }

    @Override
    public void setState(int s) throws JmriException {
        this.currentState = s;
    }

    @Override
    public int getState() {
        return this.currentState;
    }

    @Override
    public void setOrientation(int type) {
        this.setProperty("orientation", type);
    }

    @Override
    public int getOrientation() {
        Integer t = (Integer)this.getProperty("orientation");
        return t != null ? t : 1;
    }

    @Override
    public void setActualSpeed(int type) {
        this.setProperty("actualspeed", type);
    }

    @Override
    public int getActualSpeed() {
        Integer t = (Integer)this.getProperty("actualspeed");
        return t != null ? t : -1;
    }

    @Override
    public void setActualLoad(int type) {
        this.setProperty("actualload", type);
    }

    @Override
    public int getActualLoad() {
        Integer t = (Integer)this.getProperty("actualload");
        return t != null ? t : -1;
    }

    @Override
    public void setActualTemperature(int type) {
        this.setProperty("actualtemperature", type);
    }

    @Override
    public int getActualTemperature() {
        Integer t = (Integer)this.getProperty("actualtemperature");
        return t != null ? t : -1;
    }

    @Override
    public void setWaterLevel(int type) {
        this.setProperty("waterlevel", type);
    }

    @Override
    public int getWaterLevel() {
        Integer t = (Integer)this.getProperty("waterlevel");
        return t != null ? t : -1;
    }

    @Override
    public void setFuelLevel(int type) {
        this.setProperty("fuellevel", type);
    }

    @Override
    public int getFuelLevel() {
        Integer t = (Integer)this.getProperty("fuellevel");
        return t != null ? t : -1;
    }

    @Override
    public void setLocation(int type) {
        this.setProperty("location", type);
    }

    @Override
    public int getLocation() {
        Integer t = (Integer)this.getProperty("location");
        return t != null ? t : -1;
    }

    @Override
    public void setRoutingNo(int type) {
        this.setProperty("routing", type);
    }

    @Override
    public int getRoutingNo() {
        Integer t = (Integer)this.getProperty("routing");
        return t != null ? t : -1;
    }

    @Override
    public void setExpectedCv(int cv) {
        this.expectedCV = cv;
    }

    @Override
    public int getExpectedCv() {
        return this.expectedCV;
    }

    @Override
    public void setCvValue(int value) {
        if (this.expectedCV == -1) {
            log.debug("set cv value called but no CV is expected");
            return;
        }
        int exp = this.expectedCV;
        this.expectedCV = -1;
        this.setCV(exp, value);
    }

    @Override
    public int getCV(int cv) {
        if (this.cvValues.containsKey(cv)) {
            return this.cvValues.get(cv);
        }
        return 0;
    }

    @Override
    public void setCV(int cv, int value) {
        if (this.cvValues.containsKey(cv) && this.cvValues.get(cv) == value) {
            this.firePropertyChange("cvvalue", cv, value);
            return;
        }
        this.cvValues.put(cv, value);
        this.firePropertyChange("cvvalue", cv, value);
    }

    @Override
    public List<Integer> getCVList() {
        int[] arr = new int[this.cvValues.size()];
        ArrayList<Integer> out = new ArrayList<Integer>();
        Enumeration<Integer> en = this.cvValues.keys();
        int i = 0;
        while (en.hasMoreElements()) {
            arr[i] = en.nextElement();
            ++i;
        }
        i = 0;
        while (i < arr.length) {
            out.add(arr[i]);
            ++i;
        }
        return out;
    }

    @Override
    public String toReportString() {
        StringBuilder sb = new StringBuilder(200);
        switch (this.getOrientation()) {
            case 16: {
                sb.append("Orientation A ");
                break;
            }
            case 32: {
                sb.append("Orientation B ");
                break;
            }
            default: {
                sb.append("Unknown Orientation ");
            }
        }
        sb.append("Address ").append(this.getLocoAddress()).append(" ");
        if (this.getWaterLevel() != -1) {
            sb.append("Water ").append(this.getWaterLevel()).append(" ");
        }
        if (this.getFuelLevel() != -1) {
            sb.append("Fuel ").append(this.getFuelLevel()).append(" ");
        }
        if (this.getLocation() != -1) {
            sb.append("Location : ").append(this.getLocation()).append(" ");
        }
        if (this.getRoutingNo() != -1) {
            sb.append("Routing No : ").append(this.getRoutingNo()).append(" ");
        }
        if (this.getActualTemperature() != -1) {
            sb.append("Temperature : ").append(this.getActualTemperature()).append(" ");
        }
        if (this.getActualLoad() != -1) {
            sb.append("Load : ").append(this.getActualLoad()).append(" ");
        }
        if (this.getActualSpeed() != -1) {
            sb.append("Speed : ").append(this.getActualSpeed()).append(" ");
        }
        return sb.toString();
    }
}

