/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import javax.annotation.Nonnull;
import jmri.AnalogIO;
import jmri.CurrentMeter;
import jmri.JmriException;
import jmri.Meter;
import jmri.VoltageMeter;
import jmri.implementation.AbstractAnalogIO;
import jmri.implementation.Bundle;
import jmri.implementation.MeterUpdateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMeter
extends AbstractAnalogIO
implements Meter {
    @Nonnull
    private final MeterUpdateTask _updateTask;
    @Nonnull
    private final Meter.Unit _unit;
    private final double _min;
    private final double _max;
    private final double _resolution;
    private static final Logger log = LoggerFactory.getLogger(DefaultMeter.class);

    public DefaultMeter(@Nonnull String sys, @Nonnull Meter.Unit unit, double min, double max, double resolution, @Nonnull MeterUpdateTask updateTask) {
        super(sys, true);
        this._unit = unit;
        this._updateTask = updateTask;
        this._min = min;
        this._max = max;
        this._resolution = resolution;
        this._updateTask.addMeter(this);
    }

    @Override
    public void enable() {
        log.debug("Enabling meter.");
        this._updateTask.enable(this);
    }

    @Override
    public void disable() {
        log.debug("Disabling meter.");
        this._updateTask.disable(this);
    }

    @Override
    protected void sendValueToLayout(double value) throws JmriException {
    }

    @Override
    protected boolean cutOutOfBoundsValues() {
        return true;
    }

    @Override
    public void setState(int s) throws JmriException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getState() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameMeter");
    }

    @Override
    public Meter.Unit getUnit() {
        return this._unit;
    }

    @Override
    public double getMin() {
        return this._min;
    }

    @Override
    public double getMax() {
        return this._max;
    }

    @Override
    public double getResolution() {
        return this._resolution;
    }

    @Override
    public AnalogIO.AbsoluteOrRelative getAbsoluteOrRelative() {
        return this._unit == Meter.Unit.Percent ? AnalogIO.AbsoluteOrRelative.RELATIVE : AnalogIO.AbsoluteOrRelative.ABSOLUTE;
    }

    @Override
    public void dispose() {
        this._updateTask.removeMeter(this);
        super.dispose();
    }

    @Override
    public void requestUpdateFromLayout() {
        this._updateTask.requestUpdateFromLayout();
    }

    public static class DefaultCurrentMeter
    extends DefaultMeter
    implements CurrentMeter {
        public DefaultCurrentMeter(@Nonnull String sys, Meter.Unit unit, double min, double max, double resolution, MeterUpdateTask updateTask) {
            super(sys, unit, min, max, resolution, updateTask);
        }
    }

    public static class DefaultVoltageMeter
    extends DefaultMeter
    implements VoltageMeter {
        public DefaultVoltageMeter(@Nonnull String sys, Meter.Unit unit, double min, double max, double resolution, MeterUpdateTask updateTask) {
            super(sys, unit, min, max, resolution, updateTask);
        }
    }
}

