/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalManager;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Logix;
import jmri.Memory;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.Timebase;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import jmri.implementation.DefaultConditional;
import jmri.implementation.JmriClockPropertyListener;
import jmri.implementation.JmriMultiStatePropertyListener;
import jmri.implementation.JmriSimplePropertyListener;
import jmri.implementation.JmriTwoStatePropertyListener;
import jmri.jmrit.beantable.LRouteTableAction;
import jmri.jmrit.entryexit.DestinationPoints;
import jmri.jmrit.entryexit.EntryExitPairs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogix
extends AbstractNamedBean
implements Logix {
    private final ConditionalManager conditionalManager;
    ArrayList<String> _conditionalSystemNames = new ArrayList();
    ArrayList<JmriSimplePropertyListener> _listeners = new ArrayList();
    HashMap<String, Conditional> _conditionalMap = new HashMap();
    private boolean mEnabled = true;
    private boolean _isActivated = false;
    private boolean _isGuiSet = false;
    static final Pattern NXUUID = Pattern.compile("^IN:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$", 2);
    private static final Logger log = LoggerFactory.getLogger(DefaultLogix.class);

    public DefaultLogix(String systemName, String userName) {
        this(systemName, userName, InstanceManager.getDefault(ConditionalManager.class));
    }

    public DefaultLogix(String systemName, String userName, ConditionalManager conditionalManager) {
        super(systemName, userName);
        this.conditionalManager = conditionalManager;
    }

    public DefaultLogix(String systemName) {
        this(systemName, InstanceManager.getDefault(ConditionalManager.class));
    }

    public DefaultLogix(String systemName, ConditionalManager conditionalManager) {
        super(systemName);
        this.conditionalManager = conditionalManager;
    }

    @Override
    @Nonnull
    public String getBeanType() {
        return Bundle.getMessage("BeanNameLogix");
    }

    @Override
    public int getNumConditionals() {
        return this._conditionalSystemNames.size();
    }

    @Override
    public void swapConditional(int nextInOrder, int row) {
        if (row <= nextInOrder) {
            return;
        }
        String temp = this._conditionalSystemNames.get(row);
        int i = row;
        while (i > nextInOrder) {
            this._conditionalSystemNames.set(i, this._conditionalSystemNames.get(i - 1));
            --i;
        }
        this._conditionalSystemNames.set(nextInOrder, temp);
    }

    @Override
    public String getConditionalByNumberOrder(int order) {
        try {
            return this._conditionalSystemNames.get(order);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public boolean addConditional(String systemName, int order) {
        this._conditionalSystemNames.add(systemName);
        return true;
    }

    @Override
    public boolean addConditional(String systemName, Conditional conditional) {
        Conditional chkDuplicate = this._conditionalMap.putIfAbsent(systemName, conditional);
        if (chkDuplicate == null) {
            return true;
        }
        log.error("Conditional '{}' has already been added to Logix '{}'", (Object)systemName, (Object)this.getSystemName());
        return false;
    }

    @Override
    public Conditional getConditional(String systemName) {
        return this._conditionalMap.get(systemName);
    }

    @Override
    public void setEnabled(boolean state) {
        boolean old = this.mEnabled;
        this.mEnabled = state;
        if (old != state) {
            boolean active = this._isActivated;
            this.deActivateLogix();
            this.activateLogix();
            this._isActivated = active;
            int i = this._listeners.size() - 1;
            while (i >= 0) {
                this._listeners.get(i).setEnabled(state);
                --i;
            }
            this.firePropertyChange("Enabled", old, state);
        }
    }

    @Override
    public boolean getEnabled() {
        return this.mEnabled;
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="null returned is documented in each method to mean completed without problems")
    public String[] deleteConditional(String systemName) {
        if (this._conditionalSystemNames.size() <= 0) {
            return null;
        }
        ArrayList<String> checkReferences = this.conditionalManager.getWhereUsed(systemName);
        if (checkReferences != null) {
            Conditional c = this.getConditional(systemName);
            String refName = checkReferences.get(0);
            Logix x = this.conditionalManager.getParentLogix(refName);
            Conditional cRef = x.getConditional(refName);
            return new String[]{c.getUserName(), c.getSystemName(), cRef.getUserName(), cRef.getSystemName(), x.getUserName(), x.getSystemName()};
        }
        if (!this._conditionalSystemNames.remove(systemName)) {
            log.error("attempt to delete Conditional not in Logix: {}", (Object)systemName);
            return null;
        }
        Conditional c = this.conditionalManager.getBySystemName(systemName);
        if (c == null) {
            log.error("attempt to delete non-existing Conditional - {}", (Object)systemName);
            return null;
        }
        this._conditionalMap.remove(systemName);
        return null;
    }

    @Override
    public void calculateConditionals() {
        for (String conditionalSystemName : this._conditionalSystemNames) {
            Conditional c = this.getConditional(conditionalSystemName);
            if (c == null) {
                log.error("Invalid conditional system name when calculating Logix - {}", (Object)conditionalSystemName);
                continue;
            }
            c.calculate(this.mEnabled, null);
        }
    }

    @Override
    public void activateLogix() {
        if (this._isActivated) {
            return;
        }
        this.resetConditionals();
        this.assembleListenerList();
        for (JmriSimplePropertyListener listener : this._listeners) {
            this.startListener(listener);
        }
        this._isActivated = true;
        this.calculateConditionals();
    }

    private void resetConditionals() {
        for (String conditionalSystemName : this._conditionalSystemNames) {
            Conditional conditional = this.getConditional(conditionalSystemName);
            if (conditional == null) continue;
            try {
                conditional.setState(1);
            }
            catch (JmriException jmriException) {}
        }
    }

    @Override
    public void setGuiNames() {
        if (this._isGuiSet) {
            return;
        }
        if (this.getSystemName().equals("SYS")) {
            this._isGuiSet = true;
            return;
        }
        for (String cName : this._conditionalSystemNames) {
            Conditional conditional = this.getConditional(cName);
            if (conditional == null) {
                log.error("setGuiNames: Missing conditional for Logix index entry,  Logix name = '{}', Conditional index name = '{}'", (Object)this.getSystemName(), (Object)cName);
                continue;
            }
            List<ConditionalVariable> varList = conditional.getCopyOfStateVariables();
            boolean isDirty = false;
            ArrayList<ConditionalVariable> badVariable = new ArrayList<ConditionalVariable>();
            for (ConditionalVariable var : varList) {
                if (var.getType() == Conditional.Type.CONDITIONAL_TRUE || var.getType() == Conditional.Type.CONDITIONAL_FALSE) {
                    Conditional cRef = this.conditionalManager.getConditional(var.getName());
                    if (cRef != null) {
                        var.setName(cRef.getSystemName());
                        String uName = cRef.getUserName();
                        if (uName == null || uName.isEmpty()) {
                            var.setGuiName(cRef.getSystemName());
                        } else {
                            var.setGuiName(uName);
                        }
                        this.conditionalManager.addWhereUsed(var.getName(), cName);
                        isDirty = true;
                    } else {
                        log.error("setGuiNames: For conditional '{}' in logix '{}', the referenced conditional, '{}',  does not exist", new Object[]{cName, this.getSystemName(), var.getName()});
                    }
                }
                if (var.getType() != Conditional.Type.ENTRYEXIT_ACTIVE && var.getType() != Conditional.Type.ENTRYEXIT_INACTIVE || NXUUID.matcher(var.getName()).find()) continue;
                DestinationPoints dp = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(var.getName());
                if (dp != null) {
                    var.setName(dp.getSystemName());
                    isDirty = true;
                    continue;
                }
                log.error("setGuiNames: For conditional '{}' in logix '{}', the referenced Entry Exit Pair, '{}',  does not exist", new Object[]{cName, this.getSystemName(), var.getName()});
                badVariable.add(var);
            }
            if (badVariable.size() > 0) {
                isDirty = true;
                badVariable.forEach(varList::remove);
            }
            if (isDirty) {
                conditional.setStateVariables(varList);
            }
            List<ConditionalAction> actionList = conditional.getCopyOfActions();
            isDirty = false;
            ArrayList<ConditionalAction> badAction = new ArrayList<ConditionalAction>();
            for (ConditionalAction action : actionList) {
                if (action.getType() != Conditional.Action.SET_NXPAIR_ENABLED && action.getType() != Conditional.Action.SET_NXPAIR_DISABLED && action.getType() != Conditional.Action.SET_NXPAIR_SEGMENT || NXUUID.matcher(action.getDeviceName()).find()) continue;
                DestinationPoints dp = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(action.getDeviceName());
                if (dp != null) {
                    action.setDeviceName(dp.getSystemName());
                    isDirty = true;
                    continue;
                }
                log.error("setGuiNames: For conditional '{}' in logix '{}', the referenced Entry Exit Pair, '{}',  does not exist", new Object[]{cName, this.getSystemName(), action.getDeviceName()});
                badAction.add(action);
            }
            if (badAction.size() > 0) {
                isDirty = true;
                badAction.forEach(actionList::remove);
            }
            if (!isDirty) continue;
            conditional.setAction(actionList);
        }
        this._isGuiSet = true;
    }

    private void assembleListenerList() {
        int i = this._listeners.size() - 1;
        while (i >= 0) {
            this.removeListener(this._listeners.get(i));
            --i;
        }
        this._listeners = new ArrayList();
        i = 0;
        while (i < this._conditionalSystemNames.size()) {
            Conditional conditional = this.getConditional(this._conditionalSystemNames.get(i));
            if (conditional != null) {
                List<ConditionalVariable> variableList = conditional.getCopyOfStateVariables();
                block44: for (ConditionalVariable variable : variableList) {
                    int varListenerType = 0;
                    String varName = variable.getName();
                    NamedBeanHandle<?> namedBean = variable.getNamedBean();
                    Conditional.Type varType = variable.getType();
                    int signalAspect = -1;
                    switch (varType) {
                        case SENSOR_ACTIVE: 
                        case SENSOR_INACTIVE: {
                            varListenerType = 1;
                            break;
                        }
                        case TURNOUT_THROWN: 
                        case TURNOUT_CLOSED: {
                            varListenerType = 2;
                            break;
                        }
                        case CONDITIONAL_TRUE: 
                        case CONDITIONAL_FALSE: {
                            varListenerType = 4;
                            break;
                        }
                        case LIGHT_ON: 
                        case LIGHT_OFF: {
                            varListenerType = 3;
                            break;
                        }
                        case MEMORY_EQUALS: 
                        case MEMORY_COMPARE: 
                        case MEMORY_EQUALS_INSENSITIVE: 
                        case MEMORY_COMPARE_INSENSITIVE: {
                            varListenerType = 6;
                            break;
                        }
                        case ROUTE_FREE: 
                        case ROUTE_OCCUPIED: 
                        case ROUTE_ALLOCATED: 
                        case ROUTE_SET: 
                        case TRAIN_RUNNING: {
                            varListenerType = 8;
                            break;
                        }
                        case FAST_CLOCK_RANGE: {
                            varListenerType = 7;
                            varName = "clock";
                            break;
                        }
                        case SIGNAL_HEAD_RED: {
                            varListenerType = 5;
                            signalAspect = 1;
                            break;
                        }
                        case SIGNAL_HEAD_YELLOW: {
                            varListenerType = 5;
                            signalAspect = 4;
                            break;
                        }
                        case SIGNAL_HEAD_GREEN: {
                            varListenerType = 5;
                            signalAspect = 16;
                            break;
                        }
                        case SIGNAL_HEAD_DARK: {
                            varListenerType = 5;
                            signalAspect = 0;
                            break;
                        }
                        case SIGNAL_HEAD_LUNAR: {
                            varListenerType = 5;
                            signalAspect = 64;
                            break;
                        }
                        case SIGNAL_HEAD_FLASHRED: {
                            varListenerType = 5;
                            signalAspect = 2;
                            break;
                        }
                        case SIGNAL_HEAD_FLASHYELLOW: {
                            varListenerType = 5;
                            signalAspect = 8;
                            break;
                        }
                        case SIGNAL_HEAD_FLASHGREEN: {
                            varListenerType = 5;
                            signalAspect = 32;
                            break;
                        }
                        case SIGNAL_HEAD_FLASHLUNAR: {
                            varListenerType = 5;
                            signalAspect = 128;
                            break;
                        }
                        case SIGNAL_HEAD_LIT: 
                        case SIGNAL_HEAD_HELD: {
                            varListenerType = 5;
                            break;
                        }
                        case SIGNAL_MAST_ASPECT_EQUALS: 
                        case SIGNAL_MAST_LIT: 
                        case SIGNAL_MAST_HELD: {
                            varListenerType = 9;
                            break;
                        }
                        case BLOCK_STATUS_EQUALS: {
                            varListenerType = 10;
                            break;
                        }
                        case ENTRYEXIT_ACTIVE: 
                        case ENTRYEXIT_INACTIVE: {
                            varListenerType = 11;
                            break;
                        }
                        default: {
                            if (LRouteTableAction.getLogixInitializer().equals(varName)) break;
                            log.warn("Unhandled conditional variable type: {}", (Object)varType);
                        }
                    }
                    int positionOfListener = this.getPositionOfListener(varListenerType, varType, varName);
                    JmriSimplePropertyListener listener = null;
                    if (positionOfListener == -1) {
                        switch (varListenerType) {
                            case 1: {
                                listener = new JmriTwoStatePropertyListener("KnownState", 1, namedBean, varType, conditional);
                                break;
                            }
                            case 2: {
                                listener = new JmriTwoStatePropertyListener("KnownState", 2, namedBean, varType, conditional);
                                break;
                            }
                            case 4: {
                                listener = new JmriTwoStatePropertyListener("KnownState", 4, namedBean, varType, conditional);
                                break;
                            }
                            case 3: {
                                listener = new JmriTwoStatePropertyListener("KnownState", 3, namedBean, varType, conditional);
                                break;
                            }
                            case 6: {
                                listener = new JmriTwoStatePropertyListener("value", 6, namedBean, varType, conditional);
                                break;
                            }
                            case 8: {
                                listener = new JmriSimplePropertyListener(null, 8, namedBean, varType, conditional);
                                break;
                            }
                            case 7: {
                                listener = new JmriClockPropertyListener("minutes", 7, varName, varType, conditional, variable.getNum1(), variable.getNum2());
                                break;
                            }
                            case 5: {
                                if (signalAspect < 0) {
                                    if (varType == Conditional.Type.SIGNAL_HEAD_LIT) {
                                        listener = new JmriTwoStatePropertyListener("Lit", 5, namedBean, varType, conditional);
                                        break;
                                    }
                                    listener = new JmriTwoStatePropertyListener("Held", 5, namedBean, varType, conditional);
                                    break;
                                }
                                listener = new JmriMultiStatePropertyListener("Appearance", 5, namedBean, varType, conditional, signalAspect);
                                break;
                            }
                            case 9: {
                                if (varType == Conditional.Type.SIGNAL_MAST_LIT) {
                                    listener = new JmriTwoStatePropertyListener("Lit", 9, namedBean, varType, conditional);
                                    break;
                                }
                                if (varType == Conditional.Type.SIGNAL_MAST_HELD) {
                                    listener = new JmriTwoStatePropertyListener("Held", 9, namedBean, varType, conditional);
                                    break;
                                }
                                listener = new JmriTwoStatePropertyListener("Aspect", 9, namedBean, varType, conditional);
                                break;
                            }
                            case 10: {
                                listener = new JmriTwoStatePropertyListener("state", 10, namedBean, varType, conditional);
                                break;
                            }
                            case 11: {
                                listener = new JmriTwoStatePropertyListener("active", 11, namedBean, varType, conditional);
                                break;
                            }
                            default: {
                                if (LRouteTableAction.getLogixInitializer().equals(varName)) continue block44;
                                log.error("Unknown (new) Variable Listener type= {}, for varName= {}, varType= {} in Conditional, {}", new Object[]{varListenerType, varName, varType, this._conditionalSystemNames.get(i)});
                                continue block44;
                            }
                        }
                        this._listeners.add(listener);
                    } else {
                        switch (varListenerType) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 6: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: {
                                listener = this._listeners.get(positionOfListener);
                                listener.addConditional(conditional);
                                break;
                            }
                            case 7: {
                                JmriClockPropertyListener cpl = (JmriClockPropertyListener)this._listeners.get(positionOfListener);
                                cpl.setRange(variable.getNum1(), variable.getNum2());
                                cpl.addConditional(conditional);
                                break;
                            }
                            case 5: {
                                if (signalAspect < 0) {
                                    listener = this._listeners.get(positionOfListener);
                                    listener.addConditional(conditional);
                                    break;
                                }
                                JmriMultiStatePropertyListener mpl = (JmriMultiStatePropertyListener)this._listeners.get(positionOfListener);
                                mpl.addConditional(conditional);
                                mpl.setState(signalAspect);
                                break;
                            }
                            default: {
                                log.error("Unknown (old) Variable Listener type= {}, for varName= {}, varType= {} in Conditional, {}", new Object[]{varListenerType, varName, varType, this._conditionalSystemNames.get(i)});
                            }
                        }
                    }
                    if (varType != Conditional.Type.MEMORY_COMPARE && varType != Conditional.Type.MEMORY_COMPARE_INSENSITIVE) continue;
                    positionOfListener = this.getPositionOfListener(varListenerType, varType, variable.getDataString());
                    if (positionOfListener == -1) {
                        String name = variable.getDataString();
                        try {
                            Memory my = InstanceManager.memoryManagerInstance().provideMemory(name);
                            NamedBeanHandle<Memory> nb = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, my);
                            listener = new JmriTwoStatePropertyListener("value", 6, nb, varType, conditional);
                            this._listeners.add(listener);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            log.error("invalid memory name= \"{}\" in state variable", (Object)name);
                            break;
                        }
                    }
                    listener = this._listeners.get(positionOfListener);
                    listener.addConditional(conditional);
                }
            } else {
                log.error("invalid conditional system name in Logix \"{}\" assembleListenerList DELETING {} from Conditional list.", (Object)this.getSystemName(), (Object)this._conditionalSystemNames.get(i));
                this._conditionalSystemNames.remove(i);
            }
            ++i;
        }
    }

    private int getPositionOfListener(int varListenerType, Conditional.Type varType, String varName) {
        int j = 0;
        while (j < this._listeners.size()) {
            if (varListenerType == this._listeners.get(j).getType() && varName.equals(this._listeners.get(j).getDevName())) {
                if (varListenerType == 5) {
                    if (varType == Conditional.Type.SIGNAL_HEAD_LIT || varType == Conditional.Type.SIGNAL_HEAD_HELD ? varType == this._listeners.get(j).getVarType() : "Appearance".equals(this._listeners.get(j).getPropertyName())) {
                        return j;
                    }
                } else {
                    return j;
                }
            }
            ++j;
        }
        return -1;
    }

    @Override
    public void deActivateLogix() {
        if (this._isActivated) {
            this._isActivated = false;
            int i = this._listeners.size() - 1;
            while (i >= 0) {
                this.removeListener(this._listeners.get(i));
                --i;
            }
        }
    }

    private void startListener(JmriSimplePropertyListener listener) {
        String msg = "(unknown type number " + listener.getType() + ")";
        if (listener.getType() == 7) {
            Timebase tb = InstanceManager.getDefault(Timebase.class);
            tb.addMinuteChangeListener(listener);
        } else {
            NamedBeanHandle<?> namedBeanHandle = listener.getNamedBean();
            if (namedBeanHandle == null) {
                switch (listener.getType()) {
                    case 1: {
                        msg = "sensor";
                        break;
                    }
                    case 2: {
                        msg = "turnout";
                        break;
                    }
                    case 3: {
                        msg = "light";
                        break;
                    }
                    case 4: {
                        msg = "conditional";
                        break;
                    }
                    case 5: {
                        msg = "signalhead";
                        break;
                    }
                    case 9: {
                        msg = "signalmast";
                        break;
                    }
                    case 6: {
                        msg = "memory";
                        break;
                    }
                    case 8: {
                        msg = "warrant";
                        break;
                    }
                    case 10: {
                        msg = "oblock";
                        break;
                    }
                    case 11: {
                        msg = "entry exit";
                        break;
                    }
                    default: {
                        msg = "unknown";
                    }
                }
                log.error("Bad name for {} '{}' when setting up Logix listener [ {} ]", new Object[]{msg, listener.getDevName(), this.getSystemName()});
            } else {
                Object nb = namedBeanHandle.getBean();
                nb.addPropertyChangeListener(listener, namedBeanHandle.getName(), "Logix " + this.getDisplayName());
            }
        }
    }

    private void removeListener(JmriSimplePropertyListener listener) {
        String msg = null;
        try {
            switch (listener.getType()) {
                case 7: {
                    Timebase tb = InstanceManager.getDefault(Timebase.class);
                    tb.removeMinuteChangeListener(listener);
                    return;
                }
                case 11: {
                    DestinationPoints ex = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(listener.getDevName());
                    if (ex == null) {
                        msg = "entryexit";
                        break;
                    }
                    ex.removePropertyChangeListener(listener);
                    return;
                }
                default: {
                    NamedBeanHandle<?> namedBeanHandle = listener.getNamedBean();
                    if (namedBeanHandle == null) {
                        switch (listener.getType()) {
                            case 1: {
                                msg = "sensor";
                                break;
                            }
                            case 2: {
                                msg = "turnout";
                                break;
                            }
                            case 3: {
                                msg = "light";
                                break;
                            }
                            case 4: {
                                msg = "conditional";
                                break;
                            }
                            case 5: {
                                msg = "signalhead";
                                break;
                            }
                            case 9: {
                                msg = "signalmast";
                                break;
                            }
                            case 6: {
                                msg = "memory";
                                break;
                            }
                            case 8: {
                                msg = "warrant";
                                break;
                            }
                            case 10: {
                                msg = "oblock";
                                break;
                            }
                            case 11: {
                                msg = "entry exit";
                                break;
                            }
                            default: {
                                msg = "unknown";
                                break;
                            }
                        }
                        break;
                    }
                    Object nb = namedBeanHandle.getBean();
                    nb.removePropertyChangeListener(listener);
                    return;
                }
            }
        }
        catch (Exception ex) {
            log.error("Bad name for listener on \"{}\": ", (Object)listener.getDevName(), (Object)ex);
        }
        log.error("Bad name for {} listener on \"{}\" when removing", (Object)msg, (Object)listener.getDevName());
    }

    @Override
    public int getState() {
        log.warn("Unexpected call to getState in DefaultLogix.");
        return 1;
    }

    @Override
    public void setState(int state) {
        log.warn("Unexpected call to setState in DefaultLogix.");
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            NamedBean nb = (NamedBean)evt.getOldValue();
            for (JmriSimplePropertyListener listener : this._listeners) {
                if (!nb.equals(listener.getBean())) continue;
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("InUseLogixListener", nb.getBeanType(), this.getDisplayName()), e);
            }
            String cName = "";
            Conditional c = null;
            for (String conditionalSystemName : this._conditionalSystemNames) {
                cName = conditionalSystemName;
                c = this.conditionalManager.getBySystemName(cName);
                if (c == null) continue;
                for (ConditionalAction ca : c.getCopyOfActions()) {
                    if (!nb.equals(ca.getBean())) continue;
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("InUseLogixAction", nb.getBeanType(), this.getDisplayName()), e);
                }
                for (ConditionalVariable v : c.getCopyOfStateVariables()) {
                    if (!nb.equals(v.getBean()) && !nb.equals(v.getNamedBeanData())) continue;
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("InUseLogixVariable", nb.getBeanType(), this.getDisplayName()), e);
                }
            }
        }
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            int i = 0;
            while (i < this.getNumConditionals()) {
                DefaultConditional cdl = (DefaultConditional)this.getConditional(this.getConditionalByNumberOrder(i));
                cdl.getStateVariableList().forEach(variable -> {
                    if (bean.equals(variable.getBean())) {
                        report.add(new NamedBeanUsageReport("ConditionalVariable", cdl, variable.toString()));
                    }
                    if (bean.equals(variable.getNamedBeanData())) {
                        report.add(new NamedBeanUsageReport("ConditionalVariableData", cdl, variable.toString()));
                    }
                });
                cdl.getActionList().forEach(action -> {
                    if (bean.equals(action.getBean())) {
                        boolean triggerType = cdl.getTriggerOnChange();
                        report.add(new NamedBeanUsageReport("ConditionalAction", cdl, action.description(triggerType)));
                    }
                });
                ++i;
            }
        }
        return report;
    }
}

