/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.CheckForNull;
import jmri.ClockControl;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.implementation.AbstractIdTag;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIdTag
extends AbstractIdTag {
    private int currentState = 1;
    private static final Logger log = LoggerFactory.getLogger(DefaultIdTag.class);

    public DefaultIdTag(String systemName) {
        super(systemName);
        this.setWhereLastSeen(null);
    }

    public DefaultIdTag(String systemName, String userName) {
        super(systemName, userName);
        this.setWhereLastSeen(null);
    }

    @Override
    public final void setWhereLastSeen(@CheckForNull Reporter r) {
        Reporter oldWhere = this.whereLastSeen;
        Date oldWhen = this.whenLastSeen;
        this.whereLastSeen = r;
        this.whenLastSeen = r != null ? this.getDateNow() : null;
        this.setCurrentState(r != null ? 3 : 2);
        this.firePropertyChange("whereLastSeen", oldWhere, this.whereLastSeen);
        this.firePropertyChange("whenLastSeen", oldWhen, this.whenLastSeen);
    }

    private Date getDateNow() {
        return InstanceManager.getDefault(IdTagManager.class).isFastClockUsed() ? InstanceManager.getDefault(ClockControl.class).getTime() : Calendar.getInstance().getTime();
    }

    private String getDateElementText(Date date) {
        return DateFormat.getDateTimeInstance(2, 2).format(date);
    }

    private void setCurrentState(int state) {
        try {
            this.setState(state);
        }
        catch (JmriException ex) {
            log.warn("Problem setting state of IdTag {} {}", (Object)this.getSystemName(), (Object)ex.getMessage());
        }
    }

    @Override
    public void setState(int s) throws JmriException {
        this.currentState = s;
    }

    @Override
    public int getState() {
        return this.currentState;
    }

    @Override
    public Element store(boolean storeState) {
        Reporter whereLast;
        String comment;
        Element e = new Element("idtag");
        e.addContent((Content)new Element("systemName").addContent(this.mSystemName));
        String uName = this.getUserName();
        if (uName != null && !uName.isEmpty()) {
            e.addContent((Content)new Element("userName").addContent(uName));
        }
        if ((comment = this.getComment()) != null && !comment.isEmpty()) {
            e.addContent((Content)new Element("comment").addContent(comment));
        }
        if ((whereLast = this.getWhereLastSeen()) != null && storeState) {
            e.addContent((Content)new Element("whereLastSeen").addContent(whereLast.getSystemName()));
        }
        if (this.getWhenLastSeen() != null && storeState) {
            e.addContent((Content)new Element("whenLastSeen").addContent(this.getDateElementText(this.getWhenLastSeen())));
        }
        return e;
    }

    @Override
    public void load(Element e) {
        if (e.getName().equals("idtag")) {
            log.debug("Load IdTag element for {}", (Object)this.getSystemName());
            if (e.getChild("userName") != null) {
                this.setUserName(e.getChild("userName").getText());
            }
            if (e.getChild("comment") != null) {
                this.setComment(e.getChild("comment").getText());
            }
            if (e.getChild("whereLastSeen") != null) {
                try {
                    Reporter r = InstanceManager.getDefault(ReporterManager.class).provideReporter(e.getChild("whereLastSeen").getText());
                    this.setWhereLastSeen(r);
                    this.whenLastSeen = null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.warn("Failed to provide Reporter \"{}\" in load", (Object)e.getChild("whereLastSeen").getText());
                }
            }
            if (e.getChild("whenLastSeen") != null) {
                log.debug("When Last Seen: {}", (Object)e.getChild("whenLastSeen").getText());
                try {
                    this.whenLastSeen = DateFormat.getDateTimeInstance(2, 2).parse(e.getChild("whenLastSeen").getText());
                }
                catch (ParseException ex) {
                    log.warn("Error parsing when last seen: {}", (Object)ex.getMessage());
                    log.warn("Expected format is \"{}\" ", (Object)this.getDateElementText(this.getDateNow()));
                }
            }
        } else {
            log.error("Not an IdTag element: {}", (Object)e.getName());
        }
    }
}

