/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.script.ScriptException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.Timer;
import jmri.AudioManager;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalManager;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LogixManager;
import jmri.Memory;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.Timebase;
import jmri.Turnout;
import jmri.VariableLight;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import jmri.implementation.DefaultConditionalAction;
import jmri.jmrit.Sound;
import jmri.jmrit.audio.AudioListener;
import jmri.jmrit.audio.AudioSource;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.logix.WarrantTableFrame;
import jmri.script.JmriScriptEngineManager;
import jmri.script.ScriptOutput;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConditional
extends AbstractNamedBean
implements Conditional {
    static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.conditional.ConditionalBundle");
    private String _antecedent = "";
    private Conditional.AntecedentOperator _logicType = Conditional.AntecedentOperator.ALL_AND;
    private List<ConditionalVariable> _variableList = new ArrayList<ConditionalVariable>();
    protected List<ConditionalAction> _actionList = new ArrayList<ConditionalAction>();
    private int _currentState = 1;
    private boolean _triggerActionsOnChange = true;
    private static boolean _skipErrorDialog = false;
    private static final Logger log = LoggerFactory.getLogger(DefaultConditional.class);
    private static /* synthetic */ int[] $SWITCH_TABLE$jmri$Conditional$Action;

    public DefaultConditional(String systemName, String userName) {
        super(systemName, userName);
    }

    public DefaultConditional(String systemName) {
        super(systemName);
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameConditional");
    }

    public static int getIndexInTable(int[] table, int entry) {
        int i = 0;
        while (i < table.length) {
            if (entry == table[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public String getAntecedentExpression() {
        return this._antecedent;
    }

    @Override
    public Conditional.AntecedentOperator getLogicType() {
        return this._logicType;
    }

    @Override
    public void setLogicType(Conditional.AntecedentOperator type, String antecedent) {
        this._logicType = type;
        this._antecedent = antecedent;
        this.setState(1);
    }

    @Override
    public boolean getTriggerOnChange() {
        return this._triggerActionsOnChange;
    }

    @Override
    public void setTriggerOnChange(boolean trigger) {
        this._triggerActionsOnChange = trigger;
    }

    @Override
    public void setStateVariables(List<ConditionalVariable> arrayList) {
        log.debug("Conditional \"{}\" ({}) updated ConditionalVariable list.", (Object)this.getUserName(), (Object)this.getSystemName());
        this._variableList = arrayList;
    }

    @Override
    @Nonnull
    public List<ConditionalVariable> getCopyOfStateVariables() {
        ArrayList<ConditionalVariable> variableList = new ArrayList<ConditionalVariable>();
        int i = 0;
        while (i < this._variableList.size()) {
            ConditionalVariable variable = this._variableList.get(i);
            ConditionalVariable clone = new ConditionalVariable();
            clone.setNegation(variable.isNegated());
            clone.setOpern(variable.getOpern());
            clone.setType(variable.getType());
            clone.setName(variable.getName());
            clone.setDataString(variable.getDataString());
            clone.setNum1(variable.getNum1());
            clone.setNum2(variable.getNum2());
            clone.setTriggerActions(variable.doTriggerActions());
            clone.setState(variable.getState());
            clone.setGuiName(variable.getGuiName());
            variableList.add(clone);
            ++i;
        }
        return variableList;
    }

    public List<ConditionalVariable> getStateVariableList() {
        return this._variableList;
    }

    @Override
    public void setAction(List<ConditionalAction> arrayList) {
        this._actionList = arrayList;
    }

    @Override
    @Nonnull
    public List<ConditionalAction> getCopyOfActions() {
        ArrayList<ConditionalAction> actionList = new ArrayList<ConditionalAction>();
        int i = 0;
        while (i < this._actionList.size()) {
            ConditionalAction action = this._actionList.get(i);
            DefaultConditionalAction clone = new DefaultConditionalAction();
            clone.setType(action.getType());
            clone.setOption(action.getOption());
            clone.setDeviceName(action.getDeviceName());
            clone.setActionData(action.getActionData());
            clone.setActionString(action.getActionString());
            actionList.add(clone);
            ++i;
        }
        return actionList;
    }

    public List<ConditionalAction> getActionList() {
        return this._actionList;
    }

    @Override
    public int calculate(boolean enabled, PropertyChangeEvent evt) {
        log.trace("calculate starts for {}", (Object)this.getSystemName());
        if (this._variableList.isEmpty()) {
            this.setState(1);
            return this._currentState;
        }
        boolean result = true;
        switch (this._logicType) {
            case ALL_AND: {
                int i = 0;
                while (i < this._variableList.size() && result) {
                    result = this._variableList.get(i).evaluate();
                    ++i;
                }
                break;
            }
            case ALL_OR: {
                result = false;
                int k = 0;
                while (k < this._variableList.size() && !result) {
                    result = this._variableList.get(k).evaluate();
                    ++k;
                }
                break;
            }
            case MIXED: {
                char[] ch = this._antecedent.toCharArray();
                int n = 0;
                int j = 0;
                while (j < ch.length) {
                    if (ch[j] != ' ') {
                        if (ch[j] == '{' || ch[j] == '[') {
                            ch[j] = 40;
                        } else if (ch[j] == '}' || ch[j] == ']') {
                            ch[j] = 41;
                        }
                        ch[n++] = ch[j];
                    }
                    ++j;
                }
                try {
                    DataPair dp = this.parseCalculate(new String(ch, 0, n), this._variableList);
                    result = dp.result;
                }
                catch (IndexOutOfBoundsException | NumberFormatException | JmriException e) {
                    result = false;
                    log.error("{} parseCalculation error antecedent= {}, ex= {}", new Object[]{this.getDisplayName(), this._antecedent, e, e});
                }
                break;
            }
            default: {
                log.warn("Conditional {} fell through switch in calculate", (Object)this.getSystemName());
            }
        }
        int newState = 2;
        log.debug("Conditional \"{}\" ({}) has calculated its state to be {}. current state is {}. enabled= {}", new Object[]{this.getUserName(), this.getSystemName(), result, this._currentState, enabled});
        if (result) {
            newState = 4;
        }
        log.trace("   enabled starts at {}", (Object)enabled);
        if (enabled && evt != null) {
            enabled = this.wantsToTrigger(evt);
            log.trace("   wantsToTrigger sets enabled to {}", (Object)enabled);
        }
        if (this._triggerActionsOnChange && newState == this._currentState) {
            enabled = false;
            log.trace("   _triggerActionsOnChange sets enabled to false");
        }
        this.setState(newState);
        if (enabled) {
            this.takeActionIfNeeded();
        }
        return this._currentState;
    }

    boolean wantsToTrigger(PropertyChangeEvent evt) {
        try {
            String sysName = ((NamedBean)evt.getSource()).getSystemName();
            String userName = ((NamedBean)evt.getSource()).getUserName();
            int i = 0;
            while (i < this._variableList.size()) {
                if (sysName.equals(this._variableList.get(i).getName())) {
                    return this._variableList.get(i).doTriggerActions();
                }
                ++i;
            }
            if (userName != null) {
                i = 0;
                while (i < this._variableList.size()) {
                    if (userName.equals(this._variableList.get(i).getName())) {
                        return this._variableList.get(i).doTriggerActions();
                    }
                    ++i;
                }
            }
        }
        catch (ClassCastException classCastException) {
            log.error("{} PropertyChangeEvent source of unexpected type: {}", (Object)this.getDisplayName(), (Object)evt);
        }
        return true;
    }

    @Override
    public String validateAntecedent(String ant, List<ConditionalVariable> variableList) {
        char[] ch = ant.toCharArray();
        int n = 0;
        int j = 0;
        while (j < ch.length) {
            if (ch[j] != ' ') {
                if (ch[j] == '{' || ch[j] == '[') {
                    ch[j] = 40;
                } else if (ch[j] == '}' || ch[j] == ']') {
                    ch[j] = 41;
                }
                ch[n++] = ch[j];
            }
            ++j;
        }
        int count = 0;
        int j2 = 0;
        while (j2 < n) {
            if (ch[j2] == '(') {
                ++count;
            }
            if (ch[j2] == ')') {
                --count;
            }
            ++j2;
        }
        if (count > 0) {
            return MessageFormat.format(rbx.getString("ParseError7"), Character.valueOf(')'));
        }
        if (count < 0) {
            return MessageFormat.format(rbx.getString("ParseError7"), Character.valueOf('('));
        }
        try {
            DataPair dp = this.parseCalculate(new String(ch, 0, n), variableList);
            if (n != dp.indexCount) {
                return MessageFormat.format(rbx.getString("ParseError4"), Character.valueOf(ch[dp.indexCount - 1]));
            }
            int index = dp.argsUsed.nextClearBit(0);
            if (index >= 0 && index < variableList.size()) {
                return MessageFormat.format(rbx.getString("ParseError5"), variableList.size(), index + 1);
            }
        }
        catch (IndexOutOfBoundsException | NumberFormatException | JmriException nfe) {
            return String.valueOf(rbx.getString("ParseError6")) + nfe.getMessage();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DataPair parseCalculate(String s, List<ConditionalVariable> variableList) throws JmriException {
        s = s.toUpperCase();
        BitSet argsUsed = new BitSet(this._variableList.size());
        DataPair dp = null;
        boolean leftArg = false;
        boolean rightArg = false;
        int oper = 4;
        int k = -1;
        int i = 0;
        if (s.charAt(i) == '(') {
            dp = this.parseCalculate(s.substring(++i), variableList);
            leftArg = dp.result;
            i += dp.indexCount;
            argsUsed.or(dp.argsUsed);
        } else if (s.charAt(i) == 'R') {
            try {
                k = Integer.parseInt(String.valueOf(s.substring(i + 1, i + 3)));
                i += 2;
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                k = Integer.parseInt(String.valueOf(s.charAt(++i)));
            }
            leftArg = variableList.get(k - 1).evaluate();
            if (variableList.get(k - 1).isNegated()) {
                leftArg = !leftArg;
            }
            ++i;
            argsUsed.set(k - 1);
        } else {
            if (!"NOT".equals(s.substring(i, i + 3))) {
                throw new JmriException(MessageFormat.format(rbx.getString("ParseError9"), s));
            }
            if (s.charAt(i += 3) == '(') {
                dp = this.parseCalculate(s.substring(++i), variableList);
                leftArg = dp.result;
                i += dp.indexCount;
                argsUsed.or(dp.argsUsed);
            } else {
                if (s.charAt(i) != 'R') {
                    throw new JmriException(MessageFormat.format(rbx.getString("ParseError1"), s.substring(i)));
                }
                try {
                    k = Integer.parseInt(String.valueOf(s.substring(i + 1, i + 3)));
                    i += 2;
                }
                catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                    k = Integer.parseInt(String.valueOf(s.charAt(++i)));
                }
                leftArg = variableList.get(k - 1).evaluate();
                if (variableList.get(k - 1).isNegated()) {
                    leftArg = !leftArg;
                }
                ++i;
                argsUsed.set(k - 1);
            }
            leftArg = !leftArg;
        }
        while (i < s.length()) {
            if (s.charAt(i) != ')') {
                if ("AND".equals(s.substring(i, i + 3))) {
                    i += 3;
                    oper = 1;
                } else {
                    if (!"OR".equals(s.substring(i, i + 2))) {
                        throw new JmriException(MessageFormat.format(rbx.getString("ParseError2"), s.substring(i)));
                    }
                    i += 2;
                    oper = 5;
                }
                if (s.charAt(i) == '(') {
                    dp = this.parseCalculate(s.substring(++i), variableList);
                    rightArg = dp.result;
                    i += dp.indexCount;
                    argsUsed.or(dp.argsUsed);
                } else if (s.charAt(i) == 'R') {
                    try {
                        k = Integer.parseInt(String.valueOf(s.substring(i + 1, i + 3)));
                        i += 2;
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                        k = Integer.parseInt(String.valueOf(s.charAt(++i)));
                    }
                    rightArg = variableList.get(k - 1).evaluate();
                    if (variableList.get(k - 1).isNegated()) {
                        rightArg = !rightArg;
                    }
                    ++i;
                    argsUsed.set(k - 1);
                } else {
                    if (!"NOT".equals(s.substring(i, i + 3))) {
                        throw new JmriException(MessageFormat.format(rbx.getString("ParseError9"), s.substring(i)));
                    }
                    if (s.charAt(i += 3) == '(') {
                        dp = this.parseCalculate(s.substring(++i), variableList);
                        rightArg = dp.result;
                        i += dp.indexCount;
                        argsUsed.or(dp.argsUsed);
                    } else {
                        if (s.charAt(i) != 'R') {
                            throw new JmriException(MessageFormat.format(rbx.getString("ParseError3"), s.substring(i)));
                        }
                        try {
                            k = Integer.parseInt(String.valueOf(s.substring(i + 1, i + 3)));
                            i += 2;
                        }
                        catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                            k = Integer.parseInt(String.valueOf(s.charAt(++i)));
                        }
                        rightArg = variableList.get(k - 1).evaluate();
                        if (variableList.get(k - 1).isNegated()) {
                            rightArg = !rightArg;
                        }
                        ++i;
                        argsUsed.set(k - 1);
                    }
                    boolean bl = rightArg = !rightArg;
                }
                if (oper == 1) {
                    leftArg = leftArg && rightArg;
                    continue;
                }
                if (oper != 5) continue;
                leftArg = leftArg || rightArg;
                continue;
            }
            ++i;
            break;
        }
        dp = new DataPair();
        dp.result = leftArg;
        dp.indexCount = i;
        dp.argsUsed = argsUsed;
        return dp;
    }

    /*
     * Unable to fully structure code
     */
    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    private void takeActionIfNeeded() {
        if (DefaultConditional.log.isTraceEnabled()) {
            DefaultConditional.log.trace("takeActionIfNeeded starts for {}", (Object)this.getSystemName());
        }
        actionCount = 0;
        actionNeeded = 0;
        act = 0;
        state = 0;
        errorList = new ArrayList<String>();
        currentState = this._currentState;
        i = 0;
        while (i < this._actionList.size()) {
            action = this._actionList.get(i);
            neededAction = actionNeeded;
            option = action.getOption();
            if (DefaultConditional.log.isTraceEnabled()) {
                DefaultConditional.log.trace(" takeActionIfNeeded considers action {} with currentState: {} and option: {}", new Object[]{i, currentState, option});
            }
            if (!(currentState == 4 && option == 1 || currentState == 2 && option == 2) && option != 3) ** GOTO lbl606
            ++actionNeeded;
            h = null;
            f = null;
            x = null;
            lgt = null;
            w = null;
            nb = null;
            if (action.getNamedBean() != null) {
                nb = action.getNamedBean().getBean();
            }
            value = 0;
            timer = null;
            type = action.getType();
            devName = this.getDeviceName(action);
            if (devName == null) {
                errorList.add("invalid memory name in action - " + action);
            } else {
                if (DefaultConditional.log.isDebugEnabled()) {
                    DefaultConditional.log.debug("getDeviceName()={} devName= {}", (Object)action.getDeviceName(), (Object)devName);
                }
                block5 : switch (DefaultConditional.$SWITCH_TABLE$jmri$Conditional$Action()[type.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        t = nb;
                        if (t == null) {
                            errorList.add("invalid turnout name in action - " + action.getDeviceName());
                            break;
                        }
                        act = action.getActionData();
                        if (act == 8) {
                            state = t.getKnownState();
                            act = state == 2 ? 4 : 2;
                        }
                        t.setCommandedState(act);
                        ++actionCount;
                        break;
                    }
                    case 21: {
                        action.stopTimer();
                    }
                    case 17: {
                        if (!action.isTimerActive()) {
                            timer = action.getTimer();
                            if (timer == null) {
                                action.setListener(new TimeTurnout(i));
                                timer = new Timer(2000, action.getListener());
                                timer.setRepeats(true);
                            }
                            if ((value = this.getMillisecondValue(action)) < 0) break;
                            timer.setInitialDelay(value);
                            action.setTimer(timer);
                            action.startTimer();
                            ++actionCount;
                            break;
                        }
                        DefaultConditional.log.warn("timer already active on request to start delayed turnout action - {}", (Object)devName);
                        break;
                    }
                    case 22: {
                        cmg = InstanceManager.getDefault(ConditionalManager.class);
                        iter = cmg.getNamedBeanSet().iterator();
                        while (iter.hasNext()) {
                            sname = ((Conditional)iter.next()).getSystemName();
                            c = cmg.getBySystemName(sname);
                            if (c == null) {
                                errorList.add("Conditional null during cancel turnout timers for " + action.getDeviceName());
                                continue;
                            }
                            c.cancelTurnoutTimer(devName);
                            ++actionCount;
                        }
                        break;
                    }
                    case 18: {
                        tl = nb;
                        if (tl == null) {
                            errorList.add("invalid turnout name in action - " + action.getDeviceName());
                            break;
                        }
                        act = action.getActionData();
                        if (act == 8) {
                            act = tl.getLocked(1) != false ? 0 : 1;
                        }
                        if (act == 1) {
                            tl.setLocked(3, true);
                        } else if (act == 0) {
                            tl.setLocked(3, false);
                        }
                        ++actionCount;
                        break;
                    }
                    case 3: {
                        h = nb;
                        if (h == null) {
                            errorList.add("invalid Signal Head name in action - " + action.getDeviceName());
                            break;
                        }
                        h.setAppearance(action.getActionData());
                        ++actionCount;
                        break;
                    }
                    case 4: {
                        h = nb;
                        if (h == null) {
                            errorList.add("invalid Signal Head name in action - " + action.getDeviceName());
                            break;
                        }
                        h.setHeld(true);
                        ++actionCount;
                        break;
                    }
                    case 5: {
                        h = nb;
                        if (h == null) {
                            errorList.add("invalid Signal Head name in action - " + action.getDeviceName());
                            break;
                        }
                        h.setHeld(false);
                        ++actionCount;
                        break;
                    }
                    case 6: {
                        h = nb;
                        if (h == null) {
                            errorList.add("invalid Signal Head name in action - " + action.getDeviceName());
                            break;
                        }
                        h.setLit(false);
                        ++actionCount;
                        break;
                    }
                    case 7: {
                        h = nb;
                        if (h == null) {
                            errorList.add("invalid Signal Head name in action - " + action.getDeviceName());
                            break;
                        }
                        h.setLit(true);
                        ++actionCount;
                        break;
                    }
                    case 8: {
                        r = nb;
                        if (r == null) {
                            errorList.add("invalid Route name in action - " + action.getDeviceName());
                            break;
                        }
                        r.setRoute();
                        ++actionCount;
                        break;
                    }
                    case 9: {
                        sn = nb;
                        if (sn == null) {
                            errorList.add("invalid Sensor name in action - " + action.getDeviceName());
                            break;
                        }
                        act = action.getActionData();
                        if (act == 8) {
                            state = sn.getState();
                            act = state == 2 ? 4 : 2;
                        }
                        try {
                            sn.setKnownState(act);
                            ++actionCount;
                        }
                        catch (JmriException v0) {
                            DefaultConditional.log.warn("Exception setting Sensor {} in action", (Object)devName);
                        }
                        break;
                    }
                    case 19: {
                        action.stopTimer();
                    }
                    case 10: {
                        if (!action.isTimerActive()) {
                            timer = action.getTimer();
                            if (timer == null) {
                                action.setListener(new TimeSensor(i));
                                timer = new Timer(2000, action.getListener());
                                timer.setRepeats(true);
                            }
                            if ((value = this.getMillisecondValue(action)) < 0) break;
                            timer.setInitialDelay(value);
                            action.setTimer(timer);
                            action.startTimer();
                            ++actionCount;
                            break;
                        }
                        DefaultConditional.log.warn("timer already active on request to start delayed sensor action - {}", (Object)devName);
                        break;
                    }
                    case 20: {
                        cm = InstanceManager.getDefault(ConditionalManager.class);
                        itr = cm.getNamedBeanSet().iterator();
                        while (itr.hasNext()) {
                            sname = ((Conditional)itr.next()).getSystemName();
                            c = cm.getBySystemName(sname);
                            if (c == null) {
                                errorList.add("Conditional null during cancel sensor timers for " + action.getDeviceName());
                                continue;
                            }
                            c.cancelSensorTimer(devName);
                            ++actionCount;
                        }
                        break;
                    }
                    case 11: {
                        lgt = nb;
                        if (lgt == null) {
                            errorList.add("invalid light name in action - " + action.getDeviceName());
                            break;
                        }
                        act = action.getActionData();
                        if (act == 8) {
                            state = lgt.getState();
                            act = state == 2 ? 4 : 2;
                        }
                        lgt.setState(act);
                        ++actionCount;
                        break;
                    }
                    case 27: {
                        lgt = nb;
                        if (lgt == null) {
                            errorList.add("invalid light name in action - " + action.getDeviceName());
                            break;
                        }
                        try {
                            value = this.getIntegerValue(action);
                            if (value < 0) break;
                            if (lgt instanceof VariableLight) {
                                ((VariableLight)lgt).setTargetIntensity((double)value / 100.0);
                            } else {
                                lgt.setState((double)value > 0.5 ? 2 : 4);
                            }
                            ++actionCount;
                        }
                        catch (IllegalArgumentException v1) {
                            errorList.add("Exception in set light intensity action - " + action.getDeviceName());
                        }
                        break;
                    }
                    case 28: {
                        lgt = nb;
                        if (lgt == null) {
                            errorList.add("invalid light name in action - " + action.getDeviceName());
                            break;
                        }
                        try {
                            value = this.getIntegerValue(action);
                            if (value < 0) break;
                            if (lgt instanceof VariableLight) {
                                ((VariableLight)lgt).setTransitionTime(value);
                            }
                            ++actionCount;
                        }
                        catch (IllegalArgumentException v2) {
                            errorList.add("Exception in set light transition time action - " + action.getDeviceName());
                        }
                        break;
                    }
                    case 12: {
                        m = nb;
                        if (m == null) {
                            errorList.add("invalid memory name in action - " + action.getDeviceName());
                            break;
                        }
                        m.setValue(action.getActionString());
                        ++actionCount;
                        break;
                    }
                    case 26: {
                        mFrom = nb;
                        if (mFrom == null) {
                            errorList.add("invalid memory name in action - " + action.getDeviceName());
                            break;
                        }
                        mTo = DefaultConditional.getMemory(action.getActionString());
                        if (mTo == null) {
                            errorList.add("invalid memory name in action - " + action.getActionString());
                            break;
                        }
                        mTo.setValue(mFrom.getValue());
                        ++actionCount;
                        break;
                    }
                    case 13: {
                        x = InstanceManager.getDefault(LogixManager.class).getLogix(devName);
                        if (x == null) {
                            errorList.add("invalid logix name in action - " + action.getDeviceName());
                            break;
                        }
                        x.setEnabled(true);
                        ++actionCount;
                        break;
                    }
                    case 14: {
                        x = InstanceManager.getDefault(LogixManager.class).getLogix(devName);
                        if (x == null) {
                            errorList.add("invalid logix name in action - " + action.getDeviceName());
                            break;
                        }
                        x.setEnabled(false);
                        ++actionCount;
                        break;
                    }
                    case 15: {
                        path = this.getActionString(action);
                        if (path.equals("")) break;
                        sound = action.getSound();
                        if (sound == null) {
                            try {
                                sound = new Sound(path);
                            }
                            catch (NullPointerException v3) {
                                errorList.add("invalid path to sound: " + path);
                            }
                        }
                        if (sound != null) {
                            sound.play();
                        }
                        ++actionCount;
                        break;
                    }
                    case 16: {
                        if (this.getActionString(action).equals("")) break;
                        JmriScriptEngineManager.getDefault().runScript(new File(FileUtil.getExternalFilename(this.getActionString(action))));
                        ++actionCount;
                        break;
                    }
                    case 23: {
                        date = InstanceManager.getDefault(Timebase.class).getTime();
                        date.setHours(action.getActionData() / 60);
                        date.setMinutes(action.getActionData() - action.getActionData() / 60 * 60);
                        date.setSeconds(0);
                        InstanceManager.getDefault(Timebase.class).userSetTime(date);
                        ++actionCount;
                        break;
                    }
                    case 24: {
                        InstanceManager.getDefault(Timebase.class).setRun(true);
                        ++actionCount;
                        break;
                    }
                    case 25: {
                        InstanceManager.getDefault(Timebase.class).setRun(false);
                        ++actionCount;
                        break;
                    }
                    case 29: {
                        audio = InstanceManager.getDefault(AudioManager.class).getAudio(devName);
                        if (audio == null) break;
                        if (audio.getSubType() == 'S') {
                            audioSource = (AudioSource)audio;
                            switch (action.getActionData()) {
                                case 64: {
                                    audioSource.play();
                                    break block5;
                                }
                                case 65: {
                                    audioSource.stop();
                                    break block5;
                                }
                                case 66: {
                                    audioSource.togglePlay();
                                    break block5;
                                }
                                case 67: {
                                    audioSource.pause();
                                    break block5;
                                }
                                case 68: {
                                    audioSource.resume();
                                    break block5;
                                }
                                case 69: {
                                    audioSource.togglePause();
                                    break block5;
                                }
                                case 70: {
                                    audioSource.rewind();
                                    break block5;
                                }
                                case 71: {
                                    audioSource.fadeIn();
                                    break block5;
                                }
                                case 72: {
                                    audioSource.fadeOut();
                                    break block5;
                                }
                                case 73: {
                                    audioSource.resetCurrentPosition();
                                    break block5;
                                }
                            }
                            break;
                        }
                        if (audio.getSubType() != 'L') break;
                        audioListener = (AudioListener)audio;
                        switch (action.getActionData()) {
                            case 73: {
                                audioListener.resetCurrentPosition();
                                break block5;
                            }
                        }
                        break;
                    }
                    case 30: {
                        if (this.getActionString(action).isEmpty()) break;
                        ScriptOutput.writeScript(this.getActionString(action));
                        se = JmriScriptEngineManager.getDefault().getEngine("jython");
                        if (se != null) {
                            try {
                                JmriScriptEngineManager.getDefault().eval(this.getActionString(action), se);
                            }
                            catch (ScriptException ex) {
                                DefaultConditional.log.error("Error executing script:", (Throwable)ex);
                            }
                        } else {
                            DefaultConditional.log.error("Error getting default ScriptEngine");
                        }
                        ++actionCount;
                        break;
                    }
                    case 31: {
                        w = nb;
                        if (w == null) {
                            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
                            break;
                        }
                        msg = w.allocateRoute(false, null);
                        if (msg != null) {
                            DefaultConditional.log.info("Warrant {} - {}", (Object)action.getDeviceName(), (Object)msg);
                        }
                        ++actionCount;
                        break;
                    }
                    case 32: {
                        w = nb;
                        if (w == null) {
                            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
                            break;
                        }
                        w.deAllocate();
                        ++actionCount;
                        break;
                    }
                    case 33: {
                        w = nb;
                        if (w == null) {
                            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
                            break;
                        }
                        msg = w.setRoute(false, null);
                        if (msg != null) {
                            DefaultConditional.log.info("Warrant {} unable to Set Route - {}", (Object)action.getDeviceName(), (Object)msg);
                        }
                        ++actionCount;
                        break;
                    }
                    case 40: {
                        DefaultConditional.log.info("Set warrant Throttle Factor deprecated - Use Warrrant Preferences");
                        break;
                    }
                    case 37: {
                        w = nb;
                        if (w == null) {
                            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
                            break;
                        }
                        if (!w.getSpeedUtil().setAddress(this.getActionString(action))) {
                            errorList.add("invalid train ID in action - " + action.getDeviceName());
                        }
                        ++actionCount;
                        break;
                    }
                    case 38: {
                        w = nb;
                        if (w == null) {
                            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
                            break;
                        }
                        w.setTrainName(this.getActionString(action));
                        ++actionCount;
                        break;
                    }
                    case 34: {
                        w = nb;
                        if (w == null) {
                            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
                            break;
                        }
                        frame = WarrantTableFrame.getDefault();
                        err = frame.runTrain(w, 2);
                        if (err != null) {
                            errorList.add("runAutoTrain error - " + err);
                            w.stopWarrant(true, true);
                        }
                        ++actionCount;
                        break;
                    }
                    case 35: {
                        w = nb;
                        if (w == null) {
                            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
                            break;
                        }
                        err = w.setRoute(false, null);
                        if (err == null) {
                            err = w.setRunMode(3, null, null, null, false);
                        }
                        if (err != null) {
                            errorList.add("runManualTrain error - " + err);
                        }
                        ++actionCount;
                        break;
                    }
                    case 36: {
                        w = nb;
                        if (w == null) {
                            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
                            break;
                        }
                        if (!w.controlRunTrain(action.getActionData())) {
                            DefaultConditional.log.info("Train {} not running  - {}", (Object)w.getSpeedUtil().getRosterId(), (Object)devName);
                        }
                        ++actionCount;
                        break;
                    }
                    case 39: {
                        f = nb;
                        if (f == null) {
                            errorList.add("invalid Signal Mast name in action - " + action.getDeviceName());
                            break;
                        }
                        f.setAspect(this.getActionString(action));
                        ++actionCount;
                        break;
                    }
                    case 41: {
                        f = nb;
                        if (f == null) {
                            errorList.add("invalid Signal Mast name in action - " + action.getDeviceName());
                            break;
                        }
                        f.setHeld(true);
                        ++actionCount;
                        break;
                    }
                    case 42: {
                        f = nb;
                        if (f == null) {
                            errorList.add("invalid Signal Mast name in action - " + action.getDeviceName());
                            break;
                        }
                        f.setHeld(false);
                        ++actionCount;
                        break;
                    }
                    case 43: {
                        f = nb;
                        if (f == null) {
                            errorList.add("invalid Signal Head name in action - " + action.getDeviceName());
                            break;
                        }
                        f.setLit(false);
                        ++actionCount;
                        break;
                    }
                    case 44: {
                        f = nb;
                        if (f == null) {
                            errorList.add("invalid Signal Head name in action - " + action.getDeviceName());
                            break;
                        }
                        f.setLit(true);
                        ++actionCount;
                        break;
                    }
                    case 45: {
                        b = nb;
                        if (b == null) {
                            errorList.add("invalid Block name in action - " + action.getDeviceName());
                            break;
                        }
                        b.setValue(this.getActionString(action));
                        ++actionCount;
                        break;
                    }
                    case 46: {
                        b = nb;
                        if (b == null) {
                            errorList.add("invalid Block name in action - " + action.getDeviceName());
                            break;
                        }
                        b.setError(true);
                        ++actionCount;
                        break;
                    }
                    case 47: {
                        b = nb;
                        if (b == null) {
                            errorList.add("invalid Block name in action - " + action.getDeviceName());
                            break;
                        }
                        b.setError(false);
                        break;
                    }
                    case 48: {
                        b = nb;
                        if (b == null) {
                            errorList.add("invalid Block name in action - " + action.getDeviceName());
                            break;
                        }
                        b.deAllocate(null);
                        ++actionCount;
                        break;
                    }
                    case 49: {
                        b = nb;
                        if (b == null) {
                            errorList.add("invalid Block name in action - " + action.getDeviceName());
                            break;
                        }
                        b.setOutOfService(true);
                        ++actionCount;
                        break;
                    }
                    case 50: {
                        b = nb;
                        if (b == null) {
                            errorList.add("invalid Block name in action - " + action.getDeviceName());
                            break;
                        }
                        b.setOutOfService(false);
                        ++actionCount;
                        break;
                    }
                    case 51: {
                        dp = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(devName);
                        if (dp == null) {
                            errorList.add("Invalid NX Pair name in action - " + action.getDeviceName());
                            break;
                        }
                        dp.setEnabled(true);
                        ++actionCount;
                        break;
                    }
                    case 52: {
                        dp = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(devName);
                        if (dp == null) {
                            errorList.add("Invalid NX Pair name in action - " + action.getDeviceName());
                            break;
                        }
                        dp.setEnabled(false);
                        ++actionCount;
                        break;
                    }
                    case 53: {
                        dp = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(devName);
                        if (dp == null) {
                            errorList.add("Invalid NX Pair name in action - " + action.getDeviceName());
                            break;
                        }
                        InstanceManager.getDefault(EntryExitPairs.class).setSingleSegmentRoute(devName);
                        ++actionCount;
                        break;
                    }
                    default: {
                        DefaultConditional.log.warn("takeActionIfNeeded drops through switch statement for action {} of {}", (Object)i, (Object)this.getSystemName());
                    }
                }
lbl606:
                // 118 sources

                if (DefaultConditional.log.isDebugEnabled()) {
                    DefaultConditional.log.debug("Global state= {} Local state= {} - Action {} taken for action = {} {} for device {}", new Object[]{this._currentState, currentState, actionNeeded > neededAction ? "WAS" : "NOT", action.getTypeString(), action.getActionString(), action.getDeviceName()});
                }
            }
            ++i;
        }
        if (errorList.size() > 0) {
            i = 0;
            while (i < errorList.size()) {
                DefaultConditional.log.error("{} - {}", (Object)this.getDisplayName(), errorList.get(i));
                ++i;
            }
            if (!GraphicsEnvironment.isHeadless()) {
                Toolkit.getDefaultToolkit().beep();
                if (!DefaultConditional._skipErrorDialog) {
                    new ErrorDialog(errorList, this);
                }
            }
        }
        if (DefaultConditional.log.isDebugEnabled()) {
            DefaultConditional.log.debug("Conditional \"{}\" ({} has {} actions and has executed {} actions of {} actions needed on state change to {}", new Object[]{this.getUserName(), this.getSystemName(), this._actionList.size(), actionCount, actionNeeded, currentState});
        }
    }

    private String getDeviceName(ConditionalAction action) {
        String devName = action.getDeviceName();
        if (devName != null && devName.length() > 0 && devName.charAt(0) == '@') {
            String memName = devName.substring(1);
            Memory m = DefaultConditional.getMemory(memName);
            if (m == null) {
                log.error("{} invalid memory name in action - {}", (Object)this.getDisplayName(), (Object)devName);
                return null;
            }
            devName = (String)m.getValue();
        }
        return devName;
    }

    private String getActionString(ConditionalAction action) {
        String devAction = action.getActionString();
        if (devAction != null && devAction.length() > 0 && devAction.charAt(0) == '@') {
            String memName = devAction.substring(1);
            Memory m = DefaultConditional.getMemory(memName);
            if (m == null) {
                log.error("{} action \"{}\" has invalid memory name in actionString - {}", new Object[]{this.getDisplayName(), action.getDeviceName(), action.getActionString()});
                return "";
            }
            devAction = (String)m.getValue();
        }
        return devAction;
    }

    private static Memory getMemory(String name) {
        return InstanceManager.memoryManagerInstance().getMemory(name);
    }

    int getIntegerValue(ConditionalAction action) {
        String sNumber = action.getActionString();
        int time = 0;
        try {
            time = Integer.parseInt(sNumber);
        }
        catch (NumberFormatException numberFormatException) {
            Memory mem;
            if (sNumber.charAt(0) == '@') {
                sNumber = sNumber.substring(1);
            }
            if ((mem = DefaultConditional.getMemory(sNumber)) == null) {
                log.error("invalid memory name for action time variable - {}, for Action \"{}\", in Conditional \"{}\" ({})", new Object[]{sNumber, action.getTypeString(), this.getUserName(), this.getSystemName()});
                return -1;
            }
            try {
                time = Integer.parseInt((String)mem.getValue());
            }
            catch (NumberFormatException numberFormatException2) {
                log.error("invalid action number variable from memory, \"{}\" ({}), value = {}, for Action \"{}\", in Conditional \"{}\" ({})", new Object[]{this.getUserName(), mem.getSystemName(), mem.getValue(), action.getTypeString(), this.getUserName(), this.getSystemName()});
                return -1;
            }
        }
        return time;
    }

    int getMillisecondValue(ConditionalAction action) {
        float time;
        block6: {
            String sNumber = action.getActionString();
            time = 0.0f;
            try {
                time = Float.parseFloat(sNumber);
            }
            catch (NumberFormatException numberFormatException) {
                Memory mem;
                if (sNumber.charAt(0) == '@') {
                    sNumber = sNumber.substring(1);
                }
                if ((mem = DefaultConditional.getMemory(sNumber)) == null) {
                    log.error("invalid memory name for action time variable - {}, for Action \"{}\", in Conditional \"{}\" ({})", new Object[]{sNumber, action.getTypeString(), this.getUserName(), this.getSystemName()});
                    return -1;
                }
                try {
                    time = Float.parseFloat((String)mem.getValue());
                }
                catch (NumberFormatException numberFormatException2) {
                    time = -1.0f;
                }
                if (!(time <= 0.0f)) break block6;
                log.error("invalid Millisecond value from memory, \"{}\" ({}), value = {}, for Action \"{}\", in Conditional \"{}\" ({})", new Object[]{this.getUserName(), mem.getSystemName(), mem.getValue(), action.getTypeString(), this.getUserName(), this.getSystemName()});
            }
        }
        return (int)(time * 1000.0f);
    }

    @Override
    public void cancelSensorTimer(String sname) {
        int i = 0;
        while (i < this._actionList.size()) {
            ConditionalAction action = this._actionList.get(i);
            if ((action.getType() == Conditional.Action.DELAYED_SENSOR || action.getType() == Conditional.Action.RESET_DELAYED_SENSOR) && action.isTimerActive()) {
                String devName = this.getDeviceName(action);
                if (devName.equals(sname)) {
                    action.stopTimer();
                } else {
                    Sensor sn = InstanceManager.sensorManagerInstance().getSensor(devName);
                    if (sn == null) {
                        log.error("{} Unknown sensor *{} in cancelSensorTimer.", (Object)this.getDisplayName(), (Object)action.getDeviceName());
                    } else if (sname.equals(sn.getSystemName()) || sname.equals(sn.getUserName())) {
                        action.stopTimer();
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void cancelTurnoutTimer(String sname) {
        int i = 0;
        while (i < this._actionList.size()) {
            ConditionalAction action = this._actionList.get(i);
            if ((action.getType() == Conditional.Action.DELAYED_TURNOUT || action.getType() == Conditional.Action.RESET_DELAYED_TURNOUT) && action.isTimerActive()) {
                String devName = this.getDeviceName(action);
                if (devName.equals(sname)) {
                    action.stopTimer();
                } else {
                    Turnout tn = InstanceManager.turnoutManagerInstance().getTurnout(devName);
                    if (tn == null) {
                        log.error("{} Unknown turnout *{} in cancelTurnoutTimer.", (Object)this.getDisplayName(), (Object)action.getDeviceName());
                    } else if (sname.equals(tn.getSystemName()) || sname.equals(tn.getUserName())) {
                        action.stopTimer();
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public int getState() {
        return this._currentState;
    }

    @Override
    public void setState(int state) {
        if (this._currentState != state) {
            int oldState = this._currentState;
            this._currentState = state;
            this.firePropertyChange("KnownState", oldState, this._currentState);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$jmri$Conditional$Action() {
        if ($SWITCH_TABLE$jmri$Conditional$Action != null) {
            return $SWITCH_TABLE$jmri$Conditional$Action;
        }
        int[] nArray = new int[Conditional.Action.values().length];
        try {
            nArray[Conditional.Action.ALLOCATE_WARRANT_ROUTE.ordinal()] = 31;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.AUTO_RUN_WARRANT.ordinal()] = 34;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.CANCEL_SENSOR_TIMERS.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.CANCEL_TURNOUT_TIMERS.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.CLEAR_BLOCK_ERROR.ordinal()] = 47;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.CLEAR_SIGNALMAST_HELD.ordinal()] = 42;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.CLEAR_SIGNAL_HELD.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.CONTROL_AUDIO.ordinal()] = 29;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.CONTROL_TRAIN.ordinal()] = 36;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.COPY_MEMORY.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.DEALLOCATE_BLOCK.ordinal()] = 48;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.DEALLOCATE_WARRANT_ROUTE.ordinal()] = 32;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.DELAYED_SENSOR.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.DELAYED_TURNOUT.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.DISABLE_LOGIX.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.ENABLE_LOGIX.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.JYTHON_COMMAND.ordinal()] = 30;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.LOCK_TURNOUT.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.MANUAL_RUN_WARRANT.ordinal()] = 35;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.PLAY_SOUND.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.RESET_DELAYED_SENSOR.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.RESET_DELAYED_TURNOUT.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.RUN_SCRIPT.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_BLOCK_ERROR.ordinal()] = 46;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_BLOCK_IN_SERVICE.ordinal()] = 50;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_BLOCK_OUT_OF_SERVICE.ordinal()] = 49;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_BLOCK_VALUE.ordinal()] = 45;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_FAST_CLOCK_TIME.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_LIGHT.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_LIGHT_INTENSITY.ordinal()] = 27;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_LIGHT_TRANSITION_TIME.ordinal()] = 28;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_MEMORY.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_NXPAIR_DISABLED.ordinal()] = 52;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_NXPAIR_ENABLED.ordinal()] = 51;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_NXPAIR_SEGMENT.ordinal()] = 53;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_ROUTE_TURNOUTS.ordinal()] = 33;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_SENSOR.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_SIGNALMAST_ASPECT.ordinal()] = 39;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_SIGNALMAST_DARK.ordinal()] = 43;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_SIGNALMAST_HELD.ordinal()] = 41;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_SIGNALMAST_LIT.ordinal()] = 44;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_SIGNAL_APPEARANCE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_SIGNAL_DARK.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_SIGNAL_HELD.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_SIGNAL_LIT.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_TRAIN_ID.ordinal()] = 37;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_TRAIN_NAME.ordinal()] = 38;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.SET_TURNOUT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.START_FAST_CLOCK.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.STOP_FAST_CLOCK.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.THROTTLE_FACTOR.ordinal()] = 40;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditional.Action.TRIGGER_ROUTE.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$jmri$Conditional$Action = nArray;
        return nArray;
    }

    static class DataPair {
        boolean result = false;
        int indexCount = 0;
        BitSet argsUsed = null;

        DataPair() {
        }
    }

    class ErrorDialog
    extends JDialog {
        JCheckBox rememberSession;

        ErrorDialog(List<String> list, Conditional cond) {
            this.setTitle("Logix Runtime Errors");
            JPanel contentPanel = new JPanel();
            contentPanel.setLayout(new BoxLayout(contentPanel, 1));
            JPanel panel = new JPanel();
            panel.add(new JLabel("Errors occurred executing Actions in Conditional:"));
            contentPanel.add(panel);
            panel = new JPanel();
            panel.add(new JLabel(DefaultConditional.this.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME)));
            contentPanel.add(panel);
            panel = new JPanel();
            panel.add(new JList<String>(list.toArray(new String[0])));
            contentPanel.add(panel);
            panel = new JPanel();
            this.rememberSession = new JCheckBox("Skip error dialog for this session only?");
            panel.add(this.rememberSession);
            contentPanel.add(panel);
            panel = new JPanel();
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent a) {
                    if (ErrorDialog.this.rememberSession.isSelected()) {
                        _skipErrorDialog = true;
                    }
                    ErrorDialog.this.dispose();
                }
            });
            panel.add(closeButton);
            contentPanel.add(panel);
            this.setContentPane(contentPanel);
            this.setLocation(250, 150);
            this.pack();
            this.setVisible(true);
        }
    }

    class TimeSensor
    implements ActionListener {
        private int mIndex = 0;

        public TimeSensor(int index) {
            this.mIndex = index;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ConditionalAction action = DefaultConditional.this._actionList.get(this.mIndex);
            if (action.getNamedBean() == null) {
                log.error("{} Invalid delayed sensor name - {}", (Object)DefaultConditional.this.getDisplayName(), (Object)action.getDeviceName());
            } else {
                Sensor s = (Sensor)action.getNamedBean().getBean();
                try {
                    int act = action.getActionData();
                    if (act == 8) {
                        int state = s.getKnownState();
                        act = state == 2 ? 4 : 2;
                    }
                    s.setKnownState(act);
                }
                catch (JmriException jmriException) {
                    log.warn("Exception setting delayed sensor {} in action", (Object)action.getDeviceName());
                }
            }
            action.stopTimer();
        }
    }

    class TimeTurnout
    implements ActionListener {
        private int mIndex = 0;

        public TimeTurnout(int index) {
            this.mIndex = index;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ConditionalAction action = DefaultConditional.this._actionList.get(this.mIndex);
            if (action.getNamedBean() == null) {
                log.error("{} Invalid delayed turnout name - {}", (Object)DefaultConditional.this.getDisplayName(), (Object)action.getDeviceName());
            } else {
                Turnout t = (Turnout)action.getNamedBean().getBean();
                int act = action.getActionData();
                if (act == 8) {
                    int state = t.getKnownState();
                    act = state == 2 ? 4 : 2;
                }
                t.setCommandedState(act);
            }
            action.stopTimer();
        }
    }
}

