/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.util.HashMap;
import java.util.List;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.NmraPacket;
import jmri.Turnout;
import jmri.implementation.AbstractSignalHead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DccSignalHead
extends AbstractSignalHead {
    private CommandStation c;
    private boolean useAddressOffSet = false;
    protected HashMap<Integer, Integer> appearanceToOutput = new HashMap();
    private int packetSendCount = 3;
    private int dccSignalDecoderAddress;
    private static final Logger log = LoggerFactory.getLogger(DccSignalHead.class);

    public DccSignalHead(String sys, String user) {
        super(sys, user);
        this.configureHead(sys);
    }

    public DccSignalHead(String sys) {
        super(sys);
        this.configureHead(sys);
    }

    private void configureHead(String sys) {
        this.setDefaultOutputs();
        if (sys.contains("$")) {
            this.dccSignalDecoderAddress = Integer.parseInt(sys.substring(sys.indexOf("$") + 1));
            String commandStationPrefix = sys.substring(0, sys.indexOf("$") - 1);
            List<CommandStation> connList = InstanceManager.getList(CommandStation.class);
            for (CommandStation station : connList) {
                if (!station.getSystemPrefix().equals(commandStationPrefix)) continue;
                this.c = station;
                break;
            }
            if (this.c == null) {
                this.c = InstanceManager.getNullableDefault(CommandStation.class);
                log.error("No match against the command station for {}, so will use the default", (Object)sys);
            }
        } else {
            this.c = InstanceManager.getNullableDefault(CommandStation.class);
            this.dccSignalDecoderAddress = sys.length() > 2 && (sys.charAt(1) == 'H' || sys.charAt(1) == 'h') ? Integer.parseInt(sys.substring(2, sys.length())) : Integer.parseInt(sys);
        }
        if (this.dccSignalDecoderAddress < 1 || this.dccSignalDecoderAddress > 2048) {
            log.error("SignalHead decoder address out of range: {}", (Object)this.dccSignalDecoderAddress);
            throw new IllegalArgumentException("SignalHead decoder address out of range: " + this.dccSignalDecoderAddress);
        }
    }

    @Override
    public void setAppearance(int newAppearance) {
        int oldAppearance = this.mAppearance;
        this.mAppearance = newAppearance;
        if (oldAppearance != newAppearance) {
            this.updateOutput();
            this.firePropertyChange("Appearance", oldAppearance, newAppearance);
        }
    }

    @Override
    public void setLit(boolean newLit) {
        boolean oldLit = this.mLit;
        this.mLit = newLit;
        if (oldLit != newLit) {
            this.updateOutput();
            this.firePropertyChange("Lit", oldLit, newLit);
        }
    }

    @Override
    public void setHeld(boolean newHeld) {
        boolean oldHeld = this.mHeld;
        this.mHeld = newHeld;
        if (oldHeld != newHeld) {
            this.firePropertyChange("Held", oldHeld, newHeld);
        }
    }

    protected void updateOutput() {
        if (this.c != null) {
            byte[] sigPacket;
            int aspect = this.getOutputForAppearance(0);
            if (this.getLit()) {
                Integer app = this.mAppearance;
                if (this.appearanceToOutput.containsKey(app)) {
                    aspect = this.appearanceToOutput.get(app);
                } else {
                    log.error("Unknown appearance {} displays DARK", (Object)this.mAppearance);
                }
            }
            if ((sigPacket = this.useAddressOffSet ? NmraPacket.accSignalDecoderPkt(this.dccSignalDecoderAddress, aspect) : NmraPacket.altAccSignalDecoderPkt(this.dccSignalDecoderAddress, aspect)) != null) {
                this.c.sendPacket(sigPacket, this.packetSendCount);
            }
        }
    }

    public void useAddressOffSet(boolean boo) {
        this.useAddressOffSet = boo;
    }

    public boolean useAddressOffSet() {
        return this.useAddressOffSet;
    }

    public int getOutputForAppearance(int appearance) {
        Integer app = appearance;
        if (!this.appearanceToOutput.containsKey(app)) {
            log.error("Trying to get appearance {} but it has not been configured", (Object)appearance);
            return -1;
        }
        return this.appearanceToOutput.get(app);
    }

    public void setOutputForAppearance(int appearance, int number) {
        Integer app = appearance;
        if (this.appearanceToOutput.containsKey(app)) {
            log.debug("Appearance {} is already defined as {}", (Object)appearance, (Object)this.appearanceToOutput.get(app));
            this.appearanceToOutput.remove(app);
        }
        this.appearanceToOutput.put(app, number);
    }

    private void setDefaultOutputs() {
        this.appearanceToOutput.put(1, DccSignalHead.getDefaultNumberForAppearance(1));
        this.appearanceToOutput.put(4, DccSignalHead.getDefaultNumberForAppearance(4));
        this.appearanceToOutput.put(16, DccSignalHead.getDefaultNumberForAppearance(16));
        this.appearanceToOutput.put(64, DccSignalHead.getDefaultNumberForAppearance(64));
        this.appearanceToOutput.put(2, DccSignalHead.getDefaultNumberForAppearance(2));
        this.appearanceToOutput.put(8, DccSignalHead.getDefaultNumberForAppearance(8));
        this.appearanceToOutput.put(32, DccSignalHead.getDefaultNumberForAppearance(32));
        this.appearanceToOutput.put(128, DccSignalHead.getDefaultNumberForAppearance(128));
        this.appearanceToOutput.put(0, DccSignalHead.getDefaultNumberForAppearance(0));
    }

    public static int getDefaultNumberForAppearance(int i) {
        switch (i) {
            case 0: {
                return 8;
            }
            case 1: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 16: {
                return 2;
            }
            case 64: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 32: {
                return 6;
            }
            case 128: {
                return 7;
            }
        }
        return 8;
    }

    public void setDccSignalHeadPacketSendCount(int count) {
        this.packetSendCount = count > 0 ? count : 1;
    }

    public int getDccSignalHeadPacketSendCount() {
        return this.packetSendCount;
    }

    @Override
    boolean isTurnoutUsed(Turnout t) {
        return false;
    }
}

