/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.jmrix.AbstractProgrammerFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressedHighCvProgrammerFacade
extends AbstractProgrammerFacade
implements ProgListener {
    int top;
    String addrCVhigh;
    String addrCVlow;
    String valueCV;
    int modulo;
    Programmer _prog;
    int _val;
    int _cv;
    int _startVal;
    private ProgListener _usingProgrammer = null;
    ProgState state = ProgState.NOTPROGRAMMING;
    private static final Logger log = LoggerFactory.getLogger(AddressedHighCvProgrammerFacade.class);

    public AddressedHighCvProgrammerFacade(Programmer prog, String top, String addrCVhigh, String addrCVlow, String valueCV, String modulo) {
        super(prog);
        this.top = Integer.parseInt(top);
        this.addrCVhigh = addrCVhigh;
        this.addrCVlow = addrCVlow;
        this.valueCV = valueCV;
        this.modulo = Integer.parseInt(modulo);
        this._prog = prog;
        log.debug("Created with {}, {}, {}, {}, {}, {}", new Object[]{prog, this.top, this.addrCVhigh, this.addrCVlow, this.valueCV, this.modulo});
    }

    @Override
    public void writeCV(String CV, int val, ProgListener p) throws ProgrammerException {
        log.debug("start writeCV");
        this._cv = Integer.parseInt(CV);
        this._val = val;
        this.useProgrammer(p);
        if (this.prog.getCanWrite(CV) || this._cv <= this.top) {
            this.state = ProgState.PROGRAMMING;
            this.prog.writeCV(CV, val, this);
        } else {
            this.state = ProgState.WRITELOWWRITE;
            this.prog.writeCV(this.addrCVhigh, this._cv / this.modulo, this);
        }
    }

    @Override
    public void readCV(String CV, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p, 0);
    }

    @Override
    public void readCV(String CV, ProgListener p, int startVal) throws ProgrammerException {
        log.debug("start readCV");
        this._cv = Integer.parseInt(CV);
        this._startVal = startVal;
        this.useProgrammer(p);
        if (this.prog.getCanRead(CV) || this._cv <= this.top) {
            this.state = ProgState.PROGRAMMING;
            this.prog.readCV(CV, this, startVal);
        } else {
            this.state = ProgState.WRITELOWREAD;
            this.prog.writeCV(this.addrCVhigh, this._cv / this.modulo, this);
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    @Override
    public void programmingOpReply(int value, int status) {
        if (log.isDebugEnabled()) {
            log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        }
        if (status != 0) {
            log.debug("Reset and pass abort up");
            ProgListener temp = this._usingProgrammer;
            this._usingProgrammer = null;
            this.state = ProgState.NOTPROGRAMMING;
            temp.programmingOpReply(value, status);
            return;
        }
        if (this._usingProgrammer == null) {
            log.error("No listener to notify, reset and ignore");
            this.state = ProgState.NOTPROGRAMMING;
            return;
        }
        switch (this.state) {
            case PROGRAMMING: {
                ProgListener temp = this._usingProgrammer;
                this._usingProgrammer = null;
                this.state = ProgState.NOTPROGRAMMING;
                temp.programmingOpReply(value, status);
                break;
            }
            case WRITELOWREAD: {
                try {
                    this.state = ProgState.FINISHREAD;
                    this.prog.writeCV(this.addrCVlow, this._cv % this.modulo, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing final read", (Throwable)e);
                }
                break;
            }
            case WRITELOWWRITE: {
                try {
                    this.state = ProgState.FINISHWRITE;
                    this.prog.writeCV(this.addrCVlow, this._cv % this.modulo, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing final write", (Throwable)e);
                }
                break;
            }
            case FINISHREAD: {
                try {
                    this.state = ProgState.PROGRAMMING;
                    this.prog.readCV(this.valueCV, this, this._startVal);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing final read", (Throwable)e);
                }
                break;
            }
            case FINISHWRITE: {
                try {
                    this.state = ProgState.PROGRAMMING;
                    this.prog.writeCV(this.valueCV, this._val, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing final write", (Throwable)e);
                }
                break;
            }
            default: {
                log.error("Unexpected state on reply: {}", (Object)this.state);
                this._usingProgrammer = null;
                this.state = ProgState.NOTPROGRAMMING;
            }
        }
    }

    @Override
    public boolean getCanRead() {
        return this._prog.getCanRead();
    }

    @Override
    public boolean getCanRead(String addr) {
        return this._prog.getCanRead() && Integer.parseInt(addr) <= 1024;
    }

    @Override
    public boolean getCanWrite() {
        return this._prog.getCanWrite();
    }

    @Override
    public boolean getCanWrite(String addr) {
        return this._prog.getCanWrite() && Integer.parseInt(addr) <= 1024;
    }

    static enum ProgState {
        PROGRAMMING,
        WRITELOWREAD,
        WRITELOWWRITE,
        FINISHREAD,
        FINISHWRITE,
        NOTPROGRAMMING;

    }
}

