/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.swing.Timer;
import jmri.AnalogIO;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Timebase;
import jmri.VariableLight;
import jmri.implementation.AbstractLight;
import jmri.implementation.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVariableLight
extends AbstractLight
implements VariableLight {
    private static final Logger log = LoggerFactory.getLogger(AbstractVariableLight.class);
    protected double mTransitionDuration = 0.0;
    protected double mTransitionTargetIntensity = 0.0;
    protected Date mLastTransitionDate = null;
    protected long mNextTransitionTs = 0L;
    protected Timebase internalClock = null;
    protected Timer alarmSyncUpdate = null;
    protected PropertyChangeListener minuteChangeListener = null;

    public AbstractVariableLight(String systemName, String userName) {
        super(systemName, userName);
        this.initClocks();
    }

    public AbstractVariableLight(String systemName) {
        super(systemName);
        this.initClocks();
    }

    @Override
    @Nonnull
    public String describeState(int state) {
        switch (state) {
            case 8: {
                return Bundle.getMessage("LightStateIntermediate");
            }
            case 784: {
                return Bundle.getMessage("LightStateTransitioningToFullOn");
            }
            case 528: {
                return Bundle.getMessage("LightStateTransitioningHigher");
            }
            case 272: {
                return Bundle.getMessage("LightStateTransitioningLower");
            }
            case 16: {
                return Bundle.getMessage("LightStateTransitioningToFullOff");
            }
        }
        return super.describeState(state);
    }

    @Override
    public void setState(int newState) {
        if (log.isDebugEnabled()) {
            log.debug("setState {} was {}", (Object)newState, (Object)this.mState);
        }
        int oldState = this.mState;
        if (newState != 2 && newState != 4) {
            throw new IllegalArgumentException("cannot set state value " + newState);
        }
        this.sendOnOffCommand(newState);
        if (newState == 2) {
            if (this.getMaxIntensity() == 1.0 && this.getTransitionTime() <= 0.0) {
                if (log.isDebugEnabled()) {
                    log.debug("setState({}) considers not variable for ON", (Object)newState);
                }
                this.notifyTargetIntensityChange(1.0);
            } else if (this.getTransitionTime() <= 0.0) {
                if (log.isDebugEnabled()) {
                    log.debug("setState({}) using variable intensity", (Object)newState);
                }
                this.sendIntensity(this.getMaxIntensity());
                this.notifyTargetIntensityChange(this.getMaxIntensity());
            } else {
                this.startTransition(this.getMaxIntensity());
            }
        }
        if (newState == 4) {
            if (this.getMinIntensity() == 0.0 && this.getTransitionTime() <= 0.0) {
                if (log.isDebugEnabled()) {
                    log.debug("setState({}) considers not variable for OFF", (Object)newState);
                }
                this.notifyTargetIntensityChange(0.0);
            } else if (this.getTransitionTime() <= 0.0) {
                if (log.isDebugEnabled()) {
                    log.debug("setState({}) using variable intensity", (Object)newState);
                }
                this.sendIntensity(this.getMinIntensity());
                this.notifyTargetIntensityChange(this.getMinIntensity());
            } else {
                this.startTransition(this.getMinIntensity());
            }
        }
        this.notifyStateChange(oldState, newState);
    }

    @Override
    public void setTargetIntensity(double intensity) {
        if (log.isDebugEnabled()) {
            log.debug("setTargetIntensity {}", (Object)intensity);
        }
        if (intensity < 0.0 || intensity > 1.0) {
            throw new IllegalArgumentException("Target intensity value " + intensity + " not in legal range");
        }
        if (intensity > this.mMaxIntensity) {
            intensity = this.mMaxIntensity;
        }
        if (intensity < this.mMinIntensity) {
            intensity = this.mMinIntensity;
        }
        if (this.getTransitionTime() > 0.0) {
            this.startTransition(intensity);
        } else {
            this.sendIntensity(intensity);
            this.notifyTargetIntensityChange(intensity);
            if (intensity >= this.mMaxIntensity) {
                this.setState(2);
            } else if (intensity <= this.mMinIntensity) {
                this.setState(4);
            } else {
                this.notifyStateChange(this.mState, 8);
            }
        }
    }

    protected void startTransition(double intensity) {
        this.mTransitionTargetIntensity = intensity;
        int nextState = intensity >= this.getMaxIntensity() ? 784 : (intensity <= this.getMinIntensity() ? 16 : (intensity >= this.mCurrentIntensity ? 528 : (intensity <= this.mCurrentIntensity ? 272 : 16)));
        this.notifyStateChange(this.mState, nextState);
        this.initClocks();
    }

    protected abstract void sendIntensity(double var1);

    protected abstract void sendOnOffCommand(int var1);

    private void initClocks() {
        if (this.minuteChangeListener != null) {
            return;
        }
        this.internalClock = InstanceManager.getNullableDefault(Timebase.class);
        if (this.internalClock == null) {
            log.error("No Timebase Instance");
            return;
        }
        this.minuteChangeListener = e -> this.newInternalMinute();
        this.internalClock.addMinuteChangeListener(this.minuteChangeListener);
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="OK to compare floating point")
    protected void newInternalMinute() {
        double origCurrent = this.mCurrentIntensity;
        int origState = this.mState;
        int steps = this.getNumberOfSteps();
        if (this.mTransitionDuration > 0.0 && steps > 0) {
            double stepsPerMinute = (double)steps / this.mTransitionDuration;
            double stepSize = 1.0 / (double)steps;
            double intensityDiffPerMinute = stepSize * stepsPerMinute;
            if (Math.abs(this.mCurrentIntensity - this.mTransitionTargetIntensity) != 0.0) {
                if (log.isDebugEnabled()) {
                    log.debug("before Target: {} Current: {}", (Object)this.mTransitionTargetIntensity, (Object)this.mCurrentIntensity);
                }
                if (this.mTransitionTargetIntensity > this.mCurrentIntensity) {
                    this.mCurrentIntensity += intensityDiffPerMinute;
                    if (this.mCurrentIntensity >= this.mTransitionTargetIntensity) {
                        this.mCurrentIntensity = this.mTransitionTargetIntensity;
                        this.mState = this.mCurrentIntensity >= this.getMaxIntensity() ? 2 : 8;
                    }
                } else {
                    this.mCurrentIntensity -= intensityDiffPerMinute;
                    if (this.mCurrentIntensity <= this.mTransitionTargetIntensity) {
                        this.mCurrentIntensity = this.mTransitionTargetIntensity;
                        this.mState = this.mCurrentIntensity <= this.getMinIntensity() ? 4 : 8;
                    }
                }
                this.sendIntensity(this.mCurrentIntensity);
                if (log.isDebugEnabled()) {
                    log.debug("after Target: {} Current: {}", (Object)this.mTransitionTargetIntensity, (Object)this.mCurrentIntensity);
                }
            }
        }
        if (origCurrent != this.mCurrentIntensity) {
            this.firePropertyChange("CurrentIntensity", origCurrent, this.mCurrentIntensity);
            if (log.isDebugEnabled()) {
                log.debug("firePropertyChange intensity {} -> {}", (Object)origCurrent, (Object)this.mCurrentIntensity);
            }
        }
        if (origState != this.mState) {
            this.firePropertyChange("KnownState", origState, this.mState);
            if (log.isDebugEnabled()) {
                log.debug("firePropertyChange intensity {} -> {}", (Object)origCurrent, (Object)this.mCurrentIntensity);
            }
        }
    }

    protected abstract int getNumberOfSteps();

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="OK to compare floating point")
    protected void notifyTargetIntensityChange(double intensity) {
        double oldValue = this.mCurrentIntensity;
        this.mCurrentIntensity = intensity;
        if (oldValue != intensity) {
            this.firePropertyChange("TargetIntensity", oldValue, intensity);
        }
    }

    @Override
    public boolean isTransitionAvailable() {
        return true;
    }

    @Override
    public void setTransitionTime(double minutes) {
        if (minutes < 0.0) {
            throw new IllegalArgumentException("Invalid transition time: " + minutes);
        }
        this.mTransitionDuration = minutes;
    }

    @Override
    public double getTransitionTime() {
        return this.mTransitionDuration;
    }

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="OK to compare floating point")
    public boolean isTransitioning() {
        return this.mTransitionTargetIntensity != this.mCurrentIntensity;
    }

    @Override
    public double getCurrentIntensity() {
        return this.mCurrentIntensity;
    }

    @Override
    public double getTargetIntensity() {
        return this.mCurrentIntensity;
    }

    @Override
    public void setCommandedAnalogValue(double value) throws JmriException {
        int origState = this.mState;
        double origCurrent = this.mCurrentIntensity;
        if (this.mCurrentIntensity >= this.getMaxIntensity()) {
            this.mState = 2;
            this.mCurrentIntensity = this.getMaxIntensity();
        } else if (this.mCurrentIntensity <= this.getMinIntensity()) {
            this.mState = 4;
            this.mCurrentIntensity = this.getMinIntensity();
        } else {
            this.mState = 8;
            this.mCurrentIntensity = value;
        }
        this.mTransitionTargetIntensity = this.mCurrentIntensity;
        this.sendOnOffCommand(this.mState);
        this.sendIntensity(this.mCurrentIntensity);
        if (log.isDebugEnabled()) {
            log.debug("set analog value: {}", (Object)value);
        }
        this.firePropertyChange("CurrentIntensity", origCurrent, this.mCurrentIntensity);
        if (log.isDebugEnabled()) {
            log.debug("firePropertyChange intensity {} -> {}", (Object)origCurrent, (Object)this.mCurrentIntensity);
        }
        if (origState != this.mState) {
            this.firePropertyChange("KnownState", origState, this.mState);
            if (log.isDebugEnabled()) {
                log.debug("firePropertyChange intensity {} -> {}", (Object)origCurrent, (Object)this.mCurrentIntensity);
            }
        }
    }

    @Override
    public double getMinIntensity() {
        return this.mMinIntensity;
    }

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="OK to compare floating point")
    public void setMinIntensity(double intensity) {
        if (intensity < 0.0 || intensity > 1.0) {
            throw new IllegalArgumentException("Illegal intensity value: " + intensity);
        }
        if (intensity >= this.mMaxIntensity) {
            throw new IllegalArgumentException("Requested intensity " + intensity + " should be less than maxIntensity " + this.mMaxIntensity);
        }
        double oldValue = this.mMinIntensity;
        this.mMinIntensity = intensity;
        if (oldValue != intensity) {
            this.firePropertyChange("MinIntensity", oldValue, intensity);
        }
    }

    @Override
    public double getMaxIntensity() {
        return this.mMaxIntensity;
    }

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="OK to compare floating point")
    public void setMaxIntensity(double intensity) {
        if (intensity < 0.0 || intensity > 1.0) {
            throw new IllegalArgumentException("Illegal intensity value: " + intensity);
        }
        if (intensity <= this.mMinIntensity) {
            throw new IllegalArgumentException("Requested intensity " + intensity + " must be higher than minIntensity " + this.mMinIntensity);
        }
        double oldValue = this.mMaxIntensity;
        this.mMaxIntensity = intensity;
        if (oldValue != intensity) {
            this.firePropertyChange("MaxIntensity", oldValue, intensity);
        }
    }

    @Override
    public double getState(double v) {
        return this.getCommandedAnalogValue();
    }

    @Override
    public void setState(double newState) throws JmriException {
        this.setCommandedAnalogValue(newState);
    }

    @Override
    public double getResolution() {
        return 1.0 / (double)this.getNumberOfSteps();
    }

    @Override
    public double getCommandedAnalogValue() {
        return this.getCurrentIntensity();
    }

    @Override
    public double getMin() {
        return this.getMinIntensity();
    }

    @Override
    public double getMax() {
        return this.getMaxIntensity();
    }

    @Override
    public AnalogIO.AbsoluteOrRelative getAbsoluteOrRelative() {
        return AnalogIO.AbsoluteOrRelative.ABSOLUTE;
    }
}

