/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Arrays;
import javax.annotation.Nonnull;
import jmri.SignalHead;
import jmri.Turnout;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import jmri.util.StringUtil;

public abstract class AbstractSignalHead
extends AbstractNamedBean
implements SignalHead,
VetoableChangeListener {
    protected int mAppearance = 0;
    protected boolean mLit = true;
    protected boolean mHeld = false;
    private static final int[] validStates;
    private static final String[] validStateKeys;

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 16;
        nArray[4] = 64;
        nArray[5] = 2;
        nArray[6] = 8;
        nArray[7] = 32;
        nArray[8] = 128;
        validStates = nArray;
        validStateKeys = new String[]{"SignalHeadStateDark", "SignalHeadStateRed", "SignalHeadStateYellow", "SignalHeadStateGreen", "SignalHeadStateLunar", "SignalHeadStateFlashingRed", "SignalHeadStateFlashingYellow", "SignalHeadStateFlashingGreen", "SignalHeadStateFlashingLunar"};
    }

    public AbstractSignalHead(String systemName, String userName) {
        super(systemName, userName);
    }

    public AbstractSignalHead(String systemName) {
        super(systemName);
    }

    @Override
    public String getAppearanceName(int appearance) {
        String ret = StringUtil.getNameFromState(appearance, this.getValidStates(), this.getValidStateNames());
        if (ret != null) {
            return ret;
        }
        return "";
    }

    @Override
    public String getAppearanceName() {
        return this.getAppearanceName(this.getAppearance());
    }

    @Override
    public String getAppearanceKey(int appearance) {
        String ret = StringUtil.getNameFromState(appearance, this.getValidStates(), this.getValidStateKeys());
        if (ret != null) {
            return ret;
        }
        return "";
    }

    @Override
    public String getAppearanceKey() {
        return this.getAppearanceKey(this.getAppearance());
    }

    @Override
    public int getAppearance() {
        return this.mAppearance;
    }

    @Override
    public boolean isCleared() {
        return !this.isAtStop() && !this.isShowingRestricting() && this.getAppearance() != 0;
    }

    @Override
    public boolean isShowingRestricting() {
        return this.getAppearance() == 2 || this.getAppearance() == 64 || this.getAppearance() == 128;
    }

    @Override
    public boolean isAtStop() {
        return this.getAppearance() == 1;
    }

    @Override
    public boolean getLit() {
        return this.mLit;
    }

    @Override
    public boolean getHeld() {
        return this.mHeld;
    }

    @Override
    public void setState(int s) {
        this.setAppearance(s);
    }

    @Override
    public int getState() {
        return this.getAppearance();
    }

    public static int[] getDefaultValidStates() {
        return Arrays.copyOf(validStates, validStates.length);
    }

    public static String[] getDefaultValidStateNames() {
        String[] stateNames = new String[validStateKeys.length];
        int i = 0;
        String[] stringArray = validStateKeys;
        int n = validStateKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String stateKey = stringArray[n2];
            stateNames[i++] = Bundle.getMessage(stateKey);
            ++n2;
        }
        return stateNames;
    }

    public static String getDefaultStateName(int appearance) {
        String ret = StringUtil.getNameFromState(appearance, AbstractSignalHead.getDefaultValidStates(), AbstractSignalHead.getDefaultValidStateNames());
        if (ret != null) {
            return ret;
        }
        return "";
    }

    @Override
    public int[] getValidStates() {
        return Arrays.copyOf(validStates, validStates.length);
    }

    @Override
    public String[] getValidStateKeys() {
        return Arrays.copyOf(validStateKeys, validStateKeys.length);
    }

    @Override
    public String[] getValidStateNames() {
        return AbstractSignalHead.getDefaultValidStateNames();
    }

    abstract boolean isTurnoutUsed(Turnout var1);

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName()) && this.isTurnoutUsed((Turnout)evt.getOldValue())) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
            throw new PropertyVetoException(Bundle.getMessage("InUseTurnoutSignalHeadVeto", this.getDisplayName()), e);
        }
    }

    @Override
    @Nonnull
    public String getBeanType() {
        return Bundle.getMessage("BeanNameSignalHead");
    }
}

