/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.ShutDownTask;
import jmri.util.LoggingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractShutDownTask
implements ShutDownTask {
    private final String mName;
    private boolean doRun = false;
    private static final Logger log = LoggerFactory.getLogger(AbstractShutDownTask.class);

    public AbstractShutDownTask(String name) {
        this.mName = name;
    }

    @Override
    public boolean isShutdownAllowed() {
        LoggingUtil.deprecationWarning(log, "isShutdownAllowed");
        return this.call();
    }

    @Override
    public Boolean call() {
        this.doRun = true;
        return this.doRun;
    }

    @Override
    public final boolean execute() {
        LoggingUtil.deprecationWarning(log, "execute");
        this.run();
        return true;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean isParallel() {
        LoggingUtil.deprecationWarning(log, "isParallel");
        return false;
    }

    @Override
    public boolean isComplete() {
        LoggingUtil.deprecationWarning(log, "isComplete");
        return !this.isParallel();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void propertyChange(PropertyChangeEvent evt) {
        if ("shuttingDown".equals(evt.getPropertyName()) && Boolean.FALSE.equals(evt.getNewValue())) {
            this.doRun = false;
        }
    }

    public boolean isDoRun() {
        return this.doRun;
    }

    public void setDoRun(boolean flag) {
        this.doRun = flag;
    }
}

