/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.lang.reflect.InvocationTargetException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Reporter;
import jmri.Sensor;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSensor
extends AbstractNamedBean
implements Sensor {
    private static final Logger log = LoggerFactory.getLogger(AbstractSensor.class);
    protected long sensorDebounceGoingActive = 0L;
    protected long sensorDebounceGoingInActive = 0L;
    protected boolean useDefaultTimerSettings = false;
    protected Thread thr;
    protected Runnable r;
    int restartcount = 0;
    protected boolean _inverted = false;
    protected int _knownState = 1;
    protected int _rawState = 1;
    Reporter reporter = null;

    public AbstractSensor(String systemName) {
        super(systemName);
    }

    public AbstractSensor(String systemName, String userName) {
        super(systemName, userName);
    }

    @Override
    @Nonnull
    public String getBeanType() {
        return Bundle.getMessage("BeanNameSensor");
    }

    @Override
    public int getKnownState() {
        return this._knownState;
    }

    @Override
    public void setSensorDebounceGoingActiveTimer(long time) {
        if (this.sensorDebounceGoingActive == time) {
            return;
        }
        long oldValue = this.sensorDebounceGoingActive;
        this.sensorDebounceGoingActive = time;
        this.firePropertyChange("ActiveTimer", oldValue, this.sensorDebounceGoingActive);
    }

    @Override
    public long getSensorDebounceGoingActiveTimer() {
        return this.sensorDebounceGoingActive;
    }

    @Override
    public void setSensorDebounceGoingInActiveTimer(long time) {
        if (this.sensorDebounceGoingInActive == time) {
            return;
        }
        long oldValue = this.sensorDebounceGoingInActive;
        this.sensorDebounceGoingInActive = time;
        this.firePropertyChange("InActiveTimer", oldValue, this.sensorDebounceGoingInActive);
    }

    @Override
    public long getSensorDebounceGoingInActiveTimer() {
        return this.sensorDebounceGoingInActive;
    }

    @Override
    public void setUseDefaultTimerSettings(boolean boo) {
        if (boo == this.useDefaultTimerSettings) {
            return;
        }
        this.useDefaultTimerSettings = boo;
        if (this.useDefaultTimerSettings) {
            this.sensorDebounceGoingActive = InstanceManager.sensorManagerInstance().getDefaultSensorDebounceGoingActive();
            this.sensorDebounceGoingInActive = InstanceManager.sensorManagerInstance().getDefaultSensorDebounceGoingInActive();
        }
        this.firePropertyChange("GlobalTimer", !boo, boo);
    }

    @Override
    public boolean getUseDefaultTimerSettings() {
        return this.useDefaultTimerSettings;
    }

    protected void sensorDebounce() {
        int lastKnownState = this._knownState;
        this.r = () -> {
            try {
                long sensorDebounceTimer = this.sensorDebounceGoingInActive;
                if (this._rawState == 2) {
                    sensorDebounceTimer = this.sensorDebounceGoingActive;
                }
                Thread.sleep(sensorDebounceTimer);
                this.restartcount = 0;
                this._knownState = this._rawState;
                SwingUtilities.invokeAndWait(() -> this.firePropertyChange("KnownState", lastKnownState, this._knownState));
            }
            catch (InterruptedException interruptedException) {
                ++this.restartcount;
            }
            catch (InvocationTargetException ex) {
                log.error("failed to start debounced Sensor update for \"{}\" due to {}", (Object)this.getDisplayName(), (Object)ex.getCause());
            }
        };
        this.thr = ThreadingUtil.newThread(this.r);
        this.thr.start();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describeState(int state) {
        switch (state) {
            case 2: {
                return Bundle.getMessage("SensorStateActive");
            }
            case 4: {
                return Bundle.getMessage("SensorStateInactive");
            }
        }
        return super.describeState(state);
    }

    @Override
    public void setKnownState(int newState) throws JmriException {
        this.setOwnState(newState);
    }

    protected boolean stateChangeCheck(int newState) throws IllegalArgumentException {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                throw new IllegalArgumentException("Can't set state for Sensor " + newState);
            }
            return !this.getInverted();
        }
        return this.getInverted();
    }

    public void setOwnState(int s) {
        if (this._rawState != s) {
            if (s == 2 && this.sensorDebounceGoingActive > 0L || s == 4 && this.sensorDebounceGoingInActive > 0L) {
                int oldRawState = this._rawState;
                this._rawState = s;
                if (this.thr != null) {
                    this.thr.interrupt();
                }
                if (this.restartcount != 0 && this.restartcount % 10 == 0) {
                    log.warn("Sensor \"{}\" state keeps flapping: {}", (Object)this.getDisplayName(), (Object)this.restartcount);
                }
                this.firePropertyChange("RawState", oldRawState, s);
                this.sensorDebounce();
                return;
            }
            if (this.thr != null) {
                this.thr.interrupt();
            }
            this._rawState = s;
        }
        if (this._knownState != s) {
            int oldState = this._knownState;
            this._knownState = s;
            this.firePropertyChange("KnownState", oldState, this._knownState);
        }
    }

    @Override
    public int getRawState() {
        return this._rawState;
    }

    @Override
    public void setState(int s) throws JmriException {
        this.setKnownState(s);
    }

    @Override
    public int getState() {
        return this.getKnownState();
    }

    @Override
    public void setInverted(boolean inverted) {
        boolean oldInverted = this._inverted;
        this._inverted = inverted;
        if (oldInverted != this._inverted) {
            this.firePropertyChange("inverted", oldInverted, this._inverted);
            int state = this._knownState;
            if (state == 2) {
                this.setOwnState(4);
            } else if (state == 4) {
                this.setOwnState(2);
            }
        }
    }

    @Override
    public final boolean getInverted() {
        return this._inverted;
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    public void setReporter(Reporter er) {
        this.reporter = er;
    }

    @Override
    public Reporter getReporter() {
        return this.reporter;
    }

    @Override
    public void setPullResistance(Sensor.PullResistance r) {
    }

    @Override
    public Sensor.PullResistance getPullResistance() {
        return Sensor.PullResistance.PULL_OFF;
    }
}

