/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightControl;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLight
extends AbstractNamedBean
implements Light {
    protected List<LightControl> lightControlList = new ArrayList<LightControl>();
    protected double mMaxIntensity = 1.0;
    protected double mMinIntensity = 0.0;
    protected double mCurrentIntensity = 0.0;
    protected boolean mActive = false;
    protected boolean mEnabled = true;
    protected int mState = 4;
    private static final Logger log = LoggerFactory.getLogger(AbstractLight.class);

    public AbstractLight(String systemName, String userName) {
        super(systemName, userName);
    }

    public AbstractLight(String systemName) {
        super(systemName);
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameLight");
    }

    @Override
    @Nonnull
    public String describeState(int state) {
        switch (state) {
            case 2: {
                return Bundle.getMessage("StateOn");
            }
            case 4: {
                return Bundle.getMessage("StateOff");
            }
        }
        return super.describeState(state);
    }

    @Override
    public boolean getEnabled() {
        return this.mEnabled;
    }

    @Override
    public void setEnabled(boolean v) {
        boolean old = this.mEnabled;
        this.mEnabled = v;
        if (old != v) {
            this.firePropertyChange("Enabled", old, v);
        }
    }

    @Override
    public void setState(int newState) {
        log.debug("setState {} was {}", (Object)newState, (Object)this.mState);
        if (newState != 2 && newState != 4) {
            throw new IllegalArgumentException("cannot set state value " + newState);
        }
        this.doNewState(this.mState, newState);
        this.notifyStateChange(this.mState, newState);
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="OK to compare floating point")
    protected void notifyTargetIntensityChange(double intensity) {
        double oldValue = this.mCurrentIntensity;
        this.mCurrentIntensity = intensity;
        if (oldValue != intensity) {
            this.firePropertyChange("TargetIntensity", oldValue, intensity);
        }
    }

    protected void notifyStateChange(int oldState, int newState) {
        this.mState = newState;
        if (oldState != newState) {
            this.firePropertyChange("KnownState", oldState, newState);
        }
    }

    protected void doNewState(int oldState, int newState) {
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public void activateLight() {
        this.lightControlList.stream().forEach(lc -> lc.activateLightControl());
        this.mActive = true;
    }

    @Override
    public void deactivateLight() {
        if (this.mActive) {
            this.lightControlList.stream().forEach(lc -> lc.deactivateLightControl());
            this.mActive = false;
        }
    }

    @Override
    public void clearLightControls() {
        this.deactivateLight();
        int i = this.lightControlList.size() - 1;
        while (i >= 0) {
            this.lightControlList.remove(i);
            --i;
        }
    }

    @Override
    public void addLightControl(LightControl c) {
        if (this.lightControlList.contains(c)) {
            log.debug("not adding duplicate LightControl {}", (Object)c);
            return;
        }
        this.lightControlList.add(c);
    }

    @Override
    public List<LightControl> getLightControlList() {
        ArrayList<LightControl> listCopy = new ArrayList<LightControl>();
        this.lightControlList.stream().forEach(lightControlList1 -> listCopy.add((LightControl)lightControlList1));
        return listCopy;
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        SensorManager sm = InstanceManager.getDefault(SensorManager.class);
        TurnoutManager tm = InstanceManager.getDefault(TurnoutManager.class);
        if (bean != null) {
            this.getLightControlList().forEach(control -> {
                String descText = control.getDescriptionText("");
                if (bean.equals(sm.getSensor(control.getControlSensorName()))) {
                    report.add(new NamedBeanUsageReport("LightControlSensor1", descText));
                }
                if (bean.equals(sm.getSensor(control.getControlSensor2Name()))) {
                    report.add(new NamedBeanUsageReport("LightControlSensor2", descText));
                }
                if (bean.equals(sm.getSensor(control.getControlTimedOnSensorName()))) {
                    report.add(new NamedBeanUsageReport("LightControlSensorTimed", descText));
                }
                if (bean.equals(tm.getTurnout(control.getControlTurnoutName()))) {
                    report.add(new NamedBeanUsageReport("LightControlTurnout", descText));
                }
            });
        }
        return report;
    }
}

