/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jmri.DccLocoAddress;
import jmri.IdTag;
import jmri.IdTagListener;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.PhysicalLocationReporter;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.implementation.AbstractReporter;
import jmri.implementation.Bundle;
import jmri.util.PhysicalLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractIdTagReporter
extends AbstractReporter
implements IdTagListener,
PhysicalLocationReporter {
    private int state = 1;
    private static final Logger log = LoggerFactory.getLogger(AbstractIdTagReporter.class);

    public AbstractIdTagReporter(String systemName) {
        super(systemName);
    }

    public AbstractIdTagReporter(String systemName, String userName) {
        super(systemName, userName);
    }

    @Override
    public void notify(IdTag id) {
        log.debug("Notify: {}", (Object)this.mSystemName);
        if (id != null) {
            log.debug("Tag: {}", (Object)id);
            Reporter r = id.getWhereLastSeen();
            if (r != null) {
                this.notifyPreviousReporter(r, id);
            }
            id.setWhereLastSeen(this);
            log.debug("Seen here: {}", (Object)this.mSystemName);
        }
        this.setReport(id);
        this.setState(id != null ? 3 : 2);
    }

    private void notifyPreviousReporter(Reporter r, IdTag id) {
        log.debug("Previous reporter: {}", (Object)r.getSystemName());
        if (!r.equals(this) && r.getCurrentReport() == id && r instanceof IdTagListener) {
            log.debug("Notify previous");
            ((IdTagListener)((Object)r)).notify(null);
        } else {
            log.debug("Current report was: {}", r.getCurrentReport());
        }
    }

    @Override
    public void setState(int s) {
        this.state = s;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    @Nonnull
    public String describeState(int state) {
        switch (state) {
            case 3: {
                return Bundle.getMessage("IdTagReporterStateSeen");
            }
            case 2: {
                return Bundle.getMessage("IdTagReporterStateUnSeen");
            }
        }
        return super.describeState(state);
    }

    @Override
    public LocoAddress getLocoAddress(String rep) {
        IdTag cr = (IdTag)this.getCurrentReport();
        ReporterManager rm = InstanceManager.getDefault(ReporterManager.class);
        Pattern p = Pattern.compile(rm.getSystemPrefix() + rm.typeLetter() + "(\\d+)");
        Matcher m = p.matcher(cr.getTagID());
        if (m.find()) {
            log.debug("Parsed address: {}", (Object)m.group(1));
            return new DccLocoAddress(Integer.parseInt(m.group(1)), LocoAddress.Protocol.DCC);
        }
        return null;
    }

    @Override
    public PhysicalLocationReporter.Direction getDirection(String rep) {
        return PhysicalLocationReporter.Direction.ENTER;
    }

    @Override
    public PhysicalLocation getPhysicalLocation() {
        return this.getPhysicalLocation(null);
    }

    @Override
    public PhysicalLocation getPhysicalLocation(String s) {
        return PhysicalLocation.getBeanPhysicalLocation(this);
    }
}

