/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.IdTag;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Reportable;
import jmri.Reporter;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import jmri.managers.ProxyIdTagManager;

public abstract class AbstractIdTag
extends AbstractNamedBean
implements IdTag,
Reportable {
    protected Reporter whereLastSeen = null;
    protected Date whenLastSeen = null;
    protected String prefix = null;

    public AbstractIdTag(String systemName) {
        super(systemName);
    }

    public AbstractIdTag(String systemName, String userName) {
        super(systemName, userName);
    }

    @Override
    @Nonnull
    public String getTagID() {
        if (this.prefix == null) {
            try {
                this.prefix = this.findPrefix();
            }
            catch (NullPointerException | NamedBean.BadSystemNameException runtimeException) {
                return this.mSystemName.substring(this.mSystemName.indexOf(68) + 1);
            }
        }
        return this.mSystemName.substring(this.prefix.length() + 1);
    }

    private String findPrefix() {
        List managerList = InstanceManager.getDefault(ProxyIdTagManager.class).getManagerList();
        for (Manager m : managerList) {
            if (m.getBySystemName(this.mSystemName) == null) continue;
            return m.getSystemPrefix();
        }
        throw new NamedBean.BadSystemNameException();
    }

    @Override
    public Reporter getWhereLastSeen() {
        return this.whereLastSeen;
    }

    @Override
    public Date getWhenLastSeen() {
        if (this.whenLastSeen == null) {
            return null;
        }
        return (Date)this.whenLastSeen.clone();
    }

    @Override
    public String toReportString() {
        String userName = this.getUserName();
        StringBuilder sb = new StringBuilder();
        if (userName == null || userName.isEmpty()) {
            sb.append(this.getTagID());
        } else {
            sb.append(userName);
        }
        this.getPropertyKeys().forEach(s -> {
            sb.append(" ");
            sb.append(this.getProperty((String)s));
        });
        return sb.toString();
    }

    @Override
    @Nonnull
    public String getBeanType() {
        return Bundle.getMessage("BeanNameReporter");
    }
}

