/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.util.ArrayList;
import java.util.HashMap;
import jmri.Consist;
import jmri.ConsistListListener;
import jmri.ConsistManager;
import jmri.LocoAddress;

public abstract class AbstractConsistManager
implements ConsistManager {
    protected HashMap<LocoAddress, Consist> consistTable = new HashMap();
    private ArrayList<ConsistListListener> changeListeners = new ArrayList();

    @Override
    public Consist getConsist(LocoAddress address) {
        if (this.consistTable.containsKey(address)) {
            return this.consistTable.get(address);
        }
        return this.addConsist(address);
    }

    protected abstract Consist addConsist(LocoAddress var1);

    @Override
    public void delConsist(LocoAddress address) {
        this.consistTable.get(address).dispose();
        this.consistTable.remove(address);
    }

    @Override
    public ArrayList<LocoAddress> getConsistList() {
        return new ArrayList<LocoAddress>(this.consistTable.keySet());
    }

    @Override
    public String decodeErrorCode(int errorCode) {
        String retval;
        StringBuilder buffer = new StringBuilder("");
        if ((errorCode & 1) != 0) {
            buffer.append("Not Implemented ");
        }
        if ((errorCode & 2) != 0) {
            buffer.append("Operation Completed Successfully ");
        }
        if ((errorCode & 4) != 0) {
            buffer.append("Consist Error ");
        }
        if ((errorCode & 0x10) != 0) {
            buffer.append("Address not controled by this device.");
        }
        if ((errorCode & 0x20) != 0) {
            buffer.append("Locomotive already consisted");
        }
        if ((errorCode & 0x40) != 0) {
            buffer.append("Locomotive Not Consisted ");
        }
        if ((errorCode & 0x80) != 0) {
            buffer.append("Speed Not Zero ");
        }
        if ((errorCode & 0x100) != 0) {
            buffer.append("Address Not Conist Address ");
        }
        if ((errorCode & 0x200) != 0) {
            buffer.append("Delete Error ");
        }
        if ((errorCode & 0x400) != 0) {
            buffer.append("Stack Full ");
        }
        if ((retval = buffer.toString()).equals("")) {
            return "Unknown Status Code: " + errorCode;
        }
        return retval;
    }

    @Override
    public void requestUpdateFromLayout() {
    }

    protected boolean shouldRequestUpdateFromLayout() {
        return true;
    }

    @Override
    public void addConsistListListener(ConsistListListener l) {
        this.changeListeners.add(l);
    }

    @Override
    public void removeConsistListListener(ConsistListListener l) {
        this.changeListeners.remove(l);
    }

    @Override
    public void notifyConsistListChanged() {
        for (ConsistListListener l : this.changeListeners) {
            l.notifyConsistListChanged();
        }
    }
}

