/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import jmri.Audio;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;

public abstract class AbstractAudio
extends AbstractNamedBean
implements Audio {
    private int _state = 0;
    private static final int INT_PRECISION = (int)Math.pow(10.0, 2.0);

    public AbstractAudio(String systemName) {
        super(systemName);
    }

    public AbstractAudio(String systemName, String userName) {
        super(systemName, userName);
    }

    @Override
    public int getState() {
        return this._state;
    }

    @Override
    public void setState(int newState) {
        Integer _old = this._state;
        this._state = newState;
        this.stateChanged(_old);
        this.firePropertyChange("State", _old, this._state);
    }

    protected abstract void cleanup();

    @Override
    public void dispose() {
        InstanceManager.getDefault(AudioManager.class).deregister(this);
        this.cleanup();
        super.dispose();
    }

    public static float roundDecimal(float value, double places) {
        double multiplier = Math.pow(10.0, places);
        value = (float)((double)value * multiplier);
        return (float)((double)Math.round(value) / multiplier);
    }

    public static float roundDecimal(float value) {
        return AbstractAudio.roundDecimal(value, Math.log10(INT_PRECISION));
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameAudio");
    }
}

