/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.Bundle;
import jmri.configurexml.StoreXmlConfigAction;
import jmri.jmrit.display.EditorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreXmlUserAction
extends StoreXmlConfigAction {
    private static final Logger log = LoggerFactory.getLogger(StoreXmlUserAction.class);

    public StoreXmlUserAction() {
        this(Bundle.getMessage("MenuItemStore"));
    }

    public StoreXmlUserAction(String s) {
        super(s);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser userFileChooser = StoreXmlUserAction.getUserFileChooser();
        userFileChooser.setDialogType(1);
        userFileChooser.setApproveButtonText(Bundle.getMessage("ButtonSave"));
        userFileChooser.setDialogTitle(Bundle.getMessage("StoreTitle"));
        File file = StoreXmlUserAction.getFileCustom(userFileChooser);
        if (file == null) {
            return;
        }
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm == null) {
            log.error("Failed to make backup due to unable to get default configure manager");
        } else {
            cm.makeBackup(file);
            boolean results = cm.storeUser(file);
            log.debug(results ? "store was successful" : "store failed");
            if (!results) {
                JOptionPane.showMessageDialog(null, String.valueOf(Bundle.getMessage("StoreHasErrors")) + "\n" + Bundle.getMessage("StoreIncomplete") + "\n" + Bundle.getMessage("ConsoleWindowHasInfo"), Bundle.getMessage("StoreError"), 0);
            } else {
                InstanceManager.getDefault(EditorManager.class).setChanged(false);
            }
        }
    }
}

