/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.annotation.CheckForNull;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.Bundle;
import jmri.configurexml.LoadStoreBaseAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreXmlConfigAction
extends LoadStoreBaseAction {
    static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.display.DisplayBundle");
    private static final Logger log = LoggerFactory.getLogger(StoreXmlConfigAction.class);

    public StoreXmlConfigAction() {
        this("Store configuration...");
    }

    public StoreXmlConfigAction(String s) {
        super(s);
    }

    public static File getFileName(JFileChooser fileChooser) {
        fileChooser.setDialogType(1);
        return StoreXmlConfigAction.getFileCustom(fileChooser);
    }

    @CheckForNull
    public static File getFileCustom(JFileChooser fileChooser) {
        int selectedValue;
        String fileName;
        String fileNameLC;
        fileChooser.rescanCurrentDirectory();
        int retVal = fileChooser.showDialog(null, Bundle.getMessage("MenuItemStore"));
        if (retVal != 0) {
            return null;
        }
        File file = fileChooser.getSelectedFile();
        if (fileChooser.getFileFilter() != fileChooser.getAcceptAllFileFilter() && !(fileNameLC = (fileName = file.getAbsolutePath()).toLowerCase()).endsWith(".xml")) {
            fileName = String.valueOf(fileName) + ".xml";
            file = new File(fileName);
        }
        if (log.isDebugEnabled()) {
            log.debug("Save file: {}", (Object)file.getPath());
        }
        if (file.exists() && (selectedValue = JOptionPane.showConfirmDialog(null, Bundle.getMessage("FileOverwriteWarning", file.getName()), Bundle.getMessage("OverwriteFile"), 2)) != 0) {
            return null;
        }
        return file;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file = StoreXmlConfigAction.getFileName(StoreXmlConfigAction.getConfigFileChooser());
        if (file == null) {
            return;
        }
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm == null) {
            log.error("Failed to get default configure manager");
        } else {
            boolean results = cm.storeConfig(file);
            log.debug(results ? "store was successful" : "store failed");
            if (!results) {
                JOptionPane.showMessageDialog(null, String.valueOf(rb.getString("StoreHasErrors")) + "\n" + rb.getString("StoreIncomplete") + "\n" + rb.getString("ConsoleWindowHasInfo"), rb.getString("StoreError"), 0);
            }
        }
    }
}

