/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.StoreXmlConfigAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreXmlAllAction
extends StoreXmlConfigAction {
    static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.display.DisplayBundle");
    private static final Logger log = LoggerFactory.getLogger(StoreXmlAllAction.class);

    public StoreXmlAllAction() {
        this("Store all ...");
    }

    public StoreXmlAllAction(String s) {
        super(s);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file = StoreXmlAllAction.getFileName(StoreXmlAllAction.getAllFileChooser());
        if (file == null) {
            return;
        }
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm == null) {
            log.error("Failed to get default configure manager");
        } else {
            boolean results = cm.storeAll(file);
            log.debug(results ? "store was successful" : "store failed");
            if (!results) {
                JOptionPane.showMessageDialog(null, String.valueOf(rb.getString("PanelStoreHasErrors")) + "\n" + rb.getString("PanelStoreIncomplete") + "\n" + rb.getString("ConsoleWindowHasInfo"), rb.getString("PanelStoreError"), 0);
            }
        }
    }
}

