/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.util.List;
import java.util.SortedSet;
import jmri.Block;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.Section;
import jmri.SectionManager;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectionManagerXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(SectionManagerXml.class);

    @Override
    public Element store(Object o) {
        Element sections = new Element("sections");
        this.setStoreElementClass(sections);
        SectionManager sctm = (SectionManager)o;
        if (sctm != null) {
            SortedSet sctList = sctm.getNamedBeanSet();
            if (sctList.isEmpty()) {
                return null;
            }
            for (Section x : sctList) {
                if (x == null) {
                    log.error("Memory null during store, skipped");
                    break;
                }
                String sName = x.getSystemName();
                log.debug("Section system name is {}", (Object)sName);
                if (x.getSectionType() == 0) continue;
                Element elem = new Element("section");
                elem.addContent((Content)new Element("systemName").addContent(sName));
                elem.setAttribute("systemName", sName);
                String uname = x.getUserName();
                if (uname != null && !uname.isEmpty()) {
                    elem.setAttribute("userName", uname);
                }
                this.storeCommon(x, elem);
                String txt = "userdefined";
                if (x.getSectionType() == 2) {
                    txt = "signalmastlogic";
                }
                elem.setAttribute("creationtype", txt);
                txt = x.getForwardStoppingSensorName();
                if (txt != null && !txt.isEmpty()) {
                    elem.setAttribute("fstopsensorname", txt);
                }
                if ((txt = x.getReverseStoppingSensorName()) != null && !txt.isEmpty()) {
                    elem.setAttribute("rstopsensorname", txt);
                }
                if ((txt = x.getForwardBlockingSensorName()) != null && !txt.isEmpty()) {
                    elem.setAttribute("fsensorname", txt);
                }
                if ((txt = x.getReverseBlockingSensorName()) != null && !txt.isEmpty()) {
                    elem.setAttribute("rsensorname", txt);
                }
                if (x.getSectionType() == 1) {
                    int index = 0;
                    Block b = x.getBlockBySequenceNumber(index);
                    while (b != null) {
                        Element bElem = new Element("blockentry");
                        bElem.setAttribute("sName", b.getSystemName());
                        bElem.setAttribute("order", Integer.toString(index));
                        elem.addContent((Content)bElem);
                        b = x.getBlockBySequenceNumber(++index);
                    }
                    List<EntryPoint> epList = x.getEntryPointList();
                    int i = 0;
                    for (EntryPoint ep : epList) {
                        if (ep == null) continue;
                        Element epElem = new Element("entrypoint");
                        if (ep.getFromBlock() == null) {
                            log.error("Unexpected null getFromBlock while storing ep {} in Section {}, skipped", (Object)i, (Object)sName);
                            break;
                        }
                        epElem.setAttribute("fromblock", ep.getFromBlock().getSystemName());
                        if (ep.getBlock() == null) {
                            log.error("Unexpected null getBlock while storing ep {} in Section {}, skipped", (Object)i, (Object)sName);
                            break;
                        }
                        epElem.setAttribute("toblock", ep.getBlock().getSystemName());
                        epElem.setAttribute("direction", Integer.toString(ep.getDirection()));
                        epElem.setAttribute("fixed", ep.isFixed() ? "yes" : "no");
                        epElem.setAttribute("fromblockdirection", ep.getFromBlockDirection());
                        elem.addContent((Content)epElem);
                        ++i;
                    }
                }
                sections.addContent((Content)elem);
            }
        }
        return sections;
    }

    public void setStoreElementClass(Element sections) {
        sections.setAttribute("class", "jmri.configurexml.SectionManagerXml");
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }

    @Override
    public boolean load(Element sharedSections, Element perNodeSections) {
        this.loadSections(sharedSections, perNodeSections);
        return true;
    }

    public void loadSections(Element sharedSections, Element perNodeSections) {
        List sectionList = sharedSections.getChildren("section");
        log.debug("Found {} Sections", (Object)sectionList.size());
        SectionManager sctm = InstanceManager.getDefault(SectionManager.class);
        sctm.setPropertyChangesSilenced("beans", true);
        for (Element s : sectionList) {
            String revName;
            String forName;
            Section x;
            String sysName = this.getSystemName(s);
            String userName = this.getUserName(s);
            try {
                x = sctm.createNewSection(sysName, userName);
            }
            catch (IllegalArgumentException ex) {
                log.error("Unable to create Section {} {}", (Object)sysName, (Object)ex.getMessage());
                continue;
            }
            this.loadCommon(x, s);
            if (s.getAttribute("creationtype") != null) {
                String creationType = s.getAttribute("creationtype").getValue();
                if (creationType.equals("userdefined")) {
                    x.setSectionType(1);
                } else if (creationType.equals("signalmastlogic")) {
                    x.setSectionType(2);
                }
            }
            if (s.getAttribute("fsensorname") != null) {
                forName = s.getAttribute("fsensorname").getValue();
                x.delayedSetForwardBlockingSensorName(forName);
            }
            if (s.getAttribute("rsensorname") != null) {
                revName = s.getAttribute("rsensorname").getValue();
                x.delayedSetReverseBlockingSensorName(revName);
            }
            if (s.getAttribute("fstopsensorname") != null) {
                forName = s.getAttribute("fstopsensorname").getValue();
                x.delayedSetForwardStoppingSensorName(forName);
            }
            if (s.getAttribute("rstopsensorname") != null) {
                revName = s.getAttribute("rstopsensorname").getValue();
                x.delayedSetReverseStoppingSensorName(revName);
            }
            List sectionBlockList = s.getChildren("blockentry");
            for (Element elem : sectionBlockList) {
                x.delayedAddBlock(elem.getAttribute("sName").getValue());
            }
            List sectionEntryPointList = s.getChildren("entrypoint");
            for (Element elem : sectionEntryPointList) {
                String blockName = elem.getAttribute("toblock").getValue();
                String fromBlockName = elem.getAttribute("fromblock").getValue();
                String fromBlockDirection = "";
                if (elem.getAttribute("fromblockdirection") != null) {
                    fromBlockDirection = elem.getAttribute("fromblockdirection").getValue();
                }
                EntryPoint ep = new EntryPoint(blockName, fromBlockName, fromBlockDirection);
                try {
                    ep.setDirection(elem.getAttribute("direction").getIntValue());
                }
                catch (DataConversionException e) {
                    log.error("Data Conversion Exception when loading direction of entry point - ", (Throwable)e);
                }
                boolean fixed = true;
                if (elem.getAttribute("fixed").getValue().equals("no")) {
                    fixed = false;
                }
                ep.setFixed(fixed);
                if (ep.isForwardType()) {
                    x.addToForwardList(ep);
                    continue;
                }
                if (!ep.isReverseType()) continue;
                x.addToReverseList(ep);
            }
        }
        sctm.setPropertyChangesSilenced("beans", false);
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(SectionManager.class).getXMLOrder();
    }
}

