/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import jmri.Scale;
import jmri.ScaleManager;
import jmri.jmrit.XmlFile;
import jmri.util.FileUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaleConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ScaleConfigXML.class);

    public static boolean doStore() {
        ScaleXmlFile x = new ScaleXmlFile();
        File file = x.getStoreFile();
        if (file == null) {
            log.warn("Unable to create local scale file");
            return false;
        }
        Element root = new Element("scale-data");
        root.setAttribute("noNamespaceSchemaLocation", "http://jmri.org/xml/schema/scale.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        Document doc = new Document(root);
        Element values = new Element("scales");
        root.addContent((Content)values);
        for (Scale scale : ScaleManager.getScales()) {
            Element e = new Element("scale");
            e.addContent((Content)new Element("scale_name").addContent(scale.getScaleName()));
            e.addContent((Content)new Element("user_name").addContent(scale.getUserName()));
            e.addContent((Content)new Element("scale_ratio").addContent(Double.toString(scale.getScaleRatio())));
            values.addContent((Content)e);
        }
        try {
            x.writeXML(file, doc);
        }
        catch (FileNotFoundException ex) {
            log.error("File not found when writing: {}", (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            log.error("IO Exception when writing: {}", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static boolean doLoad() {
        Element scales;
        block7: {
            Element root;
            block6: {
                ScaleXmlFile x = new ScaleXmlFile();
                File file = x.getLoadFile();
                root = x.rootFromFile(file);
                if (root != null) break block6;
                log.debug("File could not be read");
                return false;
            }
            scales = root.getChild("scales");
            if (scales != null) break block7;
            log.error("Unable to find a scale entry");
            return false;
        }
        try {
            for (Element scale : scales.getChildren("scale")) {
                Element scale_name = scale.getChild("scale_name");
                String scaleName = scale_name == null ? "" : scale_name.getValue();
                Element user_name = scale.getChild("user_name");
                String userName = user_name == null ? "" : user_name.getValue();
                Element scale_ratio = scale.getChild("scale_ratio");
                double scaleRatio = scale_ratio == null ? 1.0 : Double.parseDouble(scale_ratio.getValue());
                ScaleManager.addScale(scaleName, userName, scaleRatio);
            }
        }
        catch (JDOMException ex) {
            log.error("File invalid: {}", (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            log.error("Error reading file: {}", (Throwable)ex);
            return false;
        }
        return true;
    }

    private static class ScaleXmlFile
    extends XmlFile {
        private static String prodPath = String.valueOf(FileUtil.getProgramPath()) + "resources/scales/";
        private static String userPath = String.valueOf(FileUtil.getUserFilesPath()) + "resources/scales/";
        private static String fileName = "ScaleData.xml";

        private ScaleXmlFile() {
        }

        public static String getStoreFileName() {
            return String.valueOf(userPath) + fileName;
        }

        public File getStoreFile() {
            File chkdir = new File(userPath);
            if (!chkdir.exists() && !chkdir.mkdirs()) {
                return null;
            }
            File file = this.findFile(ScaleXmlFile.getStoreFileName());
            if (file == null) {
                log.info("Create new scale file");
                file = new File(ScaleXmlFile.getStoreFileName());
            } else {
                try {
                    FileUtil.rotate(file, 4, "bup");
                }
                catch (IOException iOException) {
                    log.warn("Rotate failed, reverting to xml backup");
                    this.makeBackupFile(ScaleXmlFile.getStoreFileName());
                }
            }
            return file;
        }

        public File getLoadFile() {
            File file = this.findFile(String.valueOf(userPath) + fileName);
            if (file == null) {
                file = this.findFile(String.valueOf(prodPath) + fileName);
            }
            return file;
        }
    }
}

