/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.configurexml.DccLocoAddressXml;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoAddressXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(LocoAddressXml.class);

    @Override
    public Element store(Object o) {
        LocoAddress p = (LocoAddress)o;
        Element element = new Element("locoaddress");
        DccLocoAddressXml adapter = new DccLocoAddressXml();
        element.addContent((Content)adapter.store(p));
        if (p != null) {
            element.addContent((Content)new Element("number").addContent("" + p.getNumber()));
            element.addContent((Content)new Element("protocol").addContent(p.getProtocol().getShortName()));
        } else {
            element.addContent((Content)new Element("number").addContent(""));
            element.addContent((Content)new Element("protocol").addContent(""));
        }
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        log.error("Invalid method called");
        return false;
    }

    public LocoAddress getAddress(Element element) {
        if (element.getChild("number") == null) {
            DccLocoAddressXml adapter = new DccLocoAddressXml();
            return adapter.getAddress(element.getChild("dcclocoaddress"));
        }
        int addr = 0;
        try {
            addr = Integer.parseInt(element.getChild("number").getText());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        String protocol = element.getChild("protocol").getText();
        LocoAddress.Protocol prot = LocoAddress.Protocol.getByShortName(protocol);
        return new DccLocoAddress(addr, prot);
    }
}

