/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.SortedSet;
import javax.swing.JFileChooser;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LogixManager;
import jmri.UserPreferencesManager;
import jmri.configurexml.Bundle;
import jmri.configurexml.LoadStoreBaseAction;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.LogixNG_Manager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadXmlConfigAction
extends LoadStoreBaseAction {
    private static final Logger log = LoggerFactory.getLogger(LoadXmlConfigAction.class);

    public LoadXmlConfigAction() {
        this("Open Data File ...");
    }

    public LoadXmlConfigAction(String s) {
        super(s);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.loadFile(LoadXmlConfigAction.getConfigFileChooser());
    }

    protected boolean loadFile(JFileChooser fileChooser) {
        SortedSet<Editor> editors = InstanceManager.getDefault(EditorManager.class).getAll();
        if (!editors.isEmpty()) {
            InstanceManager.getDefault(UserPreferencesManager.class).showWarningMessage(Bundle.getMessage("DuplicateLoadTitle"), Bundle.getMessage("DuplicateLoadMessage"), "jmri.jmrit.display.EditorManager", "skipDupLoadDialog", false, true);
            InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails("jmri.jmrit.display.EditorManager", "skipDupLoadDialog", Bundle.getMessage("DuplicateLoadSkip"));
        }
        boolean results = false;
        File file = LoadXmlConfigAction.getFile(fileChooser);
        if (file != null) {
            log.info("Loading selected file: {}", (Object)file);
            try {
                ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
                if (cm == null) {
                    log.error("Failed to get default configure manager");
                } else {
                    results = cm.load(file);
                    if (results) {
                        InstanceManager.getDefault(LogixManager.class).activateAllLogixs();
                        InstanceManager.getDefault(LayoutBlockManager.class).initializeLayoutBlockPaths();
                        LogixNG_Manager logixNG_Manager = InstanceManager.getDefault(LogixNG_Manager.class);
                        logixNG_Manager.setupAllLogixNGs();
                        if (InstanceManager.getDefault(LogixNGPreferences.class).getStartLogixNGOnStartup()) {
                            logixNG_Manager.activateAllLogixNGs();
                        }
                    }
                }
            }
            catch (JmriException e) {
                log.error("Unhandled problem in loadFile: {}", (Throwable)e);
            }
        } else {
            results = true;
        }
        return results;
    }

    public static File getFile(JFileChooser fileChooser) {
        fileChooser.setDialogType(0);
        return LoadXmlConfigAction.getFileCustom(fileChooser);
    }

    public static File getFileCustom(JFileChooser fileChooser) {
        fileChooser.rescanCurrentDirectory();
        int retVal = fileChooser.showDialog(null, Bundle.getMessage("MenuItemLoad"));
        if (retVal != 0) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Open file: {}", (Object)fileChooser.getSelectedFile().getPath());
        }
        return fileChooser.getSelectedFile();
    }
}

