/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import jmri.BeanSetting;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Path;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.Turnout;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.managers.configurexml.AbstractMemoryManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockManagerXml
extends AbstractMemoryManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(BlockManagerXml.class);

    @Override
    public void setStoreElementClass(Element memories) {
        memories.setAttribute("class", "jmri.configurexml.BlockManagerXml");
    }

    @Override
    public Element store(Object o) {
        Element blocks = new Element("blocks");
        this.setStoreElementClass(blocks);
        BlockManager bm = (BlockManager)o;
        if (bm != null) {
            String bName;
            SortedSet blkList = bm.getNamedBeanSet();
            if (blkList.isEmpty()) {
                return null;
            }
            blocks.addContent((Content)new Element("defaultspeed").addContent(bm.getDefaultSpeed()));
            for (Block b : blkList) {
                try {
                    bName = b.getSystemName();
                    Element elem = new Element("block");
                    elem.addContent((Content)new Element("systemName").addContent(bName));
                    elem.setAttribute("systemName", bName);
                    String uName = b.getUserName();
                    if (uName != null && !uName.isEmpty()) {
                        elem.addContent((Content)new Element("userName").addContent(uName));
                    }
                    log.debug("initial store Block {}", (Object)bName);
                    blocks.addContent((Content)elem);
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
            }
            for (Block b : blkList) {
                Reporter r;
                bName = b.getSystemName();
                String uName = b.getUserName();
                if (uName == null) {
                    uName = "";
                }
                Element elem = new Element("block");
                elem.addContent((Content)new Element("systemName").addContent(bName));
                elem.setAttribute("systemName", bName);
                log.debug("second store Block {}: {}", (Object)bName, (Object)uName);
                elem.setAttribute("length", Float.toString(b.getLengthMm()));
                elem.setAttribute("curve", Integer.toString(b.getCurvature()));
                this.storeCommon(b, elem);
                if (!b.getBlockSpeed().equals("") && !b.getBlockSpeed().contains("Global")) {
                    elem.addContent((Content)new Element("speed").addContent(b.getBlockSpeed()));
                }
                String perm = "no";
                if (b.getPermissiveWorking()) {
                    perm = "yes";
                }
                elem.addContent((Content)new Element("permissive").addContent(perm));
                if (b.getNamedSensor() != null) {
                    elem.addContent((Content)new Element("occupancysensor").addContent(b.getNamedSensor().getName()));
                }
                if (b.getDeniedBlocks().size() > 0) {
                    Element denied = new Element("deniedBlocks");
                    b.getDeniedBlocks().forEach(deniedBlock -> denied.addContent((Content)new Element("block").addContent(deniedBlock)));
                    elem.addContent((Content)denied);
                }
                if ((r = b.getReporter()) != null) {
                    Element re = new Element("reporter");
                    re.setAttribute("systemName", r.getSystemName());
                    re.setAttribute("useCurrent", b.isReportingCurrent() ? "yes" : "no");
                    elem.addContent((Content)re);
                }
                if (bm.isSavedPathInfo()) {
                    List<Path> paths = b.getPaths();
                    Collections.sort(paths);
                    for (Path p : paths) {
                        this.addPath(elem, p);
                    }
                }
                blocks.addContent((Content)elem);
            }
        }
        return blocks;
    }

    private void addPath(Element e, Path p) {
        List<BeanSetting> l;
        Element pe = new Element("path");
        pe.setAttribute("todir", "" + p.getToBlockDirection());
        pe.setAttribute("fromdir", "" + p.getFromBlockDirection());
        if (p.getBlock() != null) {
            pe.setAttribute("block", p.getBlock().getSystemName());
        }
        if ((l = p.getSettings()) != null) {
            for (BeanSetting bSet : l) {
                this.addBeanSetting(pe, bSet);
            }
        }
        e.addContent((Content)pe);
    }

    private void addBeanSetting(Element e, BeanSetting bs) {
        Element bse = new Element("beansetting");
        bse.setAttribute("setting", "" + bs.getSetting());
        Element be = new Element("turnout");
        be.setAttribute("systemName", bs.getBeanName());
        bse.addContent((Content)be);
        e.addContent((Content)bse);
    }

    @Override
    public boolean load(Element sharedBlocks, Element perNodeBlocks) throws JmriConfigureXmlException {
        boolean result = true;
        try {
            String speed;
            if (sharedBlocks.getChild("defaultspeed") != null && (speed = sharedBlocks.getChild("defaultspeed").getText()) != null && !speed.equals("")) {
                InstanceManager.getDefault(BlockManager.class).setDefaultSpeed(speed);
            }
        }
        catch (IllegalArgumentException ex) {
            log.error(ex.toString());
        }
        List list = sharedBlocks.getChildren("block");
        log.debug("Found {} objects", (Object)list.size());
        InstanceManager.getDefault(BlockManager.class).setPropertyChangesSilenced("beans", true);
        for (Element block : list) {
            this.loadBlock(block, false);
        }
        for (Element block : list) {
            this.loadBlock(block, true);
        }
        InstanceManager.getDefault(BlockManager.class).setPropertyChangesSilenced("beans", false);
        return result;
    }

    public void loadBlock(Element element) throws JmriConfigureXmlException {
        this.loadBlock(element, true);
    }

    private void loadBlock(Element element, boolean contentsFlag) throws JmriConfigureXmlException {
        List reporters;
        String name;
        Element deniedBlocks;
        String sysName = this.getSystemName(element);
        String userName = this.getUserName(element);
        log.debug("defined Block: ({})({})", (Object)sysName, (Object)(userName == null ? "<null>" : userName));
        Block block = InstanceManager.getDefault(BlockManager.class).getBlock(sysName);
        if (block == null) {
            InstanceManager.getDefault(BlockManager.class).createNewBlock(sysName, userName);
            block = InstanceManager.getDefault(BlockManager.class).getBlock(sysName);
        }
        if (block == null) {
            log.error("Unable to load block with system name {} and username of {}", (Object)sysName, (Object)(userName == null ? "<null>" : userName));
            return;
        }
        if (userName != null) {
            block.setUserName(userName);
        }
        if (!contentsFlag) {
            return;
        }
        if (element.getAttribute("length") != null) {
            block.setLength(Float.parseFloat(element.getAttribute("length").getValue()));
        }
        if (element.getAttribute("curve") != null) {
            block.setCurvature(Integer.parseInt(element.getAttribute("curve").getValue()));
        }
        try {
            String speed;
            block.setBlockSpeed("Global");
            if (element.getChild("speed") != null && (speed = element.getChild("speed").getText()) != null && !speed.equals("") && !speed.contains("Global")) {
                block.setBlockSpeed(speed);
            }
        }
        catch (JmriException ex) {
            log.error(ex.toString());
        }
        if (element.getChild("permissive") != null) {
            boolean permissive = false;
            if (element.getChild("permissive").getText().equals("yes")) {
                permissive = true;
            }
            block.setPermissiveWorking(permissive);
        }
        if ((deniedBlocks = element.getChild("deniedBlocks")) != null) {
            List denyBlock = deniedBlocks.getChildren("block");
            for (Element deny : denyBlock) {
                block.addBlockDenyList(deny.getText());
            }
        }
        this.loadCommon(block, element);
        List sensors = element.getChildren("sensor");
        if (sensors.size() > 1) {
            log.error("More than one sensor present: {}", (Object)sensors.size());
        }
        if (sensors.size() == 1 && ((Element)sensors.get(0)).getAttribute("systemName") != null && !(name = ((Element)sensors.get(0)).getAttribute("systemName").getValue()).equals("")) {
            block.setSensor(name);
        }
        if (element.getChild("occupancysensor") != null && !(name = element.getChild("occupancysensor").getText()).equals("")) {
            block.setSensor(name);
        }
        if ((reporters = element.getChildren("reporter")).size() > 1) {
            log.error("More than one reporter present: {}", (Object)reporters.size());
        }
        if (reporters.size() == 1) {
            String name2 = ((Element)reporters.get(0)).getAttribute("systemName").getValue();
            try {
                Reporter reporter = InstanceManager.getDefault(ReporterManager.class).provideReporter(name2);
                block.setReporter(reporter);
                block.setReportingCurrent(((Element)reporters.get(0)).getAttribute("useCurrent").getValue().equals("yes"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn("failed to create Reporter \"{}\" during Block load", (Object)name2);
            }
        }
        List paths = element.getChildren("path");
        int startSize = block.getPaths().size();
        int loadCount = 0;
        for (Element path : paths) {
            if (!this.loadPath(block, path)) continue;
            ++loadCount;
        }
        if (startSize > 0 && loadCount > 0) {
            log.warn("Added {} paths to block {} that already had {} blocks.", new Object[]{loadCount++, sysName, startSize});
        }
        if (startSize + loadCount != block.getPaths().size()) {
            log.error("Started with {} paths in block {}, added {} but final count is {}; something not right.", new Object[]{startSize, sysName, loadCount, block.getPaths().size()});
        }
    }

    public boolean loadPath(Block block, Element element) throws JmriConfigureXmlException {
        int toDir = 0;
        int fromDir = 0;
        try {
            toDir = element.getAttribute("todir").getIntValue();
            fromDir = element.getAttribute("fromdir").getIntValue();
        }
        catch (DataConversionException dataConversionException) {
            log.error("Could not parse path attribute");
        }
        catch (NullPointerException nullPointerException) {
            this.handleException("Block Path entry in file missing required attribute", null, block.getSystemName(), block.getUserName(), null);
        }
        Block toBlock = null;
        if (element.getAttribute("block") != null) {
            String name = element.getAttribute("block").getValue();
            toBlock = InstanceManager.getDefault(BlockManager.class).getBlock(name);
        }
        Path path = new Path(toBlock, toDir, fromDir);
        List settings = element.getChildren("beansetting");
        for (Element setting : settings) {
            this.loadBeanSetting(path, setting);
        }
        if (!block.hasPath(path)) {
            block.addPath(path);
            return true;
        }
        log.debug("Skipping load of duplicate path {}", (Object)path);
        return false;
    }

    public void loadBeanSetting(Path path, Element element) {
        int setting = 0;
        try {
            setting = element.getAttribute("setting").getIntValue();
        }
        catch (DataConversionException dataConversionException) {
            log.error("Could not parse beansetting attribute");
        }
        List turnouts = element.getChildren("turnout");
        if (turnouts.size() != 1) {
            log.error("invalid number of turnout element children");
        }
        String name = ((Element)turnouts.get(0)).getAttribute("systemName").getValue();
        try {
            Turnout t = InstanceManager.turnoutManagerInstance().provideTurnout(name);
            BeanSetting bs = new BeanSetting(t, name, setting);
            path.addSetting(bs);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("failed to create Turnout \"{}\" during Block load", (Object)name);
        }
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(BlockManager.class).getXMLOrder();
    }
}

