/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.configurexml.ErrorHandler;
import jmri.configurexml.ErrorMemo;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.configurexml.XmlAdapter;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXmlAdapter
implements XmlAdapter {
    private ErrorHandler errorHandler = XmlAdapter.getDefaultExceptionHandler();
    private static final Logger log = LoggerFactory.getLogger(AbstractXmlAdapter.class);

    @Override
    public void handleException(String description, String operation, String systemName, String userName, Exception exception) {
        if (this.errorHandler != null) {
            this.errorHandler.handle(new ErrorMemo(this, operation, description, systemName, userName, exception));
        }
    }

    @Override
    public boolean load(Element e) throws JmriConfigureXmlException {
        throw new UnsupportedOperationException("One of the other load methods must be implemented.");
    }

    @Override
    public void load(Element e, Object o) throws JmriConfigureXmlException {
        log.error("Invalid method called");
    }

    @Override
    public boolean load(@Nonnull Element shared, Element perNode) throws JmriConfigureXmlException {
        return this.load(shared);
    }

    @Override
    public void load(@Nonnull Element shared, Element perNode, Object o) throws JmriConfigureXmlException {
        this.load(shared, o);
    }

    @Override
    public boolean loadDeferred() {
        return false;
    }

    @Override
    public int loadOrder() {
        return 50;
    }

    @Override
    public Element store(@Nonnull Object o, boolean shared) {
        if (shared) {
            return this.store(o);
        }
        return null;
    }

    @Override
    public void setExceptionHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getExceptionHandler() {
        return this.errorHandler;
    }

    public final boolean getAttributeBooleanValue(@Nonnull Element element, @Nonnull String name, boolean def) {
        block6: {
            String val;
            block5: {
                val = null;
                try {
                    Attribute a = element.getAttribute(name);
                    if (a == null) {
                        return def;
                    }
                    val = a.getValue();
                    if (!val.equals("yes") && !val.equals("true")) break block5;
                    return true;
                }
                catch (Exception ex) {
                    log.debug("caught exception", (Throwable)ex);
                    ErrorMemo em = new ErrorMemo(this, "getAttributeBooleanValue threw exception", "element: " + element.getName(), "attribute: " + name, "value: " + val, ex);
                    this.getExceptionHandler().handle(em);
                    return def;
                }
            }
            if (!val.equals("no") && !val.equals("false")) break block6;
            return false;
        }
        return def;
    }

    public final int getAttributeIntegerValue(@Nonnull Element element, @Nonnull String name, int def) {
        String val = null;
        try {
            Attribute a = element.getAttribute(name);
            if (a == null) {
                return def;
            }
            val = a.getValue();
            return a.getIntValue();
        }
        catch (Exception ex) {
            log.debug("caught exception", (Throwable)ex);
            ErrorMemo em = new ErrorMemo(this, "getAttributeIntegerValue threw exception", "element: " + element.getName(), "attribute: " + name, "value: " + val, ex);
            this.getExceptionHandler().handle(em);
            return def;
        }
    }

    public final double getAttributeDoubleValue(@Nonnull Element element, @Nonnull String name, double def) {
        String val = null;
        try {
            Attribute a = element.getAttribute(name);
            if (a == null) {
                return def;
            }
            val = a.getValue();
            return a.getDoubleValue();
        }
        catch (Exception ex) {
            log.debug("caught exception", (Throwable)ex);
            ErrorMemo em = new ErrorMemo(this, "getAttributeDoubleValue threw exception", "element: " + element.getName(), "attribute: " + name, "value: " + val, ex);
            this.getExceptionHandler().handle(em);
            return def;
        }
    }

    public final float getAttributeFloatValue(@Nonnull Element element, @Nonnull String name, float def) {
        String val = null;
        try {
            Attribute a = element.getAttribute(name);
            if (a == null) {
                return def;
            }
            val = a.getValue();
            return a.getFloatValue();
        }
        catch (Exception ex) {
            log.debug("caught exception", (Throwable)ex);
            ErrorMemo em = new ErrorMemo(this, "getAttributeFloatValue threw exception", "element: " + element.getName(), "attribute: " + name, "value: " + val, ex);
            this.getExceptionHandler().handle(em);
            return def;
        }
    }

    public static abstract class EnumIO<T extends Enum<T>> {
        @Nonnull
        public abstract String outputFromEnum(@Nonnull T var1);

        @Nonnull
        public abstract T inputFromString(@CheckForNull String var1);

        @Nonnull
        public T inputFromAttribute(@Nonnull Attribute a) {
            return this.inputFromString(a.getValue());
        }
    }

    public static class EnumIoMapped<T extends Enum<T>>
    extends EnumIO<T> {
        final Class<T> clazz;
        final Map<T, String> mapFromEnum;
        final Map<String, T> mapToEnum;

        public EnumIoMapped(@Nonnull Class<T> clazz, @Nonnull Map<String, T> mapToEnum, @Nonnull Map<T, String> mapFromEnum) {
            this.clazz = clazz;
            this.mapToEnum = mapToEnum;
            this.mapFromEnum = mapFromEnum;
        }

        public EnumIoMapped(@Nonnull Class<T> clazz, @Nonnull Map<String, T> mapToEnum) {
            this.clazz = clazz;
            this.mapToEnum = mapToEnum;
            this.mapFromEnum = new HashMap<T, String>();
            Enum[] enumArray = (Enum[])clazz.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum t = enumArray[n2];
                this.mapFromEnum.put(t, t.name());
                ++n2;
            }
        }

        @Override
        @Nonnull
        public String outputFromEnum(@Nonnull T e) {
            String retval = this.mapFromEnum.get(e);
            log.trace("from {} make String {} for {}", new Object[]{e, retval, this.clazz});
            return retval;
        }

        @Override
        @Nonnull
        public T inputFromString(@CheckForNull String s) {
            if (s == null) {
                log.error("from String null get {} for {}", (Object)((Enum[])this.clazz.getEnumConstants())[0].name(), this.clazz);
                return (T)((Enum[])this.clazz.getEnumConstants())[0];
            }
            try {
                Enum retval = (Enum)this.mapToEnum.get(s);
                if (retval == null) {
                    log.error("from String {} get {} for {}", new Object[]{s, ((Enum[])this.clazz.getEnumConstants())[0].name(), this.clazz});
                    return (T)((Enum[])this.clazz.getEnumConstants())[0];
                }
                log.trace("from String {} get {} for {}", new Object[]{s, retval, this.clazz});
                return (T)retval;
            }
            catch (RuntimeException e) {
                log.error("from String {} get {} for {}", new Object[]{s, ((Enum[])this.clazz.getEnumConstants())[0].name(), this.clazz, e});
                return (T)((Enum[])this.clazz.getEnumConstants())[0];
            }
        }
    }

    public static class EnumIoNames<T extends Enum<T>>
    extends EnumIO<T> {
        final Class<T> clazz;
        final Map<String, T> mapToEnum;

        public EnumIoNames(@Nonnull Class<T> clazz) {
            this.clazz = clazz;
            this.mapToEnum = new HashMap<String, T>();
            Enum[] enumArray = (Enum[])clazz.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum t = enumArray[n2];
                this.mapToEnum.put(t.name(), t);
                ++n2;
            }
        }

        @Override
        @Nonnull
        public String outputFromEnum(@Nonnull T e) {
            String retval = ((Enum)e).name();
            log.trace("from {} make String {} for {}", new Object[]{e, retval, this.clazz});
            return retval;
        }

        @Override
        @Nonnull
        public T inputFromString(@CheckForNull String s) {
            if (s == null) {
                log.error("from String null get {} for {}", (Object)((Enum[])this.clazz.getEnumConstants())[0].name(), this.clazz);
                return (T)((Enum[])this.clazz.getEnumConstants())[0];
            }
            Enum retval = (Enum)this.mapToEnum.get(s);
            if (retval == null) {
                log.error("from String {} get {} for {}", new Object[]{s, ((Enum[])this.clazz.getEnumConstants())[0].name(), this.clazz});
                return (T)((Enum[])this.clazz.getEnumConstants())[0];
            }
            log.trace("from String {} get {} for {}", new Object[]{s, retval, this.clazz});
            return (T)retval;
        }
    }

    public static class EnumIoNamesNumbers<T extends Enum<T>>
    extends EnumIoNames<T> {
        public EnumIoNamesNumbers(@Nonnull Class<T> clazz) {
            super(clazz);
            Enum[] enumArray = (Enum[])clazz.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum t = enumArray[n2];
                this.mapToEnum.put(Integer.toString(t.ordinal()), t);
                ++n2;
            }
        }
    }

    public static class EnumIoOrdinals<T extends Enum<T>>
    extends EnumIO<T> {
        final Class<T> clazz;

        public EnumIoOrdinals(@Nonnull Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        @Nonnull
        public String outputFromEnum(@Nonnull T e) {
            int ordinal = ((Enum)e).ordinal();
            return Integer.toString(ordinal);
        }

        @Override
        @Nonnull
        public T inputFromString(@CheckForNull String s) {
            if (s == null) {
                log.error("from String null get {} for {}", (Object)((Enum[])this.clazz.getEnumConstants())[0].name(), this.clazz);
                return (T)((Enum[])this.clazz.getEnumConstants())[0];
            }
            try {
                int content = Integer.parseInt(s);
                return (T)((Enum[])this.clazz.getEnumConstants())[content];
            }
            catch (RuntimeException e) {
                log.error("from String {} get {} for {}", new Object[]{s, ((Enum[])this.clazz.getEnumConstants())[0].name(), this.clazz, e});
                return (T)((Enum[])this.clazz.getEnumConstants())[0];
            }
        }
    }
}

