/*
 * Decompiled with CFR 0.152.
 */
package jmri.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jmri.util.ThreadingUtil;

public class SwingPropertyChangeListener
implements PropertyChangeListener {
    private final PropertyChangeListener listener;
    private final boolean notifyOnEDT;

    public SwingPropertyChangeListener(PropertyChangeListener listener) {
        this(listener, true);
    }

    public SwingPropertyChangeListener(PropertyChangeListener listener, boolean notifyOnEDT) {
        this.listener = listener;
        this.notifyOnEDT = notifyOnEDT;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.notifyOnEDT || ThreadingUtil.isGUIThread()) {
            this.listener.propertyChange(evt);
        } else {
            ThreadingUtil.runOnGUI(() -> this.listener.propertyChange(evt));
        }
    }

    public boolean isNotifyOnEDT() {
        return this.notifyOnEDT;
    }
}

