/*
 * Decompiled with CFR 0.152.
 */
package jmri.beans;

import java.beans.PropertyChangeEvent;
import javax.annotation.Nonnull;
import jmri.beans.Bean;
import jmri.profile.Profile;

public abstract class PreferencesBean
extends Bean {
    public static final String DIRTY = "dirty";
    public static final String RESTART_REQUIRED = "restartRequired";
    private boolean restartRequired = false;
    private boolean isDirty = false;
    private final Profile profile;

    public PreferencesBean(Profile profile) {
        super(false);
        this.profile = profile;
    }

    @Nonnull
    public Profile getProfile() {
        return this.profile;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    protected void setRestartRequired() {
        if (!this.restartRequired) {
            this.restartRequired = true;
            this.firePropertyChange(RESTART_REQUIRED, false, true);
        }
    }

    protected void setIsDirty(boolean value) {
        boolean old = this.isDirty;
        this.isDirty = value;
        this.firePropertyChange(DIRTY, old, value);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
            this.setIsDirty(true);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
            if (!DIRTY.equals(propertyName)) {
                this.setIsDirty(true);
            }
        }
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
            this.setIsDirty(true);
        }
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
        if (!DIRTY.equals(evt.getPropertyName())) {
            this.setIsDirty(true);
        }
    }
}

