/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.util.ResourceBundle;
import jmri.Bundle;

public class Version {
    private static final ResourceBundle VERSION_BUNDLE = ResourceBundle.getBundle("jmri.Version");
    public static final int major = Integer.parseInt(VERSION_BUNDLE.getString("release.major"));
    public static final int minor = Integer.parseInt(VERSION_BUNDLE.getString("release.minor"));
    public static final int test = Integer.parseInt(VERSION_BUNDLE.getString("release.build"));
    public static final String MODIFIER = VERSION_BUNDLE.getString("release.modifier");
    public static final String NON_OFFICIAL = "ish";
    public static final String buildUser = VERSION_BUNDLE.getString("release.build_user");
    public static final String revisionId = VERSION_BUNDLE.getString("release.revision_id");
    public static final String buildDate = VERSION_BUNDLE.getString("release.build_date");
    public static final boolean official = Boolean.parseBoolean(VERSION_BUNDLE.getString("release.official"));

    public static String getModifier() {
        StringBuilder modifier = new StringBuilder();
        if (!official) {
            modifier.append(NON_OFFICIAL);
        }
        if (!MODIFIER.isEmpty()) {
            modifier.append("-").append(MODIFIER);
        }
        return modifier.toString().replace("--", "-");
    }

    public static String name() {
        String version = String.valueOf(major) + "." + minor;
        if (test != 0) {
            version = String.valueOf(version) + "." + test;
        }
        String addOn = official ? ("unknown".equals(revisionId) ? buildDate : "R" + revisionId) : ("unknown".equals(revisionId) ? String.valueOf(buildUser) + "+" + buildDate : String.valueOf(buildUser) + "+" + buildDate + "+R" + revisionId);
        return String.valueOf(version) + Version.getModifier() + "+" + addOn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isCanonicalVersion(String version) {
        String[] parts = version.split("\\+");
        if (parts.length > 1) {
            return false;
        }
        parts = version.split("-");
        String[] versions = parts[0].split("\\.");
        if (versions.length != 3) {
            return false;
        }
        try {
            String[] stringArray = versions;
            int n = versions.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                String part = stringArray[n2];
                if (Integer.parseInt(part) < 0) {
                    return false;
                }
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static int compareCanonicalVersions(String version) throws IllegalArgumentException {
        return Version.compareCanonicalVersions(version, Version.getCanonicalVersion());
    }

    public static int compareCanonicalVersions(String version1, String version2) throws IllegalArgumentException {
        int result = 0;
        if (!Version.isCanonicalVersion(version1)) {
            throw new IllegalArgumentException("Parameter version1 (" + version1 + ") is not a canonical version string.");
        }
        if (!Version.isCanonicalVersion(version2)) {
            throw new IllegalArgumentException("Parameter version2 (" + version2 + ") is not a canonical version string.");
        }
        String[] p1 = version1.split("-");
        String[] p2 = version2.split("-");
        String[] v1 = p1[0].split("\\.");
        String[] v2 = p2[0].split("\\.");
        int i = 0;
        while (i < 3) {
            result = v1[i].compareTo(v2[i]);
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return result;
    }

    public static String getCanonicalVersion() {
        String version = String.valueOf(major) + "." + minor + "." + test;
        String modifiers = Version.getModifier().replace(NON_OFFICIAL, "");
        if (!modifiers.isEmpty()) {
            version = String.valueOf(version) + modifiers;
        }
        if (version.endsWith("-")) {
            version = version.substring(0, version.length() - 2);
        }
        return version;
    }

    public static String getCopyright() {
        return Bundle.getMessage("Copyright", VERSION_BUNDLE.getString("jmri.copyright.year"));
    }

    public static void main(String[] args) {
        System.out.println(Version.name());
    }
}

