/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.Turnout;
import jmri.TurnoutOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutOperationManager
implements InstanceManagerAutoDefault {
    private final SortedMap<String, TurnoutOperation> turnoutOperations = new TreeMap<String, TurnoutOperation>();
    private List<TurnoutOperation> operationTypes = new LinkedList<TurnoutOperation>();
    boolean doOperations = false;
    private boolean initialized = false;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(TurnoutOperationManager.class);

    private void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            this.loadOperationTypes();
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TurnoutOperation[] getTurnoutOperations() {
        TurnoutOperationManager turnoutOperationManager = this;
        synchronized (turnoutOperationManager) {
            this.initialize();
            Collection<TurnoutOperation> entries = this.turnoutOperations.values();
            return entries.toArray(new TurnoutOperation[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOperation(@Nonnull TurnoutOperation op) {
        TurnoutOperation previous;
        Objects.requireNonNull(op, "TurnoutOperations cannot be null");
        TurnoutOperationManager turnoutOperationManager = this;
        synchronized (turnoutOperationManager) {
            this.initialize();
            previous = this.turnoutOperations.put(op.getName(), op);
            if (op.isDefinitive()) {
                this.updateTypes(op);
            }
        }
        if (previous != null) {
            log.debug("replaced existing operation called {}", (Object)previous.getName());
        }
        this.firePropertyChange("Content", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOperation(@Nonnull TurnoutOperation op) {
        Objects.requireNonNull(op, "TurnoutOperations cannot be null");
        TurnoutOperationManager turnoutOperationManager = this;
        synchronized (turnoutOperationManager) {
            this.initialize();
            this.turnoutOperations.remove(op.getName());
        }
        this.firePropertyChange("Content", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TurnoutOperation getOperation(@Nonnull String name) {
        TurnoutOperationManager turnoutOperationManager = this;
        synchronized (turnoutOperationManager) {
            this.initialize();
            return (TurnoutOperation)this.turnoutOperations.get(name);
        }
    }

    private void updateTypes(@Nonnull TurnoutOperation op) {
        this.initialize();
        LinkedList<TurnoutOperation> newTypes = new LinkedList<TurnoutOperation>();
        Iterator<TurnoutOperation> iter = this.operationTypes.iterator();
        boolean found = false;
        while (iter.hasNext()) {
            TurnoutOperation item = iter.next();
            if (item.getClass() == op.getClass()) {
                newTypes.add(op);
                found = true;
                log.debug("replacing definitive instance of {}", item.getClass());
                continue;
            }
            newTypes.add(item);
        }
        if (!found) {
            newTypes.add(op);
            log.debug("adding definitive instance of {}", op.getClass());
        }
        this.operationTypes = newTypes;
    }

    public void loadOperationTypes() {
        String[] validTypes = InstanceManager.turnoutManagerInstance().getValidOperationTypes();
        int i = 0;
        while (i < validTypes.length) {
            String thisClassName = "jmri." + validTypes[i] + "TurnoutOperation";
            if (validTypes[i] == null) {
                log.warn("null operation name in loadOperationTypes");
            } else if (this.getOperation(validTypes[i]) == null) {
                try {
                    Class<?> thisClass = Class.forName(thisClassName);
                    thisClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    log.debug("loaded TurnoutOperation class {}", (Object)thisClassName);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e1) {
                    log.error("during loadOperationTypes", (Throwable)e1);
                }
            }
            ++i;
        }
    }

    public TurnoutOperation getMatchingOperationAlways(@Nonnull Turnout t, int apparentMode) {
        this.initialize();
        Iterator<TurnoutOperation> iter = this.operationTypes.iterator();
        TurnoutOperation currentMatch = null;
        while (iter.hasNext()) {
            TurnoutOperation oper = iter.next();
            if (!oper.matchFeedbackMode(apparentMode)) continue;
            currentMatch = oper;
        }
        if (currentMatch != null) {
            return currentMatch;
        }
        return null;
    }

    public TurnoutOperation getMatchingOperation(@Nonnull Turnout t, int apparentMode) {
        this.initialize();
        if (this.doOperations) {
            return this.getMatchingOperationAlways(t, apparentMode);
        }
        return null;
    }

    public TurnoutOperation getMatchingOperationAlways(@Nonnull Turnout t) {
        return this.getMatchingOperationAlways(t, t.getFeedbackMode());
    }

    public boolean getDoOperations() {
        this.initialize();
        return this.doOperations;
    }

    public void setDoOperations(boolean b) {
        this.initialize();
        boolean oldValue = this.doOperations;
        this.doOperations = b;
        this.firePropertyChange("doOperations", oldValue, b);
    }

    public static String[] concatenateTypeLists(@Nonnull String[] types) {
        LinkedList<String> outTypes = new LinkedList<String>();
        boolean noFeedbackWanted = false;
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if ("NoFeedback".equals(type)) {
                noFeedbackWanted = true;
            } else if (type == null || type.isEmpty()) {
                log.warn("null or empty operation name returned from turnout manager");
            } else if (!outTypes.contains(type)) {
                outTypes.add(type);
            }
            ++n2;
        }
        if (noFeedbackWanted) {
            outTypes.add("NoFeedback");
        }
        return outTypes.toArray(new String[0]);
    }

    public synchronized void addPropertyChangeListener(@Nonnull PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(@Nonnull PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(@Nonnull String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }
}

