/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Block;
import jmri.Bundle;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.NamedBean;
import jmri.Section;
import jmri.SectionManager;
import jmri.Transit;
import jmri.managers.AbstractManager;

public class TransitManager
extends AbstractManager<Transit>
implements InstanceManagerAutoDefault {
    public TransitManager() {
        this.addVetoListener();
    }

    final void addVetoListener() {
        InstanceManager.getDefault(SectionManager.class).addVetoableChangeListener(this);
    }

    @Override
    public int getXMLOrder() {
        return 140;
    }

    @Override
    public char typeLetter() {
        return 'Z';
    }

    @Nonnull
    public Transit createNewTransit(@CheckForNull String systemName, String userName) throws NamedBean.BadNameException {
        Transit z;
        if (systemName == null || systemName.isEmpty()) {
            throw new NamedBean.BadSystemNameException("Transit System Name cannot be empty or null.", Bundle.getMessage("InvalidBeanSystemNameEmpty", this.getBeanTypeHandled(false)));
        }
        String sysName = systemName;
        if (!sysName.startsWith(this.getSystemNamePrefix())) {
            sysName = this.makeSystemName(sysName);
        }
        if (userName != null && !userName.isEmpty() && (z = (Transit)this.getByUserName(userName)) != null) {
            throw new NamedBean.BadUserNameException("Transit UserName \"" + userName + "\" Already Exists.", Bundle.getMessage("InvalidUserNameAlreadyExists", this.getBeanTypeHandled(false), sysName));
        }
        z = (Transit)this.getBySystemName(sysName);
        if (z != null) {
            throw new NamedBean.DuplicateSystemNameException("Transit SytemName \"" + sysName + "\" Already Exists.", Bundle.getMessage("InvalidSytemNameAlreadyExists", this.getBeanTypeHandled(false), sysName));
        }
        z = new Transit(sysName, userName);
        this.register(z);
        this.updateAutoNumber(systemName);
        return z;
    }

    @Nonnull
    public Transit createNewTransit(String userName) throws NamedBean.BadNameException {
        return this.createNewTransit(this.getAutoSystemName(), userName);
    }

    @CheckForNull
    public Transit getTransit(String name) {
        Transit z = (Transit)this.getByUserName(name);
        return z != null ? z : (Transit)this.getBySystemName(name);
    }

    public void deleteTransit(Transit z) {
        this.deregister(z);
        z.dispose();
    }

    @Nonnull
    public ArrayList<Transit> getListUsingSection(Section s) {
        ArrayList<Transit> list = new ArrayList<Transit>();
        for (Transit tTransit : this.getNamedBeanSet()) {
            if (!tTransit.containsSection(s)) continue;
            list.add(tTransit);
        }
        return list;
    }

    @Nonnull
    public ArrayList<Transit> getListUsingBlock(Block b) {
        ArrayList<Transit> list = new ArrayList<Transit>();
        for (Transit tTransit : this.getNamedBeanSet()) {
            if (!tTransit.containsBlock(b)) continue;
            list.add(tTransit);
        }
        return list;
    }

    @Nonnull
    public ArrayList<Transit> getListEntryBlock(Block b) {
        ArrayList<Transit> list = new ArrayList<Transit>();
        for (Transit tTransit : this.getNamedBeanSet()) {
            ArrayList<Block> entryBlock = tTransit.getEntryBlocksList();
            if (!entryBlock.contains(b)) continue;
            list.add(tTransit);
        }
        return list;
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameTransits" : "BeanNameTransit");
    }

    @Override
    public Class<Transit> getNamedBeanClass() {
        return Transit.class;
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(SectionManager.class).removeVetoableChangeListener(this);
        super.dispose();
    }
}

